/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtaether.blocks;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.api.treedata.TreePart;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictreesplus.block.mushroom.CapProperties;
import com.ferreusveritas.dynamictreesplus.block.mushroom.DynamicCapBlock;
import com.ferreusveritas.dynamictreesplus.block.mushroom.DynamicCapCenterBlock;
import com.ferreusveritas.dynamictreesplus.tree.HugeMushroomSpecies;
import maxhyper.dtaether.blocks.DropBlocksCapProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.zepalesque.redux.block.ReduxBlocks;
import net.zepalesque.redux.client.audio.ReduxSoundEvents;

public class JellyshroomCapProperties
extends DropBlocksCapProperties {
    public static final TypedRegistry.EntryType<CapProperties> TYPE = TypedRegistry.newType(JellyshroomCapProperties::new);

    public JellyshroomCapProperties(ResourceLocation registryName) {
        super(registryName);
    }

    public BlockBehaviour.Properties getDefaultBlockProperties(MapColor mapColor) {
        return super.getDefaultBlockProperties(mapColor).m_60955_().m_60960_(ReduxBlocks::never).m_60971_(ReduxBlocks::never);
    }

    protected DynamicCapBlock createDynamicCap(BlockBehaviour.Properties properties) {
        return new DynamicCapBlock(this, properties){

            public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
                return 0.5f;
            }

            public void m_142072_(Level pLevel, BlockState pState, BlockPos pPos, Entity pEntity, float pFallDistance) {
                if (pEntity.m_20162_()) {
                    super.m_142072_(pLevel, pState, pPos, pEntity, pFallDistance);
                } else {
                    Player player;
                    pEntity.m_142535_(pFallDistance, 0.0f, pLevel.m_269111_().m_268989_());
                    Player var10001 = pEntity instanceof Player ? (player = (Player)pEntity) : null;
                    pLevel.m_5594_(var10001, pPos, (SoundEvent)ReduxSoundEvents.FUNGUS_BOUNCE.get(), SoundSource.BLOCKS, Math.min(pFallDistance / 10.0f, 0.8f), 0.9f + pLevel.f_46441_.m_188501_() * 0.2f);
                }
            }

            public void m_5548_(BlockGetter pLevel, Entity pEntity) {
                if (pEntity.m_20162_()) {
                    super.m_5548_(pLevel, pEntity);
                } else {
                    this.bounceUp(pEntity);
                }
            }

            private void bounceUp(Entity pEntity) {
                Vec3 vec3 = pEntity.m_20184_();
                if (vec3.f_82480_ < 0.0) {
                    double d0 = pEntity instanceof LivingEntity ? 0.95 : 0.85;
                    pEntity.m_20334_(vec3.f_82479_, -vec3.f_82480_ * d0, vec3.f_82481_);
                }
            }

            public void m_141947_(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity) {
                double d0 = Math.abs(pEntity.m_20184_().f_82480_);
                if (d0 < 0.1 && !pEntity.m_20161_()) {
                    double d1 = 0.4 + d0 * 0.2;
                    pEntity.m_20256_(pEntity.m_20184_().m_82542_(d1, 1.0, d1));
                }
                super.m_141947_(pLevel, pPos, pState, pEntity);
            }

            public VoxelShape m_5909_(BlockState pState, BlockGetter pReader, BlockPos pPos, CollisionContext pContext) {
                return Shapes.m_83040_();
            }

            public boolean m_7420_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
                return true;
            }

            public boolean m_6104_(BlockState pState, BlockState pAdjacentBlockState, Direction pSide) {
                return this.f_60439_.isPartOfCap(pAdjacentBlockState) || super.m_6104_(pState, pAdjacentBlockState, pSide);
            }
        };
    }

    protected DynamicCapCenterBlock createDynamicCapCenter(BlockBehaviour.Properties properties) {
        return new DynamicCapCenterBlock(this, properties){

            public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
                return 0.5f;
            }

            public void m_142072_(Level pLevel, BlockState pState, BlockPos pPos, Entity pEntity, float pFallDistance) {
                if (pEntity.m_20162_()) {
                    super.m_142072_(pLevel, pState, pPos, pEntity, pFallDistance);
                } else {
                    Player player;
                    pEntity.m_142535_(pFallDistance, 0.0f, pLevel.m_269111_().m_268989_());
                    Player var10001 = pEntity instanceof Player ? (player = (Player)pEntity) : null;
                    pLevel.m_5594_(var10001, pPos, (SoundEvent)ReduxSoundEvents.FUNGUS_BOUNCE.get(), SoundSource.BLOCKS, Math.min(pFallDistance / 10.0f, 0.8f), 0.9f + pLevel.f_46441_.m_188501_() * 0.2f);
                }
            }

            public void m_5548_(BlockGetter pLevel, Entity pEntity) {
                if (pEntity.m_20162_()) {
                    super.m_5548_(pLevel, pEntity);
                } else {
                    this.bounceUp(pEntity);
                }
            }

            private void bounceUp(Entity pEntity) {
                Vec3 vec3 = pEntity.m_20184_();
                if (vec3.f_82480_ < 0.0) {
                    double d0 = pEntity instanceof LivingEntity ? 0.95 : 0.85;
                    pEntity.m_20334_(vec3.f_82479_, -vec3.f_82480_ * d0, vec3.f_82481_);
                }
            }

            public void m_141947_(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity) {
                double d0 = Math.abs(pEntity.m_20184_().f_82480_);
                if (d0 < 0.1 && !pEntity.m_20161_()) {
                    double d1 = 0.4 + d0 * 0.2;
                    pEntity.m_20256_(pEntity.m_20184_().m_82542_(d1, 1.0, d1));
                }
                super.m_141947_(pLevel, pPos, pState, pEntity);
            }

            public VoxelShape m_5909_(BlockState pState, BlockGetter pReader, BlockPos pPos, CollisionContext pContext) {
                return Shapes.m_83040_();
            }

            public boolean m_7420_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
                return true;
            }

            public boolean m_6104_(BlockState pState, BlockState pAdjacentBlockState, Direction pSide) {
                return this.f_60439_.isPartOfCap(pAdjacentBlockState) || super.m_6104_(pState, pAdjacentBlockState, pSide);
            }

            public boolean tryGrowCap(Level level, CapProperties capProp, int currentAge, GrowSignal signal, BlockPos pos, BlockPos previousPos, boolean forceAge) {
                Species var9 = signal.getSpecies();
                if (var9 instanceof HugeMushroomSpecies) {
                    HugeMushroomSpecies species = (HugeMushroomSpecies)var9;
                    if (!level.m_46859_(pos) && !(level.m_8055_(pos).m_60734_() instanceof DynamicCapBlock)) {
                        TreePart treePart = TreeHelper.getTreePart((BlockState)level.m_8055_(pos));
                        return treePart instanceof DynamicCapCenterBlock;
                    }
                    int age = currentAge;
                    if (currentAge == 0) {
                        age = 1;
                    } else if (forceAge || level.m_213780_().m_188501_() < species.getChanceToAge()) {
                        age = Math.min(age + 1, this.f_60439_.getMaxAge(species));
                    }
                    level.m_7731_(pos, this.getCapBlockStateForPlacement((LevelAccessor)level, pos, age == 0 ? 1 : age, capProp.getDynamicCapState(true), false), 2);
                    if (age != currentAge) {
                        this.ageBranchUnderCap(level, pos, signal, currentAge);
                    }
                    if (!(signal.getSpecies() instanceof HugeMushroomSpecies)) {
                        return false;
                    }
                    this.generateCap(age, level, (HugeMushroomSpecies)signal.getSpecies(), pos, previousPos, currentAge, signal.rootPos);
                    return true;
                }
                return false;
            }
        };
    }
}

