/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtaether.cells;

import com.ferreusveritas.dynamictrees.api.cell.Cell;
import com.ferreusveritas.dynamictrees.api.cell.CellKit;
import com.ferreusveritas.dynamictrees.api.cell.CellNull;
import com.ferreusveritas.dynamictrees.api.cell.CellSolver;
import com.ferreusveritas.dynamictrees.api.registry.Registry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import com.ferreusveritas.dynamictrees.cell.CellKits;
import com.ferreusveritas.dynamictrees.cell.ConiferTopBranchCell;
import com.ferreusveritas.dynamictrees.cell.NormalCell;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import maxhyper.dtaether.DynamicTreesAether;
import maxhyper.dtaether.cells.BlightwillowLeafCell;
import maxhyper.dtaether.cells.DTAetherLeafClusters;

public class DTAetherCellKits {
    public static final CellKit BLIGHTWILLOW = new CellKit(DynamicTreesAether.location("blightwillow")){
        private final Cell blightwillowBranch = new NormalCell(3);
        private final Cell coniferTopBranch = new ConiferTopBranchCell();
        private final Cell[] coniferLeafCells = new Cell[]{CellNull.NULL_CELL, new BlightwillowLeafCell(1), new BlightwillowLeafCell(2), new BlightwillowLeafCell(3), new BlightwillowLeafCell(4), new BlightwillowLeafCell(5), new BlightwillowLeafCell(6), new BlightwillowLeafCell(7)};
        private final CellKits.BasicSolver blightwillowSolver = new CellKits.BasicSolver(new short[]{1300, 1043, 786, 545});

        public Cell getCellForLeaves(int hydro) {
            return this.coniferLeafCells[hydro];
        }

        public Cell getCellForBranch(int radius, int meta) {
            if (meta == 1) {
                return this.coniferTopBranch;
            }
            if (radius == 1) {
                return this.blightwillowBranch;
            }
            return CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTAetherLeafClusters.BLIGHTWILLOW;
        }

        public CellSolver getCellSolver() {
            return this.blightwillowSolver;
        }

        public int getDefaultHydration() {
            return 4;
        }
    };

    public static void register(Registry<CellKit> registry) {
        registry.registerAll((RegistryEntry[])new CellKit[]{BLIGHTWILLOW});
    }
}

