/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtaether.genfeatures;

import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.block.rooty.SoilHelper;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.FullGenerationContext;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ChangeGrassGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Block> BLOCK = ConfigurationProperty.block((String)"block");
    public static final ConfigurationProperty<Integer> MAX_DEPTH = ConfigurationProperty.integer((String)"max_depth");
    public static final ConfigurationProperty<String> REPLACEABLE_SOILS = ConfigurationProperty.string((String)"replaceable_soils");

    public ChangeGrassGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{BLOCK, MAX_DEPTH, REPLACEABLE_SOILS});
    }

    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(BLOCK, (Object)Blocks.f_50016_)).with(MAX_DEPTH, (Object)6)).with(REPLACEABLE_SOILS, (Object)"dirt_like");
    }

    public boolean shouldApply(Species species, GenFeatureConfiguration configuration) {
        if (configuration.get(BLOCK) == Blocks.f_50016_) {
            return false;
        }
        return SoilHelper.isSoilRegistered((Block)((Block)configuration.get(BLOCK)));
    }

    protected boolean generate(GenFeatureConfiguration configuration, FullGenerationContext context) {
        int rad = context.radius();
        int startH = context.species().getLowestBranchHeight() + 3;
        int layers = startH + (Integer)configuration.get(MAX_DEPTH);
        BlockPos.MutableBlockPos placePos = context.pos().m_6630_(startH).m_122032_();
        LevelAccessor level = context.level();
        BlockState placeState = ((Block)configuration.get(BLOCK)).m_49966_();
        String soilTag = (String)configuration.get(REPLACEABLE_SOILS);
        for (int i = 0; i < layers; ++i) {
            this.placeCircle(level, placePos.m_122024_().m_122012_(), placeState, soilTag);
            this.placeCircle(level, placePos.m_122030_(2).m_122012_(), placeState, soilTag);
            this.placeCircle(level, placePos.m_122024_().m_122020_(2), placeState, soilTag);
            this.placeCircle(level, placePos.m_122030_(2).m_122020_(2), placeState, soilTag);
            for (int j = 0; j < 5; ++j) {
                int k = context.random().m_188503_(48);
                int l = k % rad;
                int i1 = k / rad;
                if (l != 0 && l != 7 && i1 != 0 && i1 != 7) continue;
                this.placeCircle(level, placePos.m_7918_(-3 + l, 0, -3 + i1), placeState, soilTag);
            }
            placePos.m_122184_(0, -1, 0);
        }
        return false;
    }

    private void placeCircle(LevelAccessor level, BlockPos pos, BlockState placeState, String soilTag) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                this.placeBlockAt(level, pos.m_7918_(i, 0, j), placeState, soilTag);
            }
        }
    }

    private void placeBlockAt(LevelAccessor level, BlockPos pos, BlockState placeState, String soilTag) {
        for (int i = 2; i >= -3; --i) {
            BlockPos blockpos = pos.m_6630_(i);
            if (this.isAcceptableSoil((LevelSimulatedReader)level, blockpos, soilTag) && !level.m_8055_(blockpos.m_7494_()).m_60838_((BlockGetter)level, blockpos.m_7494_())) {
                level.m_7731_(blockpos, placeState, 2);
                break;
            }
            if (!level.m_46859_(blockpos) && i < 0) break;
        }
    }

    public boolean isAcceptableSoil(LevelSimulatedReader level, BlockPos pos, String soilTag) {
        return level.m_7433_(pos, s -> SoilHelper.isSoilAcceptable((BlockState)s, (int)SoilHelper.getSoilFlags((String[])new String[]{soilTag})));
    }
}

