/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtaether.genfeatures;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.systems.nodemapper.FindEndsNode;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import java.util.List;
import maxhyper.dtaether.compat.CompatHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraftforge.common.IPlantable;

public class PetalsGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Block> BLOCK = ConfigurationProperty.block((String)"block");
    public static final ConfigurationProperty<Integer> MAX_DEPTH = ConfigurationProperty.integer((String)"max_depth");
    public static final ConfigurationProperty<Integer> RADIUS = ConfigurationProperty.integer((String)"radius");

    public PetalsGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{BLOCK, MAX_DEPTH, RADIUS, PLACE_CHANCE, MAX_COUNT});
    }

    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(BLOCK, (Object)Blocks.f_50016_)).with(MAX_DEPTH, (Object)15)).with(RADIUS, (Object)3)).with(PLACE_CHANCE, (Object)Float.valueOf(0.01f))).with(MAX_COUNT, (Object)20);
    }

    public boolean shouldApply(Species species, GenFeatureConfiguration configuration) {
        if (configuration.get(BLOCK) == Blocks.f_50016_) {
            return false;
        }
        if (CompatHandler.blockStateProperties == null) {
            return false;
        }
        BlockState state = ((Block)configuration.get(BLOCK)).m_49966_();
        return CompatHandler.blockStateProperties.hasPrismaticness(state) && state.m_61138_((Property)BlockStateProperties.f_61374_);
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        LevelAccessor level = context.level();
        int count = level.m_213780_().m_188503_(((Integer)configuration.get(MAX_COUNT)).intValue());
        this.rainDownPetalsFromEndpoints(configuration, level, context.endPoints(), count);
        return super.postGenerate(configuration, context);
    }

    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        if (!context.natural() || context.fertility() == 0) {
            return false;
        }
        LevelAccessor level = context.level();
        if (level.m_213780_().m_188501_() >= ((Float)configuration.get(PLACE_CHANCE)).floatValue()) {
            return false;
        }
        BlockPos rootPos = context.pos();
        FindEndsNode endFinder = new FindEndsNode();
        TreeHelper.startAnalysisFromRoot((LevelAccessor)level, (BlockPos)rootPos, (MapSignal)new MapSignal(new NodeInspector[]{endFinder}));
        List endPoints = endFinder.getEnds();
        this.rainDownPetalsFromEndpoints(configuration, level, endPoints, 1);
        return super.postGrow(configuration, context);
    }

    protected void rainDownPetalsFromEndpoints(GenFeatureConfiguration configuration, LevelAccessor level, List<BlockPos> endPoints, int placeCount) {
        if (endPoints.size() == 0) {
            return;
        }
        int[] place = new int[endPoints.size()];
        for (int i = 0; i < placeCount; ++i) {
            int n = level.m_213780_().m_188503_(endPoints.size());
            place[n] = place[n] + 1;
        }
        int rad = (Integer)configuration.get(RADIUS);
        for (int i = 0; i < endPoints.size(); ++i) {
            if (place[i] == 0) continue;
            BlockPos end = endPoints.get(i);
            for (BlockPos pos : BlockPos.m_235641_((RandomSource)level.m_213780_(), (int)place[i], (int)(end.m_123341_() - rad), (int)end.m_123342_(), (int)(end.m_123343_() - rad), (int)(end.m_123341_() + rad), (int)end.m_123342_(), (int)(end.m_123343_() + rad))) {
                this.tryPlacePetal(configuration, level, pos);
            }
        }
    }

    protected boolean tryPlacePetal(GenFeatureConfiguration configuration, LevelAccessor level, BlockPos pos) {
        for (int i = 1; i < (Integer)configuration.get(MAX_DEPTH); ++i) {
            BlockPos testPos = pos.m_6625_(i);
            BlockState testState = level.m_8055_(testPos);
            if (TreeHelper.isTreePart((BlockState)testState)) continue;
            Block petalsBlock = (Block)configuration.get(BLOCK);
            if (testState.m_60838_((BlockGetter)level, testPos) || testState.m_60713_(petalsBlock)) break;
            if (!level.m_46859_(testPos) || !this.canBePlacedOnBlock(level, testPos.m_7495_(), petalsBlock)) continue;
            level.m_7731_(testPos, this.getPetalsForPlacement(configuration, level, testPos, petalsBlock.m_49966_()), 3);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean canBePlacedOnBlock(LevelAccessor level, BlockPos pos, Block block) {
        if (!(block instanceof IPlantable)) return false;
        IPlantable pPetalsBlock = (IPlantable)block;
        if (!level.m_8055_(pos).canSustainPlant((BlockGetter)level, pos, Direction.UP, pPetalsBlock)) return false;
        return true;
    }

    protected BlockState getPetalsForPlacement(GenFeatureConfiguration configuration, LevelAccessor level, BlockPos pos, BlockState state) {
        XoroshiroRandomSource rand = new XoroshiroRandomSource(Mth.m_14057_((Vec3i)pos));
        Direction d = Direction.Plane.HORIZONTAL.m_235690_((RandomSource)rand);
        BlockState b = this.selectRandomFlowers(pos, level, state);
        return (BlockState)b.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)d);
    }

    private BlockState selectRandomFlowers(BlockPos pos, LevelAccessor level, BlockState state) {
        for (int i = 1; i <= 4; ++i) {
            if (i != 1 && !((double)level.m_213780_().m_188501_() < 0.37)) continue;
            XoroshiroRandomSource rand = new XoroshiroRandomSource(Mth.m_14057_((Vec3i)pos) + (long)i);
            state = CompatHandler.blockStateProperties.setPrismaticness(state, i, rand.m_188503_(7));
        }
        return state;
    }
}

