/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtaether.genfeatures;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.block.branch.TrunkShellBlock;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.systems.nodemapper.FindEndsNode;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class SporesGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Block> BLOCK = ConfigurationProperty.block((String)"block");

    public SporesGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{BLOCK, PLACE_CHANCE});
    }

    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(BLOCK, (Object)Blocks.f_50016_)).with(PLACE_CHANCE, (Object)Float.valueOf(0.01f));
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        BlockPos.MutableBlockPos testPos = context.pos().m_7494_().m_122032_();
        while (TreeHelper.isBranch((BlockState)context.level().m_8055_((BlockPos)testPos))) {
            testPos.m_122184_(0, 1, 0);
        }
        BlockPos end = testPos.m_7949_().m_7495_();
        for (CoordUtils.Surround surr : CoordUtils.Surround.values()) {
            BlockPos pos = end.m_121955_(surr.getOffset());
            context.level().m_7731_(pos, ((Block)configuration.get(BLOCK)).m_49966_(), 3);
        }
        return true;
    }

    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        if (!context.natural() || context.fertility() == 0) {
            return false;
        }
        BlockPos rootPos = context.pos();
        FindEndsNode endFinder = new FindEndsNode();
        TreeHelper.startAnalysisFromRoot((LevelAccessor)context.level(), (BlockPos)rootPos, (MapSignal)new MapSignal(new NodeInspector[]{endFinder}));
        List endPoints = endFinder.getEnds();
        if (endPoints.isEmpty()) {
            return false;
        }
        for (BlockPos end : endPoints) {
            for (CoordUtils.Surround surr : CoordUtils.Surround.values()) {
                BlockPos pos = end.m_121955_(surr.getOffset());
                BlockState existing = context.level().m_8055_(pos);
                if (!existing.m_247087_() && !(existing.m_60734_() instanceof TrunkShellBlock) || !(context.random().m_188501_() < ((Float)configuration.get(PLACE_CHANCE)).floatValue())) continue;
                context.level().m_7731_(pos, ((Block)configuration.get(BLOCK)).m_49966_(), 3);
            }
        }
        return true;
    }
}

