/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtaether.growthlogic;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class FieldsprootLogic
extends GrowthLogicKit {
    public static final ConfigurationProperty<Integer> SPLIT_ENDS_ENERGY = ConfigurationProperty.integer((String)"split_ends_energy");
    public static final ConfigurationProperty<Integer> FIRST_TWIST_LENGTH = ConfigurationProperty.integer((String)"first_twist_length");
    public static final ConfigurationProperty<Integer> LAST_TWIST_LENGTH = ConfigurationProperty.integer((String)"last_twist_length");

    public FieldsprootLogic(ResourceLocation registryName) {
        super(registryName);
    }

    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(SPLIT_ENDS_ENERGY, (Object)4)).with(FIRST_TWIST_LENGTH, (Object)4)).with(LAST_TWIST_LENGTH, (Object)4)).with(HEIGHT_VARIATION, (Object)3);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{SPLIT_ENDS_ENERGY, FIRST_TWIST_LENGTH, LAST_TWIST_LENGTH, HEIGHT_VARIATION});
    }

    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        int[] probMap = super.populateDirectionProbabilityMap(configuration, context);
        Level level = context.level();
        Direction fromDir = context.signal().dir.m_122424_();
        List<Direction> validDirs = this.getBranchesAround(level, context.pos(), fromDir);
        if (context.signal().energy > (float)((Integer)configuration.get(SPLIT_ENDS_ENERGY)).intValue()) {
            if (validDirs.size() >= 1) {
                int[] newProb = new int[6];
                validDirs.forEach(d -> {
                    newProb[d.ordinal()] = 1;
                });
                probMap = newProb;
            } else {
                boolean goUp;
                int canopyEnergy = (Integer)configuration.get(SPLIT_ENDS_ENERGY) + 2;
                int lowestBranch = configuration.getLowestBranchHeight(new PositionalSpeciesContext(context.level(), context.signal().rootPos, context.species()));
                int firstTwist = lowestBranch + (Integer)configuration.get(FIRST_TWIST_LENGTH);
                int lastTwist = canopyEnergy + (Integer)configuration.get(LAST_TWIST_LENGTH);
                float energy = context.signal().energy;
                int steps = context.signal().numSteps;
                boolean bl = goUp = steps == firstTwist || steps == firstTwist + 1 || energy == (float)lastTwist || energy == (float)(lastTwist + 1);
                if (goUp || context.signal().energy <= (float)canopyEnergy) {
                    return new int[]{0, 1, 0, 0, 0, 0};
                }
                boolean blocked = true;
                for (Direction dir : Direction.Plane.HORIZONTAL) {
                    BlockPos pos;
                    BlockState offState;
                    if (probMap[dir.ordinal()] == 0 || !TreeHelper.isLeaves((BlockState)(offState = level.m_8055_(pos = context.pos().m_121955_(dir.m_122436_())))) && !level.m_46859_(pos) && !offState.m_247087_() || BranchBlock.isNextToBranch((Level)level, (BlockPos)pos, (Direction)dir.m_122424_())) continue;
                    blocked = false;
                    break;
                }
                if (!blocked) {
                    probMap[Direction.UP.ordinal()] = 0;
                }
            }
        }
        probMap[Direction.DOWN.ordinal()] = 0;
        probMap[fromDir.ordinal()] = 0;
        return probMap;
    }

    private List<Direction> getBranchesAround(Level level, BlockPos pos, Direction fromDir) {
        LinkedList<Direction> validDirs = new LinkedList<Direction>();
        for (Direction dir : Direction.values()) {
            if (dir == fromDir || !TreeHelper.isBranch((BlockState)level.m_8055_(pos.m_121955_(dir.m_122436_())))) continue;
            validDirs.add(dir);
        }
        return validDirs;
    }

    public int getLowestBranchHeight(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return (int)((float)super.getLowestBranchHeight(configuration, context) + this.getHashVariation(configuration, context));
    }

    protected float getHashVariation(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        long day = context.level().m_46467_() / 24000L;
        int month = (int)day / 30;
        return CoordUtils.coordHashCode((BlockPos)context.pos().m_6630_(month), (int)2) % (Integer)configuration.get(HEIGHT_VARIATION);
    }
}

