/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient (Waypoints Mod).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.waypoints.waypoints.gui;

import java.util.Locale;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_4576025;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.ColorOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.ClickableWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.TextFieldWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.ColorWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.VanillaButtonWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.util.DrawUtil;
import io.github.axolotlclient.waypoints.AxolotlClientWaypoints;
import io.github.axolotlclient.waypoints.waypoints.Waypoint;
import io.github.axolotlclient.waypoints.waypoints.gui.util.CycleButton;
import io.github.axolotlclient.waypoints.waypoints.gui.util.StringWidget;

public class EditWaypointScreen extends io.github.axolotlclient.AxolotlClientConfig.impl.ui.Screen {

	private final C_3020744 parent;
	private double x = -1, y = -1, z = -1;
	private ClickableWidget save;
	private final Waypoint toEdit;
	private final ColorOption color;
	private String dimension, name, display;

	public EditWaypointScreen(C_3020744 screen, Waypoint toEdit) {
		super(AxolotlClientWaypoints.tr("edit_waypoint_title"));
		this.parent = screen;
		this.toEdit = toEdit;
		color = new ColorOption("", toEdit.color());
	}

	@Override
	public void m_7261014(int mouseX, int mouseY, float delta) {
		super.m_7261014(mouseX, mouseY, delta);
		m_2717572(f_2020658, getTitle(), f_5465691 / 2, 33 / 2, -1);
	}

	@Override
	public void m_3593494() {
		var posTitle = addDrawableChild(new StringWidget(AxolotlClientWaypoints.tr("waypoint_position"), f_2020658)).alignCenter();
		posTitle.setWidth(f_5465691);
		posTitle.setY(33 + 4);

		var dimensionLabel = addDrawableChild(new StringWidget(AxolotlClientWaypoints.tr("waypoint_position.dimension"), f_2020658));
		dimensionLabel.setHeight(20);
		dimensionLabel.setPosition(f_5465691 / 2 - (dimensionLabel.getWidth() + 150 + 4) / 2, 33 + 4 + 9 + 4);
		var dimension = addDrawableChild(new TextFieldWidget(f_2020658, dimensionLabel.getX() + dimensionLabel.getWidth() + 4, dimensionLabel.getY(), 150, 20, AxolotlClientWaypoints.tr("waypoint_position_dimension")));
		dimension.setText(toEdit.dimension());
		if (this.dimension != null) {
			dimension.setText(this.dimension);
		}
		dimension.setChangedListener(s -> this.dimension = s);


		var xLabel = addDrawableChild(new StringWidget(AxolotlClientWaypoints.tr("waypoint_position.x_label"), f_2020658));
		xLabel.setHeight(20);
		var yLabel = addDrawableChild(new StringWidget(AxolotlClientWaypoints.tr("waypoint_position.y_label"), f_2020658));
		yLabel.setHeight(20);
		var zLabel = addDrawableChild(new StringWidget(AxolotlClientWaypoints.tr("waypoint_position.z_label"), f_2020658));
		zLabel.setHeight(20);
		xLabel.setPosition(f_5465691 / 2 - (xLabel.getWidth() + 4 + yLabel.getWidth() + 4 + zLabel.getWidth() + (75 + 4) * 3) / 2, dimensionLabel.getY() + 20 + 4);
		yLabel.setPosition(xLabel.getX() + xLabel.getWidth() + 4 + 75 + 4, xLabel.getY());
		zLabel.setPosition(yLabel.getX() + yLabel.getWidth() + 4 + 75 + 4, yLabel.getY());
		var x = addDrawableChild(new TextFieldWidget(f_2020658, xLabel.getX() + xLabel.getWidth() + 4, xLabel.getY(), 75, 20, AxolotlClientWaypoints.tr("waypoint_position.x")));
		var y = addDrawableChild(new TextFieldWidget(f_2020658, yLabel.getX() + yLabel.getWidth() + 4, xLabel.getY(), 75, 20, AxolotlClientWaypoints.tr("waypoint_position.y")));
		var z = addDrawableChild(new TextFieldWidget(f_2020658, zLabel.getX() + zLabel.getWidth() + 4, xLabel.getY(), 75, 20, AxolotlClientWaypoints.tr("waypoint_position.z")));
		x.setChangedListener(s -> {
			try {
				this.x = Double.parseDouble(s);
			} catch (Exception ignored) {
				this.x = -1;
			}
		});
		y.setChangedListener(s -> {
			try {
				this.y = Double.parseDouble(s);
			} catch (Exception ignored) {
				this.y = -1;
			}
		});
		z.setChangedListener(s -> {
			try {
				this.z = Double.parseDouble(s);
			} catch (Exception ignored) {
				this.z = -1;
			}
		});
		x.setText(String.valueOf(toEdit.x()));
		y.setText(String.valueOf(toEdit.y()));
		z.setText(String.valueOf(toEdit.z()));

		var displayTitle = addDrawableChild(new StringWidget(AxolotlClientWaypoints.tr("waypoint_display"), f_2020658)).alignCenter();
		displayTitle.setWidth(f_5465691);
		displayTitle.setY(y.getY() + y.getHeight() + 10 + 4 + 4);

		var nameLabel = addDrawableChild(new StringWidget(AxolotlClientWaypoints.tr("waypoint_display.name_label"), f_2020658));
		var displayLabel = new StringWidget(AxolotlClientWaypoints.tr("waypoint_display.display_label"), f_2020658);
		nameLabel.setHeight(20);
		nameLabel.setPosition(f_5465691 / 2 - (nameLabel.getWidth() + 4 + displayLabel.getWidth() + 4 + 100 + 4 + 50 + 100 + 4) / 2, displayTitle.getY() + 9 + 4);
		displayLabel.setHeight(20);
		displayLabel.setPosition(nameLabel.getX() + 4 + 100 + 4, nameLabel.getY());
		var name = addDrawableChild(new TextFieldWidget(f_2020658, nameLabel.getX() + nameLabel.getWidth() + 4, nameLabel.getY(), 100, 20, AxolotlClientWaypoints.tr("waypoint_display.name")));
		var display = addDrawableChild(new TextFieldWidget(f_2020658, displayLabel.getX() + displayLabel.getWidth() + 4, displayLabel.getY(), 50, 20, AxolotlClientWaypoints.tr("waypoint_display.display")));
		var lockButton = addDrawableChild(CycleButton.onOffBuilder(true)
			.create(display.getX() + display.getWidth() + 4, displayLabel.getY(), 100, 20, AxolotlClientWaypoints.tr("waypoint_display.unlock_display"),
				(btn, v) -> display.active = !v));
		name.setText(this.name != null ? this.name : toEdit.name());
		name.setChangedListener(s -> {
			this.name = s;
			if (lockButton.getValue()) {
				var d = s.trim();
				display.setText(d.isEmpty() ? "" : d.substring(0, 1).toUpperCase(Locale.ROOT));
			}
		});
		display.setText(toEdit.display());
		display.active = false;
		name.setMaxLength(150);
		display.setMaxLength(10);
		if (this.display != null) {
			display.setText(this.display);
		}
		display.setChangedListener(s -> this.display = s);

		var colorTitle = addDrawableChild(new StringWidget(AxolotlClientWaypoints.tr("waypoint_color"), f_2020658)).alignCenter();
		colorTitle.setWidth(f_5465691);
		colorTitle.setY(displayLabel.getY() + displayLabel.getHeight() + 4 + 10 + 4);

		addDrawableChild(new ClickableWidget(f_5465691 / 2 - 2 - 100, colorTitle.getY() + colorTitle.getHeight() + 4, 100, 20, "") {
			@Override
			public void drawWidget(int mouseX, int mouseY, float partialTick) {
				m_7865719(getX(), getY(), getX() + getWidth(), getY() + getHeight(), color.get().toInt());
				DrawUtil.outlineRect(getX(), getY(), getWidth(), getHeight(), Colors.BLACK.toInt());
			}
		}).active = false;
		addDrawableChild(new ColorWidget(f_5465691 / 2 + 2, colorTitle.getY() + colorTitle.getHeight() + 4, 100, 20, color));

		int footerY = f_3080061 - 33 / 2 - 20 / 2;
		save = addDrawableChild(new VanillaButtonWidget(f_5465691 / 2 - 2 - 150, footerY, 150, 20, C_4576025.m_3547652("gui.done"), btn -> {
			AxolotlClientWaypoints.WAYPOINT_STORAGE.create(new Waypoint(dimension.getText(), this.x, this.y, this.z, color.getOriginal(), name.getText(), display.getText()));
			f_7153641.m_6408915(parent);
		}));
		addDrawableChild(new VanillaButtonWidget(f_5465691 / 2 + 20, footerY, 150, 20, C_4576025.m_3547652("gui.cancel"), btn -> f_7153641.m_6408915(parent)));
	}

	@Override
	public void m_2450377() {
		save.active = x != -1 && y != -1 && z != -1;
	}
}
