/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient (Waypoints Mod).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.waypoints.map.widgets;

import io.github.axolotlclient.AxolotlClientConfig.impl.ui.ButtonWidget;
import io.github.axolotlclient.waypoints.AxolotlClientWaypoints;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_8105098;

public class DropdownButton extends ButtonWidget {
	private static final C_0561170 ARROW_UP = AxolotlClientWaypoints.rl("textures/gui/sprites/dropdown/up.png"),
		ARROW_UP_HIGHLIGHTED = AxolotlClientWaypoints.rl("textures/gui/sprites/dropdown/up_highlighted.png"),
		ARROW_DOWN = AxolotlClientWaypoints.rl("textures/gui/sprites/dropdown/down.png"),
		ARROW_DOWN_HIGHLIGHTED = AxolotlClientWaypoints.rl("textures/gui/sprites/dropdown/down_highlighted.png");

	private boolean state;

	public DropdownButton(int x, int y, int width, int height, String message, PressConsumer onPress) {
		super(x, y, width, height, message, btn -> {
			var dropdown = (DropdownButton) btn;
			dropdown.state = !dropdown.state;
			onPress.pressed(btn, dropdown.state);
		});
	}

	@Override
	protected void drawWidget(int mouseX, int mouseY, float partialTick) {
		if (state) {
			C_8105098.m_0408063().m_1218956().m_5325521(isHovered() ? ARROW_UP_HIGHLIGHTED : ARROW_UP);
			m_5935491(getX(), getY(), 0, 0, getWidth(), getHeight(), getWidth(), getHeight());
		} else {
			C_8105098.m_0408063().m_1218956().m_5325521(isHovered() ? ARROW_DOWN_HIGHLIGHTED : ARROW_DOWN);
			m_5935491(getX(), getY(), 0, 0, getWidth(), getHeight(), getWidth(), getHeight());
		}
	}

	public interface PressConsumer {
		void pressed(ButtonWidget button, boolean state);
	}
}
