/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient (Waypoints Mod).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.waypoints.map.widgets;

import io.github.axolotlclient.AxolotlClientConfig.impl.ui.ButtonWidget;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_8105098;

public class ImageButton extends ButtonWidget {

	private final WidgetSprites sprites;

	public ImageButton(int x, int y, int width, int height, WidgetSprites sprites, PressAction onPress) {
		this(x, y, width, height, sprites, onPress, "");
	}

	public ImageButton(int x, int y, int width, int height, WidgetSprites sprites, PressAction onPress, String message) {
		super(x, y, width, height, message, onPress);
		this.sprites = sprites;
	}

	public ImageButton(int width, int height, WidgetSprites sprites, PressAction onPress, String message) {
		this(0, 0, width, height, sprites, onPress, message);
	}

	@Override
	public void drawWidget(int mouseX, int mouseY, float partialTick) {
		C_0561170 identifier = this.sprites.get(active, isHovered());
		C_8105098.m_0408063().m_1218956().m_5325521(identifier);
		m_5935491(this.getX(), this.getY(), 0, 0, getWidth(), this.getHeight(), getWidth(), getHeight());
	}

	public record WidgetSprites(C_0561170 enabled, C_0561170 disabled, C_0561170 enabledFocused,
								C_0561170 disabledFocused) {
		public WidgetSprites(C_0561170 enabled, C_0561170 disabled) {
			this(enabled, enabled, disabled, disabled);
		}

		public WidgetSprites(C_0561170 enabled, C_0561170 disabled, C_0561170 enabledFocused) {
			this(enabled, disabled, enabledFocused, disabled);
		}

		public C_0561170 get(boolean enabled, boolean focused) {
			if (enabled) {
				return focused ? this.enabledFocused : this.enabled;
			} else {
				return focused ? this.disabledFocused : this.disabled;
			}
		}
	}
}
