/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.waypoints;

import io.github.axolotlclient.AxolotlClientConfig.api.AxolotlClientConfig;
import io.github.axolotlclient.AxolotlClientConfig.api.manager.ConfigManager;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.api.options.OptionCategory;
import io.github.axolotlclient.AxolotlClientConfig.impl.managers.VersionedJsonConfigManager;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.FloatOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.util.ConfigStyles;
import io.github.axolotlclient.waypoints.AxolotlClientWaypointsCommon;
import io.github.axolotlclient.waypoints.BooleanOption;
import io.github.axolotlclient.waypoints.map.Minimap;
import io.github.axolotlclient.waypoints.map.WorldMapScreen;
import io.github.axolotlclient.waypoints.network.Listener;
import io.github.axolotlclient.waypoints.waypoints.Waypoint;
import io.github.axolotlclient.waypoints.waypoints.WaypointRenderer;
import io.github.axolotlclient.waypoints.waypoints.WaypointStorage;
import io.github.axolotlclient.waypoints.waypoints.gui.CreateWaypointScreen;
import io.github.axolotlclient.waypoints.waypoints.gui.WaypointsScreen;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_1023567;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_4576025;
import net.minecraft.unmapped.C_7778778;
import net.minecraft.unmapped.C_8105098;
import net.ornithemc.osl.keybinds.api.KeyBindingEvents;
import net.ornithemc.osl.lifecycle.api.client.MinecraftClientEvents;
import org.joml.Matrix4fStack;
import org.lwjgl.input.Keyboard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AxolotlClientWaypoints
implements ClientModInitializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AxolotlClientWaypoints.class);
    public static final Matrix4fStack MATRIX_STACK = new Matrix4fStack(32);
    public static final Minimap MINIMAP = new Minimap();
    public static final WaypointStorage WAYPOINT_STORAGE = new WaypointStorage();
    public static final WaypointRenderer WAYPOINT_RENDERER = new WaypointRenderer();
    public static final Listener NETWORK_LISTENER = new Listener();
    private final OptionCategory waypoints = OptionCategory.create((String)"waypoints");
    public static BooleanOption renderWaypoints = new BooleanOption("render_waypoints", Boolean.valueOf(true));
    public static BooleanOption renderWaypointsInWorld = new BooleanOption("render_waypoints_in_world", Boolean.valueOf(true));
    public static BooleanOption renderOutOfViewWaypointsOnScreenEdge = new BooleanOption("render_out_of_view_waypoints", Boolean.valueOf(true));
    public static FloatOption waypointTitleScale = new FloatOption("waypoint_title_scale", Float.valueOf(1.0f), Float.valueOf(0.1f), Float.valueOf(2.0f));
    private final String category = "key.category.axolotlclient_waypoints.axolotlclient_waypoints";
    private final C_7778778 map = new C_7778778("axolotlclient_waypoints.world_map", Keyboard.KEY_M, "key.category.axolotlclient_waypoints.axolotlclient_waypoints");
    private final C_7778778 manageWaypoints = new C_7778778("axolotlclient_waypoints.waypoints_menu", Keyboard.KEY_K, "key.category.axolotlclient_waypoints.axolotlclient_waypoints");
    private final C_7778778 newWaypoint = new C_7778778("axolotlclient_waypoints.create_waypoint", Keyboard.KEY_N, "key.category.axolotlclient_waypoints.axolotlclient_waypoints");
    private final C_7778778 toggleWaypointRendering = new C_7778778("axolotlclient_waypoints.toggle_waypoint_rendering", 0, "key.category.axolotlclient_waypoints.axolotlclient_waypoints");

    public void onInitializeClient() {
        AxolotlClientWaypointsCommon.init();
        MINIMAP.init();
        AxolotlClientWaypointsCommon.category.add(new OptionCategory[]{this.waypoints});
        this.waypoints.add(new Option[]{renderWaypoints, renderWaypointsInWorld, renderOutOfViewWaypointsOnScreenEdge, waypointTitleScale});
        try {
            Files.createDirectories(FabricLoader.getInstance().getConfigDir().resolve("axolotlclient_waypoints"), new FileAttribute[0]);
        }
        catch (IOException e) {
            log.warn("Failed to create config dir, options may not save correctly!", (Throwable)e);
        }
        VersionedJsonConfigManager configManager = new VersionedJsonConfigManager(AxolotlClientWaypointsCommon.OPTIONS_PATH, AxolotlClientWaypointsCommon.category, 1, (oldVersion, newVersion, rootCategory, json) -> json);
        AxolotlClientConfig.getInstance().register((ConfigManager)configManager);
        configManager.load();
        configManager.save();
        KeyBindingEvents.REGISTER_KEYBINDS.register(reg -> {
            reg.register(this.map);
            reg.register(this.manageWaypoints);
            reg.register(this.newWaypoint);
            reg.register(this.toggleWaypointRendering);
        });
        MinecraftClientEvents.TICK_END.register(arg_0 -> this.lambda$onInitializeClient$2((ConfigManager)configManager, arg_0));
        NETWORK_LISTENER.init();
    }

    public static C_3020744 createOptionsScreen(C_3020744 parent) {
        return ConfigStyles.createScreen((C_3020744)parent, (OptionCategory)AxolotlClientWaypointsCommon.category);
    }

    public static C_0561170 rl(String path) {
        return new C_0561170("axolotlclient_waypoints", path);
    }

    public static String tr(String key, Object ... args) {
        return C_4576025.m_5618193((String)("axolotlclient_waypoints." + key), (Object[])args);
    }

    public static String tra(String key) {
        return C_4576025.m_3547652((String)("axolotlclient_waypoints." + key));
    }

    public static List<Waypoint> getCurrentWaypoints() {
        return AxolotlClientWaypoints.getCurrentWaypoints(true);
    }

    public static List<Waypoint> getCurrentWaypoints(boolean dimension) {
        C_8105098 mc = C_8105098.m_0408063();
        C_1023567 player = mc.f_7663840;
        return WAYPOINT_STORAGE.getCurrentlyAvailableWaypoints(dimension ? String.valueOf(mc.f_4601986.f_6669533.m_9165548()) : null).sorted(Comparator.comparingDouble(w -> w.squaredDistTo(player.f_6638345, player.f_1187082, player.f_9103758))).toList();
    }

    private static String getB64(String s) {
        return new String(Base64.getUrlEncoder().encode(s.getBytes(StandardCharsets.UTF_8)));
    }

    public static Path getCurrentStorageDir() {
        C_8105098 mc = C_8105098.m_0408063();
        return AxolotlClientWaypoints.getCurrentWorldStorageDir().resolve(AxolotlClientWaypoints.getB64(mc.f_4601986.f_6669533.m_9165548()));
    }

    public static Path getCurrentWorldStorageDir() {
        C_8105098 mc = C_8105098.m_0408063();
        String str = mc.m_4351464() == null ? mc.m_1862495().f_7619058 : mc.m_4351464().m_0808780();
        return AxolotlClientWaypointsCommon.MOD_STORAGE_DIR.resolve(AxolotlClientWaypoints.getB64(str));
    }

    private /* synthetic */ void lambda$onInitializeClient$2(ConfigManager configManager, C_8105098 mc) {
        if (this.map.m_4823804()) {
            mc.m_6408915((C_3020744)new WorldMapScreen());
        } else if (this.manageWaypoints.m_4823804()) {
            mc.m_6408915((C_3020744)new WaypointsScreen(mc.f_0723335));
        } else if (this.newWaypoint.m_4823804()) {
            mc.m_6408915((C_3020744)new CreateWaypointScreen(mc.f_0723335));
        }
        if (this.toggleWaypointRendering.m_4823804()) {
            renderWaypointsInWorld.toggle();
            configManager.save();
        }
    }
}

