/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.waypoints.map;

import io.github.axolotlclient.AxolotlClientConfig.api.util.Color;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Rectangle;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.ClickableWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.Element;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.Screen;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.VanillaButtonWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.util.DrawUtil;
import io.github.axolotlclient.waypoints.AxolotlClientWaypoints;
import io.github.axolotlclient.waypoints.waypoints.Waypoint;
import io.github.axolotlclient.waypoints.waypoints.gui.CreateWaypointScreen;
import io.github.axolotlclient.waypoints.waypoints.gui.EditWaypointScreen;
import io.github.axolotlclient.waypoints.waypoints.gui.util.StringWidget;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_3831727;
import net.minecraft.unmapped.C_8105098;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextMenuScreen
extends Screen {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContextMenuScreen.class);
    private final C_3020744 parent;
    private int posX;
    private int posY;
    private final Type type;
    private Rectangle menu;

    public ContextMenuScreen(C_3020744 parent, int x, int y, Type type) {
        super(AxolotlClientWaypoints.tr("context_menu", new Object[0]));
        this.parent = parent;
        this.posX = x + 4;
        this.posY = y + 4;
        this.type = type;
    }

    public ContextMenuScreen(C_3020744 parent, double x, double y, Type type) {
        this(parent, (int)x, (int)y, type);
    }

    public void m_3593494() {
        this.parent.m_0116202(this.f_7153641, this.f_5465691, this.f_3080061);
        this.posX = Math.min(this.f_5465691 - 100, this.posX);
        int lastY = this.posY;
        List<ClickableWidget> widgets = this.type.build(this.f_7153641, this.parent);
        for (ClickableWidget clickableWidget : widgets) {
            clickableWidget.setPosition(this.posX, clickableWidget.getY() + lastY);
            clickableWidget.setWidth(100);
            clickableWidget.setHeight(12);
            lastY = clickableWidget.getY() + clickableWidget.getHeight();
            this.addDrawableChild((Element)clickableWidget);
        }
        int height = lastY - this.posY;
        this.menu = new Rectangle(this.posX, this.posY, 100, height);
    }

    public void m_7817195() {
    }

    public void m_7261014(int mouseX, int mouseY, float partialTick) {
        if (this.parent != null) {
            C_3754158.m_8373640();
            C_3754158.m_3172490((float)0.0f, (float)0.0f, (float)-100.0f);
            this.parent.m_7261014(this.posX - 4, this.posY - 4, partialTick);
            C_3754158.m_2041265();
        }
        DrawUtil.outlineRect((int)(this.menu.x() - 1), (int)(this.menu.y() - 1), (int)(this.menu.width() + 2), (int)(this.menu.height() + 2), (int)Colors.GRAY.toInt());
        ContextMenuScreen.m_7865719((int)(this.menu.x() - 1), (int)(this.menu.y() - 1), (int)(this.menu.x() + this.menu.width() + 2), (int)(this.menu.y() + this.menu.height() + 2), (int)Colors.DARK_GRAY.withAlpha(100).toInt());
        super.m_7261014(mouseX, mouseY, partialTick);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (mouseX >= (double)this.menu.x() && mouseX < (double)(this.menu.x() + this.menu.width()) && mouseY >= (double)this.menu.y() && mouseY < (double)(this.menu.y() + this.menu.height())) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        this.onClose();
        C_3020744 c_3020744 = this.parent;
        if (c_3020744 instanceof Screen) {
            Screen s = (Screen)c_3020744;
            return s.mouseClicked(mouseX, mouseY, button);
        }
        this.parent.m_7362766((int)mouseX, (int)mouseY, button);
        return true;
    }

    public void onClose() {
        this.f_7153641.m_6408915(this.parent);
    }

    public void m_8984281() {
        this.parent.m_8984281();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Type {
        public List<ClickableWidget> build(C_8105098 var1, C_3020744 var2);

        public record Waypoint(io.github.axolotlclient.waypoints.waypoints.Waypoint waypoint) implements Type
        {
            @Override
            public List<ClickableWidget> build(C_8105098 minecraft, C_3020744 parent) {
                ArrayList<ClickableWidget> entries = new ArrayList<ClickableWidget>();
                entries.add(new TitleWidget(0, 4, 0, 0, this.waypoint.name(), minecraft.f_0426313));
                entries.add((ClickableWidget)new VanillaButtonWidget(0, 8, 0, 0, AxolotlClientWaypoints.tr("edit_waypoint", new Object[0]), btn -> minecraft.m_6408915((C_3020744)new EditWaypointScreen(parent, this.waypoint))));
                return entries;
            }
        }

        public record Map(String dimension, int worldPosX, int worldPosY, int worldPosZ) implements Type
        {
            @Override
            public List<ClickableWidget> build(C_8105098 minecraft, C_3020744 parent) {
                ArrayList<ClickableWidget> entries = new ArrayList<ClickableWidget>();
                entries.add(new TitleWidget(0, 4, 0, 0, AxolotlClientWaypoints.tr("position", String.valueOf(this.worldPosX), String.valueOf(this.worldPosY), String.valueOf(this.worldPosZ)), minecraft.f_0426313));
                entries.add((ClickableWidget)new VanillaButtonWidget(0, 8, 0, 0, AxolotlClientWaypoints.tr("create_waypoint", new Object[0]), btn -> minecraft.m_6408915((C_3020744)new CreateWaypointScreen(parent, (float)this.worldPosX + 0.5f, this.worldPosY, (float)this.worldPosZ + 0.5f))));
                return entries;
            }
        }
    }

    private static class TitleWidget
    extends StringWidget {
        public TitleWidget(int x, int y, int width, int height, String message, C_3831727 font) {
            super(x, y, width, height, message, font, 0.5f);
        }

        @Override
        public void render(int mouseX, int mouseY, float partialTick) {
            DrawUtil.drawScrollingText((String)this.getMessage(), (int)(this.getX() + 1), (int)this.getY(), (int)(this.getWidth() - 1), (int)this.getHeight(), (Color)new Color(this.getColor()));
        }
    }
}

