/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.waypoints.map;

import io.github.axolotlclient.AxolotlClientConfig.api.options.OptionCategory;
import io.github.axolotlclient.AxolotlClientConfig.impl.util.DrawUtil;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.waypoints.AxolotlClientWaypoints;
import io.github.axolotlclient.waypoints.AxolotlClientWaypointsCommon;
import io.github.axolotlclient.waypoints.HudCreator;
import io.github.axolotlclient.waypoints.map.MinimapCommon;
import io.github.axolotlclient.waypoints.util.ARGB;
import io.github.axolotlclient.waypoints.waypoints.Waypoint;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_2441996;
import net.minecraft.unmapped.C_2691939;
import net.minecraft.unmapped.C_3628668;
import net.minecraft.unmapped.C_3674802;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_3779718;
import net.minecraft.unmapped.C_4882708;
import net.minecraft.unmapped.C_4976084;
import net.minecraft.unmapped.C_6849228;
import net.minecraft.unmapped.C_7799337;
import net.minecraft.unmapped.C_7873567;
import net.minecraft.unmapped.C_8030141;
import net.minecraft.unmapped.C_8049104;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_9335057;
import org.joml.Vector3f;

public class Minimap
extends MinimapCommon {
    private static final C_0561170 texLocation = AxolotlClientWaypoints.rl("minimap");
    public static final C_0561170 arrowLocation = AxolotlClientWaypoints.rl("textures/gui/sprites/arrow.png");
    private int[] pixels;
    public long updateDuration = -1L;
    private C_3779718 tex;
    private int mapCenterX;
    private int mapCenterZ;
    private boolean usingHud;
    public boolean allowCaves = true;
    private final C_8105098 minecraft = C_8105098.m_0408063();

    public void init() {
        super.init();
        AxolotlClientWaypointsCommon.category.add(new OptionCategory[]{minimap});
        if (AxolotlClientWaypointsCommon.AXOLOTLCLIENT_PRESENT) {
            this.usingHud = true;
            HudCreator.createHud((MinimapCommon)this);
        }
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public void setup() {
        this.tex = new C_3779718(128, 128);
        this.minecraft.m_1218956().m_0381205(texLocation, (C_4882708)this.tex);
        this.pixels = this.tex.m_1823577();
        this.x = new C_7799337(this.minecraft).m_1713651() - 128 - 10;
        this.y = 10;
    }

    public void renderMapOverlay() {
        if (this.usingHud) {
            return;
        }
        int guiWidth = new C_7799337(this.minecraft).m_1713651();
        this.x = guiWidth - 128 - 10;
        this.y = 10;
        if (this.minecraft.m_7633905()) {
            this.y += 15;
        }
        this.renderMap();
    }

    public void renderMap(AxoRenderContext ctx) {
        this.renderMap();
    }

    public void renderMap() {
        if (!this.isEnabled()) {
            return;
        }
        C_3754158.m_3323122((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        C_3754158.m_8373640();
        Vector3f vec1 = AxolotlClientWaypoints.MATRIX_STACK.transformPosition((float)this.x, (float)this.y, 0.0f, new Vector3f());
        Vector3f vec2 = AxolotlClientWaypoints.MATRIX_STACK.transformPosition((float)(this.x + 128), (float)(this.y + 128), 0.0f, new Vector3f());
        DrawUtil.pushScissor((int)C_4976084.m_7192202((float)vec1.x), (int)C_4976084.m_7192202((float)vec1.y), (int)C_4976084.m_7192202((float)(vec2.x - vec1.x)), (int)C_4976084.m_7192202((float)(vec2.y - vec1.y)));
        C_3754158.m_8373640();
        C_3754158.m_3172490((float)this.x, (float)this.y, (float)0.0f);
        C_3754158.m_3172490((float)64.0f, (float)64.0f, (float)0.0f);
        if (!this.lockMapToNorth.get().booleanValue()) {
            C_3754158.m_8616673((float)(-(this.minecraft.f_7663840.m_4815215() + 180.0f)), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        C_3754158.m_4552250((float)((float)Math.sqrt(2.0)), (float)((float)Math.sqrt(2.0)), (float)1.0f);
        C_3754158.m_4552250((float)((Integer)this.mapScale.get()).intValue(), (float)((Integer)this.mapScale.get()).intValue(), (float)1.0f);
        C_3754158.m_3172490((float)-64.0f, (float)-64.0f, (float)0.0f);
        float offX = -((float)(this.minecraft.f_7663840.f_6638345 - (double)this.mapCenterX));
        float offZ = -((float)(this.minecraft.f_7663840.f_9103758 - (double)this.mapCenterZ));
        C_3754158.m_3172490((float)offX, (float)offZ, (float)0.0f);
        this.minecraft.m_1218956().m_5325521(texLocation);
        C_2691939.m_5935491((int)0, (int)0, (float)0.0f, (float)0.0f, (int)128, (int)128, (float)128.0f, (float)128.0f);
        C_3754158.m_2041265();
        DrawUtil.popScissor();
        if (this.minimapOutline.get().booleanValue() && !this.usingHud) {
            DrawUtil.outlineRect((int)this.x, (int)this.y, (int)128, (int)128, (int)this.outlineColor.get().toInt());
        }
        if (this.showWaypoints.get().booleanValue()) {
            this.renderMapWaypoints();
        }
        if (this.showCardinalDirections.get().booleanValue()) {
            Vector3f pos = new Vector3f();
            String[] directions = new String[]{"N", "W", "E", "S"};
            for (int i : new int[]{-2, 1, 2, -1}) {
                String label = directions[i < 0 ? i + 2 : i + 1];
                int labelWidth = this.minecraft.f_0426313.m_0040387(label);
                int labelHeight = this.minecraft.f_0426313.f_6725889;
                AxolotlClientWaypoints.MATRIX_STACK.pushMatrix();
                AxolotlClientWaypoints.MATRIX_STACK.identity();
                AxolotlClientWaypoints.MATRIX_STACK.translate((float)(this.x + 64), (float)(this.y + 64), 0.0f);
                if (!this.lockMapToNorth.get().booleanValue()) {
                    AxolotlClientWaypoints.MATRIX_STACK.rotate((float)(-((double)((this.minecraft.f_7663840.m_4815215() + 180.0f) / 180.0f) * Math.PI)), 0.0f, 0.0f, 1.0f);
                }
                AxolotlClientWaypoints.MATRIX_STACK.translate((float)(i % 2 * 128), (float)((int)((float)i / 2.0f) * 128), 0.0f);
                pos.zero();
                AxolotlClientWaypoints.MATRIX_STACK.transformPosition(pos);
                AxolotlClientWaypoints.MATRIX_STACK.popMatrix();
                pos.x = C_4976084.m_7164829((float)pos.x, (float)this.x, (float)(this.x + 128));
                pos.y = C_4976084.m_7164829((float)pos.y, (float)this.y, (float)(this.y + 128));
                C_3754158.m_8373640();
                C_3754158.m_3172490((float)pos.x, (float)pos.y, (float)pos.z);
                C_3754158.m_4552250((float)0.5f, (float)0.5f, (float)1.0f);
                C_2691939.m_7865719((int)(-(labelWidth / 2 + 2)), (int)(-(labelHeight / 2 + 2)), (int)(labelWidth / 2 + 2), (int)(labelHeight / 2 + 2), (int)0x77888888);
                this.minecraft.f_0426313.m_4683674(label, -labelWidth / 2, -labelHeight / 2, -1);
                C_3754158.m_2041265();
            }
        }
        C_3754158.m_8373640();
        C_3754158.m_3172490((float)(this.x + 64), (float)(this.y + 64), (float)0.0f);
        if (this.lockMapToNorth.get().booleanValue()) {
            C_3754158.m_8616673((float)(this.minecraft.f_7663840.m_4815215() + 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        C_3754158.m_4552250((float)(0.5f * (float)((Integer)this.arrowScale.get()).intValue()), (float)(0.5f * (float)((Integer)this.arrowScale.get()).intValue()), (float)1.0f);
        int arrowSize = 15;
        C_3754158.m_3172490((float)((float)(-arrowSize) / 2.0f), (float)((float)(-arrowSize) / 2.0f), (float)1.0f);
        this.minecraft.m_1218956().m_5325521(arrowLocation);
        C_2691939.m_5935491((int)0, (int)0, (float)0.0f, (float)0.0f, (int)arrowSize, (int)arrowSize, (float)arrowSize, (float)arrowSize);
        C_3754158.m_2041265();
        C_3754158.m_2041265();
    }

    private void renderMapWaypoints() {
        if (!AxolotlClientWaypoints.renderWaypoints.get().booleanValue()) {
            return;
        }
        C_3754158.m_8373640();
        Vector3f pos = new Vector3f();
        for (Waypoint waypoint : AxolotlClientWaypoints.getCurrentWaypoints()) {
            C_3754158.m_8373640();
            float posX = (float)(waypoint.x() - this.minecraft.f_7663840.f_6638345);
            float posY = (float)(waypoint.z() - this.minecraft.f_7663840.f_9103758);
            pos.zero();
            AxolotlClientWaypoints.MATRIX_STACK.pushMatrix();
            AxolotlClientWaypoints.MATRIX_STACK.identity();
            AxolotlClientWaypoints.MATRIX_STACK.translate((float)this.x, (float)this.y, 0.0f);
            AxolotlClientWaypoints.MATRIX_STACK.translate(64.0f, 64.0f, 0.0f);
            AxolotlClientWaypoints.MATRIX_STACK.scale((float)Math.sqrt(2.0), (float)Math.sqrt(2.0), 1.0f);
            AxolotlClientWaypoints.MATRIX_STACK.scale((float)((Integer)this.mapScale.get()).intValue(), (float)((Integer)this.mapScale.get()).intValue(), 1.0f);
            if (!this.lockMapToNorth.get().booleanValue()) {
                AxolotlClientWaypoints.MATRIX_STACK.rotate((float)(-Math.toRadians(this.minecraft.f_7663840.f_7005130 + 180.0f)), 0.0f, 0.0f, 1.0f);
            }
            AxolotlClientWaypoints.MATRIX_STACK.translate(posX, posY, 1.0f);
            AxolotlClientWaypoints.MATRIX_STACK.transformPosition(pos);
            AxolotlClientWaypoints.MATRIX_STACK.popMatrix();
            pos.x = C_4976084.m_7164829((float)pos.x, (float)this.x, (float)(this.x + 128));
            pos.y = C_4976084.m_7164829((float)pos.y, (float)this.y, (float)(this.y + 128));
            C_3754158.m_3172490((float)pos.x, (float)pos.y, (float)pos.z());
            C_3754158.m_6326777((float)1.0f, (float)1.0f, (float)1.0f);
            int textWidth = this.minecraft.f_0426313.m_0040387(waypoint.display());
            int textHeight = this.minecraft.f_0426313.f_6725889;
            C_2691939.m_7865719((int)(-(textWidth / 2) - Waypoint.displayXOffset()), (int)(-(textHeight / 2) - Waypoint.displayYOffset()), (int)(textWidth / 2 + Waypoint.displayXOffset()), (int)(textHeight / 2 + Waypoint.displayYOffset()), (int)waypoint.color().toInt());
            this.minecraft.f_0426313.m_4413321(waypoint.display(), -((float)textWidth / 2.0f), (float)(-textHeight) / 2.0f, -1, false);
            C_3754158.m_2041265();
        }
        C_3754158.m_2041265();
    }

    private static int blockToSectionCoord(int c) {
        return c >> 4;
    }

    public void updateMapView() {
        if (!this.isEnabled()) {
            this.updateDuration = -1L;
            return;
        }
        long start = System.currentTimeMillis();
        int centerX = (int)(this.minecraft.f_7663840.f_6638345 + 0.5);
        int centerZ = (int)(this.minecraft.f_7663840.f_9103758 + 0.5);
        this.mapCenterX = centerX;
        this.mapCenterZ = centerZ;
        int texHalfWidth = 64;
        C_3674802.C_0067708 mutableBlockPos = new C_3674802.C_0067708();
        C_3674802.C_0067708 mutableBlockPos2 = new C_3674802.C_0067708();
        C_7873567 level = this.minecraft.f_4601986;
        C_6849228 centerChunk = level.m_0750002(Minimap.blockToSectionCoord(centerX), Minimap.blockToSectionCoord(centerZ));
        int surface = centerChunk.m_5956776(centerX & 0xF, centerZ & 0xF);
        mutableBlockPos.m_1540202(centerX, surface, centerZ);
        int solidBlocksAbovePlayer = 0;
        boolean atSurface = false;
        if (level.f_6669533.m_8976359()) {
            atSurface = (int)(this.minecraft.f_7663840.f_1187082 + 0.5) >= level.m_8568350();
        } else if (surface + 1 <= (int)(this.minecraft.f_7663840.f_1187082 + 0.5)) {
            atSurface = true;
        } else {
            while (solidBlocksAbovePlayer <= 3 && surface > (int)(this.minecraft.f_7663840.f_1187082 + 0.5) && surface > 0) {
                C_2441996 state = centerChunk.m_9971171((C_3674802)mutableBlockPos);
                mutableBlockPos.m_1540202(centerX, surface--, centerZ);
                if (state.m_0999604().m_4952508() || !state.m_0999604().m_4839982() || !state.m_0999604().m_8740684()) continue;
                ++solidBlocksAbovePlayer;
            }
            if (solidBlocksAbovePlayer <= 2) {
                atSurface = true;
            }
        }
        boolean updated = false;
        for (int x = 0; x < 128; ++x) {
            double d = 0.0;
            for (int z = -1; z < 128; ++z) {
                int chunkX = centerX + x - texHalfWidth;
                int chunkZ = centerZ + z - texHalfWidth;
                C_6849228 levelChunk = level.m_0750002(Minimap.blockToSectionCoord(chunkX), Minimap.blockToSectionCoord(chunkZ));
                if (levelChunk != null) {
                    int color;
                    C_2441996 blockState;
                    int fluidDepth = 0;
                    double e = 0.0;
                    mutableBlockPos.m_1540202(chunkX, 0, chunkZ);
                    int y = levelChunk.m_5956776(mutableBlockPos.m_9150363() & 0xF, mutableBlockPos.m_3900258() & 0xF) + 1;
                    if (!atSurface) {
                        y = Math.min(y, (int)(this.minecraft.f_7663840.f_1187082 + 0.5));
                    }
                    if (y <= 0) {
                        blockState = C_3628668.f_3097723.m_9077732();
                    } else {
                        do {
                            mutableBlockPos.m_1540202(chunkX, --y, chunkZ);
                        } while ((blockState = levelChunk.m_9971171((C_3674802)mutableBlockPos)).m_0999604().m_3247759(blockState) == C_9335057.f_8898614 && y > 0);
                        if (y > 0 && blockState.m_0999604().m_8228353().m_8583295()) {
                            C_2441996 blockState2;
                            int highestFullBlockY = y - 1;
                            mutableBlockPos2.m_1540202(mutableBlockPos.m_9150363(), mutableBlockPos.m_4798774(), mutableBlockPos.m_3900258());
                            do {
                                mutableBlockPos2.m_1540202(mutableBlockPos.m_9150363(), highestFullBlockY--, mutableBlockPos.m_3900258());
                                blockState2 = levelChunk.m_9971171((C_3674802)mutableBlockPos2);
                                ++fluidDepth;
                            } while (highestFullBlockY > 0 && blockState2.m_0999604().m_8228353().m_8583295());
                        }
                    }
                    e += (double)y;
                    C_9335057 mapColor = blockState.m_0999604().m_3247759(blockState);
                    if (mapColor == C_9335057.f_2086259) {
                        C_2441996 floorBlock = levelChunk.m_9971171((C_3674802)mutableBlockPos2);
                        int floorColor = floorBlock.m_0999604().m_3247759((C_2441996)floorBlock).f_4989652;
                        int biomeColor = this.enableBiomeBlending.get() != false ? C_8049104.m_8522175((C_8030141)level, (C_3674802)mutableBlockPos) : mapColor.f_4989652;
                        float shade = 1.0f;
                        int waterColor = biomeColor;
                        waterColor = ARGB.colorFromFloat((float)1.0f, (float)(ARGB.redFloat((int)waterColor) * shade), (float)(ARGB.greenFloat((int)waterColor) * shade), (float)(ARGB.blueFloat((int)waterColor) * shade));
                        color = waterColor = ARGB.average((int)waterColor, (int)ARGB.scaleRGB((int)floorColor, (float)(1.0f - (float)fluidDepth / 15.0f)));
                    } else {
                        double f = (e - d) * 4.0 / 5.0 + ((double)(x + z & 1) - 0.5) * 0.4;
                        int brightness = f > 0.6 ? 2 : (f < -0.6 ? 0 : 1);
                        color = mapColor.m_4724233(brightness);
                    }
                    d = e;
                    if (z < 0 || this.pixels[x + z * 128] == color) continue;
                    this.pixels[x + z * 128] = ARGB.opaque((int)color);
                    updated = true;
                    continue;
                }
                if (z < 0 || this.pixels[x + z * 128] == 0) continue;
                this.pixels[x + z * 128] = ARGB.opaque((int)0);
                updated = true;
            }
        }
        if (updated) {
            this.tex.m_4420833();
        }
        this.updateDuration = System.currentTimeMillis() - start;
    }
}

