/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.waypoints.map;

import com.google.common.collect.Lists;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.Element;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.Screen;
import io.github.axolotlclient.AxolotlClientConfig.impl.util.DrawUtil;
import io.github.axolotlclient.waypoints.AxolotlClientWaypoints;
import io.github.axolotlclient.waypoints.map.ContextMenuScreen;
import io.github.axolotlclient.waypoints.map.Minimap;
import io.github.axolotlclient.waypoints.map.util.LevelChunkStorage;
import io.github.axolotlclient.waypoints.map.widgets.AbstractSliderButton;
import io.github.axolotlclient.waypoints.map.widgets.DropdownButton;
import io.github.axolotlclient.waypoints.map.widgets.ImageButton;
import io.github.axolotlclient.waypoints.mixin.LevelAccessor;
import io.github.axolotlclient.waypoints.util.ARGB;
import io.github.axolotlclient.waypoints.waypoints.Waypoint;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_1023567;
import net.minecraft.unmapped.C_2441996;
import net.minecraft.unmapped.C_2691939;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3628668;
import net.minecraft.unmapped.C_3674802;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_3779718;
import net.minecraft.unmapped.C_3831727;
import net.minecraft.unmapped.C_4882708;
import net.minecraft.unmapped.C_4976084;
import net.minecraft.unmapped.C_5553933;
import net.minecraft.unmapped.C_6849228;
import net.minecraft.unmapped.C_7873567;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_9335057;
import org.joml.Matrix4fStack;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldMapScreen
extends Screen {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorldMapScreen.class);
    public static final int MIN_BUILD_HEIGHT = 0;
    private static final int TILE_SIZE = 16;
    private static final C_0561170 OPTIONS_SPRITE = AxolotlClientWaypoints.rl("textures/gui/sprites/options.png");
    private static final C_0561170 OPTIONS_HOVERED_SPRITE = AxolotlClientWaypoints.rl("textures/gui/sprites/options_hovered.png");
    private final Map<Vector2i, LazyTile> tiles = new ConcurrentHashMap<Vector2i, LazyTile>();
    private final Vector3f dragOffset = new Vector3f();
    private float scale = 1.0f;
    public static boolean allowCaves = true;
    public static boolean allowCavesNether;
    private boolean atSurface;
    private int caveY;
    private String dimension;
    private Waypoint hoveredWaypoint = null;
    private boolean initializedOnce = false;
    private Runnable optionUpdate;
    private final C_3831727 font;

    public WorldMapScreen() {
        super(AxolotlClientWaypoints.tr("worldmap", new Object[0]));
        this.font = C_8105098.m_0408063().f_0426313;
    }

    public void m_7817195() {
    }

    public void m_7261014(int mouseX, int mouseY, float partialTick) {
        super.m_4184721(0);
        C_3754158.m_8373640();
        C_3754158.m_3172490((float)((float)this.f_5465691 / 2.0f), (float)((float)this.f_3080061 / 2.0f), (float)0.0f);
        C_3754158.m_3172490((float)this.dragOffset.x(), (float)this.dragOffset.y(), (float)this.dragOffset.z());
        C_3754158.m_8373640();
        C_3754158.m_4552250((float)this.scale, (float)this.scale, (float)1.0f);
        C_1023567 player = this.f_7153641.f_7663840;
        for (LazyTile tile : this.tiles.values()) {
            tile.render(AxolotlClientWaypoints.MATRIX_STACK, (float)player.f_6638345, (float)player.f_9103758, this.scale, partialTick, this.caveY, this.atSurface, this.f_5465691, this.f_3080061);
        }
        int x = this.getWorldX(mouseX);
        int z = this.getWorldZ(mouseY);
        C_3754158.m_8373640();
        C_3754158.m_3172490((float)((float)(-player.f_6638345)), (float)((float)(-player.f_9103758)), (float)0.0f);
        int tileX = x / 16;
        int tileY = z / 16;
        if (x < 0 && x % 16 != 0) {
            --tileX;
        }
        if (z < 0 && z % 16 != 0) {
            --tileY;
        }
        C_3754158.m_3172490((float)(tileX * 16), (float)(tileY * 16), (float)0.0f);
        WorldMapScreen.m_7865719((int)0, (int)0, (int)16, (int)16, (int)0x33FFFFFF);
        DrawUtil.outlineRect((int)0, (int)0, (int)16, (int)16, (int)0x33FFFFFF);
        C_3754158.m_2041265();
        C_3754158.m_2041265();
        this.renderMapWaypoints(mouseX, mouseY);
        C_3754158.m_8616673((float)(this.f_7153641.f_7663840.m_4815215() + 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        C_3754158.m_4552250((float)(0.5f * (float)((Integer)AxolotlClientWaypoints.MINIMAP.arrowScale.get()).intValue()), (float)(0.5f * (float)((Integer)AxolotlClientWaypoints.MINIMAP.arrowScale.get()).intValue()), (float)1.0f);
        int arrowSize = 15;
        C_3754158.m_3172490((float)((float)(-arrowSize) / 2.0f), (float)((float)(-arrowSize) / 2.0f), (float)5.0f);
        this.f_7153641.m_1218956().m_5325521(Minimap.arrowLocation);
        WorldMapScreen.m_5935491((int)0, (int)0, (float)0.0f, (float)0.0f, (int)arrowSize, (int)arrowSize, (float)arrowSize, (float)arrowSize);
        C_3754158.m_2041265();
        super.m_7261014(mouseX, mouseY, partialTick);
        this.m_2717572(this.font, AxolotlClientWaypoints.tr("position", String.valueOf(x), String.valueOf(this.getY(x, z)), String.valueOf(z)), this.f_5465691 / 2, this.f_3080061 - 15, Colors.GRAY.toInt());
    }

    private static int blockToSectionCoord(int c) {
        return c >> 4;
    }

    private int getY(int x, int z) {
        C_2441996 blockState;
        LazyTile tile;
        C_6849228 c;
        int tileX = x / 16;
        int tileY = z / 16;
        if (x < 0 && x % 16 != 0) {
            --tileX;
        }
        if (z < 0 && z % 16 != 0) {
            --tileY;
        }
        if ((c = (tile = this.tiles.get(new Vector2i(tileX, tileY))) == null || tile.tile == null ? (((LevelAccessor)this.f_7153641.f_4601986).invokeChunkLoadedAt(WorldMapScreen.blockToSectionCoord(x), WorldMapScreen.blockToSectionCoord(z), true) ? this.f_7153641.f_4601986.m_0750002(WorldMapScreen.blockToSectionCoord(x), WorldMapScreen.blockToSectionCoord(z)) : null) : tile.tile.chunk.chunk()) == null) {
            return 0;
        }
        int y = c.m_5956776(x & 0xF, z & 0xF);
        if (this.atSurface) {
            return y;
        }
        y = Math.min(y, this.caveY);
        C_3674802.C_0067708 mutableBlockPos = new C_3674802.C_0067708(x, 0, z);
        do {
            mutableBlockPos.m_1540202(mutableBlockPos.m_9150363(), --y, mutableBlockPos.m_3900258());
        } while ((blockState = c.m_9971171((C_3674802)mutableBlockPos)).m_0999604().m_3247759(blockState) == C_9335057.f_8898614 && y > 0);
        return y;
    }

    private int getWorldX(double guiX) {
        return C_4976084.m_8723286((double)(this.f_7153641.f_7663840.f_6638345 - ((double)((float)this.f_5465691 / 2.0f + this.dragOffset.x()) - guiX) / (double)this.scale));
    }

    private int getWorldZ(double guiZ) {
        return C_4976084.m_8723286((double)(this.f_7153641.f_7663840.f_9103758 - ((double)((float)this.f_3080061 / 2.0f + this.dragOffset.y()) - guiZ) / (double)this.scale));
    }

    private void renderMapWaypoints(int mouseX, int mouseY) {
        if (!AxolotlClientWaypoints.renderWaypoints.get().booleanValue()) {
            return;
        }
        C_3754158.m_8373640();
        Vector3f pos = new Vector3f();
        this.hoveredWaypoint = null;
        for (Waypoint waypoint : AxolotlClientWaypoints.getCurrentWaypoints()) {
            C_3754158.m_8373640();
            float posX = (float)(waypoint.x() - this.f_7153641.f_7663840.f_6638345) + 1.0f;
            float posY = (float)(waypoint.z() - this.f_7153641.f_7663840.f_9103758) + 1.0f;
            C_3754158.m_3172490((float)(posX * this.scale), (float)(posY * this.scale), (float)0.0f);
            pos.zero();
            AxolotlClientWaypoints.MATRIX_STACK.transformPosition(pos);
            int textWidth = this.font.m_0040387(waypoint.display());
            int width = textWidth + Waypoint.displayXOffset() * 2;
            int textHeight = this.font.f_6725889;
            int height = textHeight + Waypoint.displayYOffset() * 2;
            pos.sub((float)width / 2.0f, (float)height / 2.0f, 0.0f);
            WorldMapScreen.m_7865719((int)(-(width / 2)), (int)(-(height / 2)), (int)(width / 2), (int)(height / 2), (int)waypoint.color().toInt());
            this.font.m_4413321(waypoint.display(), -((float)textWidth / 2.0f), (float)(-textHeight) / 2.0f, -1, false);
            if (this.hoveredWaypoint == null && (float)mouseX >= pos.x() && (float)mouseY >= pos.y() && (float)mouseX < pos.x() + (float)width && (float)mouseY < pos.y() + (float)height) {
                this.hoveredWaypoint = waypoint;
                C_3754158.m_3172490((float)0.0f, (float)0.0f, (float)2.0f);
                DrawUtil.outlineRect((int)(-width / 2), (int)(-height / 2), (int)width, (int)height, (int)Colors.WHITE.toInt());
            }
            C_3754158.m_2041265();
        }
        C_3754158.m_2041265();
    }

    private void collectPlayerYData() {
        C_7873567 level = this.f_7153641.f_4601986;
        if (allowCaves || allowCavesNether && level.f_6669533.m_8976359()) {
            int playerX = (int)(this.f_7153641.f_7663840.f_6638345 + 0.5);
            int playerZ = (int)(this.f_7153641.f_7663840.f_9103758 + 0.5);
            C_6849228 centerChunk = level.m_0750002(WorldMapScreen.blockToSectionCoord(playerX), WorldMapScreen.blockToSectionCoord(playerZ));
            int surface = centerChunk.m_5956776(playerX & 0xF, playerZ & 0xF);
            C_3674802.C_0067708 mutableBlockPos = new C_3674802.C_0067708(playerX, surface, playerZ);
            int solidBlocksAbovePlayer = 0;
            this.atSurface = false;
            if (level.f_6669533.m_8976359()) {
                this.atSurface = (int)(this.f_7153641.f_7663840.f_1187082 + 0.5) >= level.m_8568350();
            } else if (surface + 1 <= (int)(this.f_7153641.f_7663840.f_1187082 + 0.5)) {
                this.atSurface = true;
            } else {
                while (solidBlocksAbovePlayer <= 3 && surface > (int)(this.f_7153641.f_7663840.f_1187082 + 0.5) && surface > 0) {
                    C_2441996 state = centerChunk.m_9971171((C_3674802)mutableBlockPos);
                    mutableBlockPos.m_1540202(playerX, surface--, playerZ);
                    if (state.m_0999604().m_4952508() || !state.m_0999604().m_4839982() || !state.m_0999604().m_8740684()) continue;
                    ++solidBlocksAbovePlayer;
                }
                if (solidBlocksAbovePlayer <= 2) {
                    this.atSurface = true;
                }
            }
        } else {
            this.atSurface = true;
        }
        this.caveY = (int)(this.f_7153641.f_7663840.f_1187082 + 0.5);
        this.dimension = level.f_6669533.m_9165548();
    }

    private void createTiles() {
        int playerX = (int)(this.f_7153641.f_7663840.f_6638345 + 0.5);
        int playerZ = (int)(this.f_7153641.f_7663840.f_9103758 + 0.5);
        LazyTile playerTile = this.createTile(playerX, playerZ, this.atSurface, this.caveY);
        if (playerTile != null) {
            HashMap<Vector2i, LazyTile> loadedTiles = new HashMap<Vector2i, LazyTile>(this.tiles);
            this.tiles.clear();
            this.tiles.put(new Vector2i(playerTile.tilePosX(), playerTile.tilePosY()), playerTile);
            this.triggerNeighbourLoad(playerTile, this.atSurface, this.caveY, playerTile);
            loadedTiles.forEach((v, t) -> {
                if (!this.tiles.containsKey(v)) {
                    this.tiles.put((Vector2i)v, (LazyTile)t);
                }
            });
        }
    }

    private void triggerNeighbourLoad(LazyTile tile, boolean atSurface, int caveY, LazyTile origin) {
        ArrayList<Runnable> queue = new ArrayList<Runnable>();
        this.loadNeighbour(tile, -1, -1, atSurface, caveY, queue, origin);
        this.loadNeighbour(tile, -1, 0, atSurface, caveY, queue, origin);
        this.loadNeighbour(tile, -1, 1, atSurface, caveY, queue, origin);
        this.loadNeighbour(tile, 0, 1, atSurface, caveY, queue, origin);
        this.loadNeighbour(tile, 1, 1, atSurface, caveY, queue, origin);
        this.loadNeighbour(tile, 1, 0, atSurface, caveY, queue, origin);
        this.loadNeighbour(tile, 1, -1, atSurface, caveY, queue, origin);
        this.loadNeighbour(tile, 0, -1, atSurface, caveY, queue, origin);
        if (!queue.isEmpty()) {
            for (Runnable runnable : Lists.reverse(queue)) {
                runnable.run();
            }
        }
    }

    private void loadNeighbour(LazyTile origin, int tileOffsetX, int tileOffsetY, boolean atSurface, int caveY, List<Runnable> loadQueue, LazyTile mapOrigin) {
        int anchorYLeft;
        int anchorXLeft;
        LazyTile tile;
        int tileYLeft;
        int tileXLeft;
        Vector2i vec;
        if (!(tileOffsetY == 0 && tileOffsetX == 0 || this.tiles.containsKey(vec = new Vector2i(tileXLeft = origin.tilePosX() + tileOffsetX, tileYLeft = origin.tilePosY() + tileOffsetY)) || (tile = this.createTile(anchorXLeft = tileXLeft * 16, anchorYLeft = tileYLeft * 16, atSurface, caveY)) == null)) {
            this.tiles.put(vec, tile);
            loadQueue.add(() -> this.triggerNeighbourLoad(tile, atSurface, caveY, mapOrigin));
        }
    }

    private static C_0561170 getTileRl(int tileX, int tileY) {
        return AxolotlClientWaypoints.rl("world_map/tile_" + tileX + "_" + tileY);
    }

    private LazyTile createTile(int anchorX, int anchorZ, boolean atSurface, int caveY) {
        return WorldMapScreen.createTile(this.f_7153641, anchorX, anchorZ, atSurface, caveY);
    }

    private static LazyTile createTile(C_8105098 minecraft, int anchorX, int anchorZ, boolean atSurface, int caveY) {
        C_6849228 tileChunk;
        anchorZ -= anchorZ % 16;
        anchorX -= anchorX % 16;
        C_7873567 level = minecraft.f_4601986;
        int tileX = anchorX / 16;
        int tileY = anchorZ / 16;
        if (anchorX < 0 && anchorX % 16 != 0) {
            --tileX;
        }
        if (anchorZ < 0 && anchorZ % 16 != 0) {
            --tileY;
        }
        C_6849228 c_6849228 = tileChunk = ((LevelAccessor)level).invokeChunkLoadedAt(tileX, tileY, false) ? level.m_0750002(tileX, tileY) : null;
        if (tileChunk != null) {
            int finalTileX = tileX;
            int finalTileY = tileY;
            return new LazyTile(tileX, tileY, () -> Tile.create(finalTileX, finalTileY, tileChunk));
        }
        return null;
    }

    public static void saveLoadedChunkTile(int chunkX, int chunkZ) {
        C_8105098 minecraft = C_8105098.m_0408063();
        C_7873567 level = minecraft.f_4601986;
        int anchorX = chunkX << 4;
        int tileX = anchorX / 16;
        int anchorZ = chunkZ << 4;
        int tileY = anchorZ / 16;
        C_6849228 tileChunk = level.m_0750002(tileX, tileY);
        if (tileChunk != null) {
            Path dir = WorldMapScreen.getCurrentLevelMapSaveDir();
            Path out = dir.resolve("%d_%d%s".formatted(tileX, tileY, ".bin"));
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
                new LevelChunkStorage.Entry(tileChunk).write(out);
            }
            catch (IOException e) {
                log.warn("Failed to save tile at {}, {}", new Object[]{tileX, tileY, e});
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!super.mouseClicked(mouseX, mouseY, button)) {
            if (button == 1) {
                if (this.hoveredWaypoint != null) {
                    this.f_7153641.m_6408915((C_3020744)new ContextMenuScreen((C_3020744)this, mouseX, mouseY, (ContextMenuScreen.Type)new ContextMenuScreen.Type.Waypoint(this.hoveredWaypoint)));
                } else {
                    int worldX = this.getWorldX(mouseX);
                    int worldZ = this.getWorldZ(mouseY);
                    this.f_7153641.m_6408915((C_3020744)new ContextMenuScreen((C_3020744)this, mouseX, mouseY, (ContextMenuScreen.Type)new ContextMenuScreen.Type.Map(this.dimension, worldX, this.getY(worldX, worldZ), worldZ)));
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!super.mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            if (button == 0) {
                this.dragOffset.add((float)dragX, (float)dragY, 0.0f);
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!super.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            if (scrollY > 0.0) {
                this.scale *= 2.0f;
                float offsetX = (float)this.f_5465691 / 2.0f + this.dragOffset.x();
                float offsetY = (float)this.f_3080061 / 2.0f + this.dragOffset.y();
                double mirroredOnOffsetX = (double)offsetX - (mouseX - (double)offsetX);
                double mirroredOnOffsetY = (double)offsetY - (mouseY - (double)offsetY);
                this.dragOffset.set(mirroredOnOffsetX - (double)((float)this.f_5465691 / 2.0f), mirroredOnOffsetY - (double)((float)this.f_3080061 / 2.0f), 0.0);
            } else {
                this.scale /= 2.0f;
                float offsetX = (float)this.f_5465691 / 2.0f + this.dragOffset.x();
                float offsetY = (float)this.f_3080061 / 2.0f + this.dragOffset.y();
                double mirroredOnOffsetX = (double)offsetX + (mouseX - (double)offsetX) / 2.0;
                double mirroredOnOffsetY = (double)offsetY + (mouseY - (double)offsetY) / 2.0;
                this.dragOffset.set(mirroredOnOffsetX - (double)((float)this.f_5465691 / 2.0f), mirroredOnOffsetY - (double)((float)this.f_3080061 / 2.0f), 0.0);
            }
        }
        return true;
    }

    public void m_3593494() {
        this.addDrawableChild((Element)new ImageButton(4, this.f_3080061 - 20, 16, 16, new ImageButton.WidgetSprites(OPTIONS_SPRITE, OPTIONS_SPRITE, OPTIONS_HOVERED_SPRITE), btn -> this.f_7153641.m_6408915(AxolotlClientWaypoints.createOptionsScreen((C_3020744)this)), AxolotlClientWaypoints.tr("options", new Object[0])));
        var slider = this.addDrawableChild((Element)new AbstractSliderButton(this.f_5465691 - 150, 20, 150, 20, AxolotlClientWaypoints.tr("player_y", new Object[0]), 0.0){
            final int min = -1;
            final int max;
            {
                this.min = -1;
                this.max = ((WorldMapScreen)WorldMapScreen.this).f_7153641.f_4601986.m_8568350() + 1;
            }

            @Override
            protected void updateMessage() {
                if (this.value == 0.0) {
                    this.setMessage(AxolotlClientWaypoints.tr("player_y", new Object[0]));
                } else {
                    this.setMessage(String.valueOf(WorldMapScreen.this.caveY - 1));
                }
            }

            @Override
            protected void applyValue() {
                WorldMapScreen.this.caveY = (int)(-1.0 + (double)(this.max - -1) * this.value);
                WorldMapScreen.this.atSurface = false;
                if (this.value == 0.0) {
                    WorldMapScreen.this.collectPlayerYData();
                }
                WorldMapScreen.this.updateTiles();
            }
        });
        this.addDrawableChild((Element)new DropdownButton(this.f_5465691 - 20, 0, 20, 20, AxolotlClientWaypoints.tr("open_dropdown", new Object[0]), (btn, val) -> {
            slider.visible = val;
        }));
        slider.visible = false;
        this.optionUpdate = () -> {
            boolean updated;
            boolean allowsCaves = allowCaves || allowCavesNether && this.f_7153641.f_4601986.f_6669533.m_8976359();
            boolean bl = updated = slider.active != allowsCaves;
            if (updated) {
                slider.active = allowsCaves;
                if (!allowsCaves) {
                    this.atSurface = true;
                    this.updateTiles();
                } else {
                    slider.applyValue();
                }
            }
        };
        AxolotlClientWaypoints.NETWORK_LISTENER.postReceive.add(this.optionUpdate);
        this.optionUpdate.run();
        if (this.tiles.isEmpty()) {
            if (!this.initializedOnce) {
                this.collectPlayerYData();
            }
            CompletableFuture.runAsync(() -> {
                this.loadSavedTiles();
                this.createTiles();
            });
        }
        this.initializedOnce = true;
    }

    private void updateTiles() {
        CompletableFuture.runAsync(() -> this.tiles.values().forEach(t -> t.update(this.caveY, this.atSurface, (C_5553933)this.f_7153641.f_4601986)));
    }

    private void loadSavedTiles() {
        Path dir = WorldMapScreen.getCurrentLevelMapSaveDir();
        if (Files.exists(dir, new LinkOption[0])) {
            try (Stream<Path> s = Files.list(dir);){
                s.forEach(file -> {
                    int y;
                    String name = file.getFileName().toString();
                    if (!name.endsWith(".bin")) {
                        return;
                    }
                    String[] coords = (name = name.substring(0, name.indexOf("."))).split("_");
                    int x = Integer.parseInt(coords[0]);
                    Vector2i key = new Vector2i(x, y = Integer.parseInt(coords[1]));
                    if (!this.tiles.containsKey(key)) {
                        try {
                            LazyTile tile = new LazyTile(x, y, () -> {
                                try {
                                    return Tile.read(file, (C_5553933)this.f_7153641.f_4601986);
                                }
                                catch (IOException e) {
                                    return null;
                                }
                            });
                            this.tiles.put(key, tile);
                        }
                        catch (Exception e) {
                            log.warn("Failed to load tile at {}, {}", new Object[]{x, y, e});
                        }
                    }
                });
            }
            catch (IOException e) {
                log.info("Failed to load saved world map tiles!", (Throwable)e);
            }
        }
    }

    private void saveTiles() {
        Path dir = WorldMapScreen.getCurrentLevelMapSaveDir();
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            this.tiles.values().forEach(tile -> WorldMapScreen.saveTile(tile, dir));
        }
        catch (IOException e) {
            log.error("Failed to create world map save dir!", (Throwable)e);
        }
    }

    private static void saveTile(LazyTile tile, Path dir) {
        try {
            tile.save(dir);
        }
        catch (IOException e) {
            log.warn("Failed to save tile at {}, {}", new Object[]{tile.tilePosX(), tile.tilePosY(), e});
        }
    }

    private static Path getCurrentLevelMapSaveDir() {
        return AxolotlClientWaypoints.getCurrentStorageDir().resolve("worldmap");
    }

    public void m_8984281() {
        if (this.optionUpdate != null) {
            AxolotlClientWaypoints.NETWORK_LISTENER.postReceive.remove(this.optionUpdate);
        }
        if (this.f_7153641.f_0723335 == null) {
            this.saveTiles();
            this.tiles.values().forEach(LazyTile::release);
            this.tiles.clear();
        }
    }

    private static class LazyTile {
        private Tile tile;
        private final int tilePosX;
        private final int tilePosY;
        private final Supplier<Tile> supplier;
        private final Vector3f pos = new Vector3f();
        private boolean loaded;

        public void render(Matrix4fStack matrixStack, float playerX, float playerZ, float scale, float delta, int caveY, boolean atSurface, int guiWidth, int guiHeight) {
            float x = (float)(this.tilePosX() * 16) - playerX;
            float y = (float)(this.tilePosY() * 16) - playerZ;
            C_3754158.m_8373640();
            C_3754158.m_3172490((float)x, (float)y, (float)0.0f);
            this.pos.zero();
            matrixStack.transformPosition(this.pos);
            if (this.pos.x + 16.0f * scale >= 0.0f && this.pos.x < (float)guiWidth && this.pos.y + 16.0f * scale >= 0.0f && this.pos.y < (float)guiHeight) {
                if (this.tile == null) {
                    if (!this.loaded) {
                        this.load().thenRunAsync(() -> {
                            if (this.tile != null) {
                                this.tile.update(caveY, atSurface, (C_5553933)C_8105098.m_0408063().f_4601986);
                            }
                        });
                    }
                } else {
                    C_8105098.m_0408063().m_1218956().m_5325521(this.tile.rl());
                    C_2691939.m_5935491((int)0, (int)0, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
                }
            }
            C_3754158.m_2041265();
        }

        public CompletableFuture<?> load() {
            if (!this.loaded) {
                this.loaded = true;
                return CompletableFuture.supplyAsync(this.supplier, arg_0 -> ((C_8105098)C_8105098.m_0408063()).m_2167033(arg_0)).thenApply(t -> {
                    this.tile = t;
                    return this.tile;
                });
            }
            return CompletableFuture.completedFuture(null);
        }

        public void release() {
            if (this.tile != null) {
                this.tile.release();
            }
        }

        public void save(Path dir) throws IOException {
            if (this.tile != null) {
                this.tile.save(dir);
            }
        }

        public void update(int caveY, boolean atSurface, C_5553933 level) {
            if (this.tile != null) {
                this.tile.update(caveY, atSurface, level);
            }
        }

        @Generated
        public LazyTile(int tilePosX, int tilePosY, Supplier<Tile> supplier) {
            this.tilePosX = tilePosX;
            this.tilePosY = tilePosY;
            this.supplier = supplier;
        }

        @Generated
        public int tilePosX() {
            return this.tilePosX;
        }

        @Generated
        public int tilePosY() {
            return this.tilePosY;
        }
    }

    private record Tile(int tilePosX, int tilePosY, C_0561170 rl, C_3779718 tex, LevelChunkStorage.Entry chunk) {
        public static final String FILE_EXTENSION = ".bin";

        public void release() {
            C_8105098.m_0408063().m_1218956().m_3775266(this.rl);
        }

        public void save(Path dir) throws IOException {
            Path out = dir.resolve("%d_%d%s".formatted(this.tilePosX, this.tilePosY, FILE_EXTENSION));
            this.chunk.write(out);
        }

        public static Tile create(int x, int y, C_6849228 chunk) {
            return Tile.create(x, y, new LevelChunkStorage.Entry(chunk));
        }

        public static Tile create(int x, int y, LevelChunkStorage.Entry chunk) {
            C_0561170 rl = WorldMapScreen.getTileRl(x, y);
            C_3779718 tex = new C_3779718(16, 16);
            Arrays.fill(tex.m_1823577(), Colors.BLACK.toInt());
            C_8105098.m_0408063().m_1218956().m_0381205(rl, (C_4882708)tex);
            return new Tile(x, y, rl, tex, chunk);
        }

        public static Tile read(Path p, C_5553933 level) throws IOException {
            String name = p.getFileName().toString();
            name = name.substring(0, name.indexOf("."));
            String[] coords = name.split("_");
            int x = Integer.parseInt(coords[0]);
            int y = Integer.parseInt(coords[1]);
            return Tile.create(x, y, LevelChunkStorage.Entry.read(p, level));
        }

        public void update(int caveY, boolean atSurface, C_5553933 level) {
            if (this.chunk.chunk().m_5909771()) {
                Arrays.fill(this.tex.m_1823577(), Colors.BLACK.toInt());
                C_8105098.m_0408063().m_2167033(() -> ((C_3779718)this.tex).m_4420833());
                return;
            }
            int levelMinY = 0;
            int centerX = this.tilePosX * 16 + 8;
            int centerZ = this.tilePosY * 16 + 8;
            int[] pixels = this.tex.m_1823577();
            int size = 16;
            int texHalfWidth = size / 2;
            C_3674802.C_0067708 mutableBlockPos = new C_3674802.C_0067708();
            C_3674802.C_0067708 mutableBlockPos2 = new C_3674802.C_0067708();
            boolean updated = false;
            for (int x = 0; x < size; ++x) {
                double d = 0.0;
                for (int z = -1; z < size; ++z) {
                    int color;
                    C_2441996 blockState;
                    int chunkX = centerX + x - texHalfWidth;
                    int chunkZ = centerZ + z - texHalfWidth;
                    int fluidDepth = 0;
                    double e = 0.0;
                    mutableBlockPos.m_1540202(chunkX, 0, chunkZ);
                    if (z < 0) {
                        mutableBlockPos.m_1540202(chunkX, 0, chunkZ + 1);
                    }
                    C_6849228 levelChunk = this.chunk.chunk();
                    int y = levelChunk.m_5956776(mutableBlockPos.m_9150363() & 0xF, mutableBlockPos.m_3900258() & 0xF) + 1;
                    if (!atSurface) {
                        y = Math.min(y, caveY);
                    }
                    if (y <= levelMinY) {
                        blockState = C_3628668.f_3097723.m_9077732();
                    } else {
                        do {
                            mutableBlockPos.m_1540202(mutableBlockPos.m_9150363(), --y, mutableBlockPos.m_3900258());
                        } while ((blockState = levelChunk.m_9971171((C_3674802)mutableBlockPos)).m_0999604().m_3247759(blockState) == C_9335057.f_8898614 && y > levelMinY);
                        if (y > levelMinY && blockState.m_0999604().m_8228353().m_8583295()) {
                            C_2441996 blockState2;
                            int highestFullBlockY = y - 1;
                            mutableBlockPos2.m_1540202(mutableBlockPos.m_9150363(), mutableBlockPos.m_4798774(), mutableBlockPos.m_3900258());
                            do {
                                mutableBlockPos2.m_1540202(mutableBlockPos2.m_9150363(), highestFullBlockY--, mutableBlockPos2.m_3900258());
                                blockState2 = levelChunk.m_9971171((C_3674802)mutableBlockPos2);
                                ++fluidDepth;
                            } while (highestFullBlockY > levelMinY && blockState2.m_0999604().m_8228353().m_8583295());
                        }
                    }
                    e += (double)y;
                    C_9335057 mapColor = blockState.m_0999604().m_3247759(blockState);
                    if (mapColor == C_9335057.f_2086259) {
                        C_2441996 floorBlock = levelChunk.m_9971171((C_3674802)mutableBlockPos2);
                        int floorColor = floorBlock.m_0999604().m_3247759((C_2441996)floorBlock).f_4989652;
                        int biomeColor = mapColor.f_4989652;
                        float shade = 1.0f;
                        int waterColor = biomeColor;
                        waterColor = ARGB.colorFromFloat((float)1.0f, (float)(ARGB.redFloat((int)waterColor) * shade), (float)(ARGB.greenFloat((int)waterColor) * shade), (float)(ARGB.blueFloat((int)waterColor) * shade));
                        color = waterColor = ARGB.average((int)waterColor, (int)ARGB.scaleRGB((int)floorColor, (float)(1.0f - (float)fluidDepth / 15.0f)));
                    } else {
                        double f = (e - d) * 4.0 / 5.0 + ((double)(x + z & 1) - 0.5) * 0.4;
                        int brightness = f > 0.6 ? 2 : (f < -0.6 ? 0 : 1);
                        color = mapColor.m_4724233(brightness);
                    }
                    d = e;
                    if (z < 0 || pixels[x + z * 16] == color) continue;
                    pixels[x + z * 16] = ARGB.opaque((int)color);
                    updated = true;
                }
            }
            if (updated) {
                C_8105098.m_0408063().m_2167033(() -> ((C_3779718)this.tex).m_4420833());
            }
        }
    }
}

