/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.waypoints.map.util;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.DecoderException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.minecraft.unmapped.C_2986085;
import net.minecraft.unmapped.C_5553933;
import net.minecraft.unmapped.C_6849228;
import net.minecraft.unmapped.C_7141926;
import net.minecraft.unmapped.C_7240405;
import net.minecraft.unmapped.C_8042654;

public class LevelChunkStorage {
    public static void writeEntries(List<Entry> entries, FriendlyByteBuf buf) {
        buf.writeCollection(entries, (b, e) -> e.write((FriendlyByteBuf)((Object)b)));
    }

    public static List<Entry> readEntries(C_5553933 level, FriendlyByteBuf buf) {
        return buf.readList(e -> Entry.read(level, e));
    }

    public static FriendlyByteBuf buffer() {
        return new FriendlyByteBuf(Unpooled.buffer());
    }

    public static void write(C_6849228 chunk, FriendlyByteBuf buf) {
        buf.writeLong(C_7141926.m_1427709((int)chunk.f_5716244, (int)chunk.f_9091555));
        buf.writeVarIntArray(chunk.m_6941410());
        buf.writeInt(chunk.m_3040753().length);
        for (C_8042654 section : chunk.m_3040753()) {
            if (section == null) {
                buf.writeCharArray(new char[0]);
                continue;
            }
            buf.writeCharArray(section.m_1626953());
            buf.m_9874803(section.m_5326624().m_6967751());
            buf.m_9874803(section.m_2781383().m_6967751());
        }
    }

    public static C_6849228 read(C_5553933 level, FriendlyByteBuf buf) {
        long packedChunkPos = buf.readLong();
        int chunkX = (int)packedChunkPos;
        int chunkZ = (int)(packedChunkPos >> 32);
        int[] heightmaps = buf.readVarIntArray();
        C_6849228 chunk = new C_6849228(level, chunkX, chunkZ);
        int sectionCount = buf.readInt();
        if (sectionCount != chunk.m_3040753().length) {
            return chunk;
        }
        C_8042654[] sections = chunk.m_3040753();
        for (int i = 0; i < sectionCount; ++i) {
            C_8042654 section = sections[i];
            char[] blockstates = buf.readCharArray();
            if (blockstates.length == 0) continue;
            if (section == null) {
                sections[i] = section = new C_8042654(i << 4, !level.f_6669533.m_8976359());
            }
            section.m_5016849(blockstates);
            section.m_3870443(new C_2986085(buf.m_4015180()));
            section.m_9573116(new C_2986085(buf.m_4015180()));
        }
        chunk.m_3098180(heightmaps);
        chunk.m_5537231();
        return chunk;
    }

    public static class FriendlyByteBuf
    extends C_7240405 {
        public FriendlyByteBuf(ByteBuf byteBuf) {
            super(byteBuf);
        }

        public <T> void writeCollection(Collection<T> collection, BiConsumer<? super FriendlyByteBuf, T> elementWriter) {
            this.m_7226734(collection.size());
            for (T object : collection) {
                elementWriter.accept((FriendlyByteBuf)((FriendlyByteBuf)this), (FriendlyByteBuf)((Object)object));
            }
        }

        public <T> List<T> readList(Function<? super FriendlyByteBuf, T> elementReader) {
            return this.readCollection(Lists::newArrayListWithCapacity, elementReader);
        }

        public <T, C extends Collection<T>> C readCollection(IntFunction<C> collectionFactory, Function<? super FriendlyByteBuf, T> elementReader) {
            int i = this.m_6908808();
            Collection collection = (Collection)collectionFactory.apply(i);
            for (int j = 0; j < i; ++j) {
                collection.add(elementReader.apply(this));
            }
            return (C)collection;
        }

        public FriendlyByteBuf writeVarIntArray(int[] array) {
            this.m_7226734(array.length);
            for (int i : array) {
                this.m_7226734(i);
            }
            return this;
        }

        public int[] readVarIntArray() {
            return this.readVarIntArray(this.readableBytes());
        }

        public int[] readVarIntArray(int maxLength) {
            int i = this.m_6908808();
            if (i > maxLength) {
                throw new DecoderException("VarIntArray with size " + i + " is bigger than allowed " + maxLength);
            }
            int[] is = new int[i];
            for (int j = 0; j < is.length; ++j) {
                is[j] = this.m_6908808();
            }
            return is;
        }

        public FriendlyByteBuf writeCharArray(char[] array) {
            super.m_7226734(array.length);
            for (char i : array) {
                this.writeChar(i);
            }
            return this;
        }

        public char[] readCharArray() {
            return this.readCharArray(this.readableBytes());
        }

        public char[] readCharArray(int maxLength) {
            int i = this.m_6908808();
            if (i > maxLength) {
                throw new DecoderException("CharArray with size " + i + " is bigger than allowed " + maxLength);
            }
            char[] is = new char[i];
            for (int j = 0; j < is.length; ++j) {
                is[j] = this.readChar();
            }
            return is;
        }
    }

    public record Entry(C_6849228 chunk) {
        public void write(FriendlyByteBuf buf) {
            LevelChunkStorage.write(this.chunk, buf);
        }

        public static Entry read(C_5553933 level, FriendlyByteBuf buf) {
            return new Entry(LevelChunkStorage.read(level, buf));
        }

        public void write(Path path) throws IOException {
            FriendlyByteBuf buf = LevelChunkStorage.buffer();
            this.write(buf);
            Files.copy((InputStream)new ByteBufInputStream((ByteBuf)buf), path, StandardCopyOption.REPLACE_EXISTING);
        }

        public static Entry read(Path path, C_5553933 level) throws IOException {
            return Entry.read(level, new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])Files.readAllBytes(path))));
        }
    }
}

