/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.waypoints.map.widgets;

import io.github.axolotlclient.AxolotlClientConfig.api.util.Color;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.ClickableWidget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_4976084;
import net.minecraft.unmapped.C_5819357;
import net.minecraft.unmapped.C_8105098;
import org.lwjgl.input.Keyboard;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractSliderButton
extends ClickableWidget {
    private static final C_0561170 SLIDER_LOCATION = new C_0561170("textures/gui/slider.png");
    protected static final int TEXTURE_WIDTH = 200;
    protected static final int TEXTURE_HEIGHT = 20;
    protected static final int TEXTURE_BORDER_X = 20;
    protected static final int TEXTURE_BORDER_Y = 4;
    protected static final int TEXT_MARGIN = 2;
    private static final int HEIGHT = 20;
    private static final int HANDLE_HALF_WIDTH = 4;
    private static final int HANDLE_WIDTH = 8;
    private static final int BACKGROUND = 0;
    private static final int BACKGROUND_FOCUSED = 1;
    private static final int HANDLE = 2;
    private static final int HANDLE_FOCUSED = 3;
    protected double value;
    private boolean canChangeValue;

    public AbstractSliderButton(int x, int y, int width, int height, String message, double value) {
        super(x, y, width, height, message);
        this.value = value;
    }

    public void drawWidget(int mouseX, int mouseY, float partialTick) {
        C_8105098 minecraft = C_8105098.m_0408063();
        minecraft.m_1218956().m_5325521(WIDGETS_LOCATION);
        this.m_4354119(this.getX(), this.getY(), 0, 46, this.getWidth() / 2, this.getHeight());
        this.m_4354119(this.getX() + this.getWidth() / 2, this.getY(), 200 - this.getWidth() / 2, 46, this.getWidth() / 2, this.getHeight());
        int i = (this.isHovered() ? 2 : 1) * 20;
        this.m_4354119(this.getX() + (int)(this.value * (double)(this.getWidth() - 8)), this.getY(), 0, 46 + i, 4, 20);
        this.m_4354119(this.getX() + (int)(this.value * (double)(this.getWidth() - 8)) + 4, this.getY(), 196, 46 + i, 4, 20);
        AbstractSliderButton.drawScrollingText((String)this.getMessage(), (int)this.getX(), (int)this.getY(), (int)this.getWidth(), (int)this.getHeight(), (Color)Colors.WHITE);
    }

    public void onClick(double mouseX, double mouseY) {
        this.setValueFromMouse(mouseX);
    }

    public void setFocused(boolean focused) {
        super.setFocused(focused);
        this.canChangeValue = focused;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == Keyboard.KEY_SPACE || keyCode == Keyboard.KEY_RETURN) {
            this.canChangeValue = !this.canChangeValue;
            return true;
        }
        if (this.canChangeValue) {
            boolean bl;
            boolean bl2 = bl = keyCode == 263;
            if (bl || keyCode == 262) {
                float f = bl ? -1.0f : 1.0f;
                this.setValue(this.value + (double)(f / (float)(this.getWidth() - 8)));
                return true;
            }
        }
        return false;
    }

    private void setValueFromMouse(double mouseX) {
        this.setValue((mouseX - (double)(this.getX() + 4)) / (double)(this.getWidth() - 8));
    }

    private void setValue(double value) {
        double d = this.value;
        this.value = C_4976084.m_0987703((double)value, (double)0.0, (double)1.0);
        if (d != this.value) {
            this.applyValue();
        }
        this.updateMessage();
    }

    protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        this.setValueFromMouse(mouseX);
        super.onDrag(mouseX, mouseY, dragX, dragY);
    }

    public void playDownSound(C_5819357 soundManager) {
    }

    public void onRelease(double mouseX, double mouseY) {
        super.playDownSound(C_8105098.m_0408063().m_7555106());
    }

    protected abstract void updateMessage();

    protected abstract void applyValue();
}

