/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.waypoints.network;

import io.github.axolotlclient.waypoints.AxolotlClientWaypoints;
import io.github.axolotlclient.waypoints.map.WorldMapScreen;
import io.github.axolotlclient.waypoints.network.Payload;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.fabricmc.loader.api.FabricLoader;
import net.ornithemc.osl.networking.api.client.ClientConnectionEvents;
import net.ornithemc.osl.networking.api.client.ClientPlayNetworking;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Listener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Listener.class);
    public List<Runnable> postReceive = new ArrayList<Runnable>();
    private boolean receivedPayload;

    public void init() {
        ClientConnectionEvents.LOGIN.register(client -> ClientPlayNetworking.registerListenerAsync((String)"AXOWP|options", Payload::new, (mc, context, payload) -> this.receiveConfig((Payload)payload)));
        ClientConnectionEvents.DISCONNECT.register(client -> {
            this.reset();
            this.receivedPayload = false;
        });
    }

    public void onReceiveChatMessage(String msg) {
        if (this.receivedPayload) {
            return;
        }
        switch (msg) {
            case "\u00a7f\u00a7a\u00a7i\u00a7r\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o": {
                this.disableCaves();
                break;
            }
            case "\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o\u00a7w\u00a7m\u00a7n\u00a7e\u00a7t\u00a7h\u00a7e\u00a7r\u00a7i\u00a7s\u00a7f\u00a7a\u00a7i\u00a7r": {
                WorldMapScreen.allowCavesNether = true;
                break;
            }
            case "\u00a7n\u00a7o\u00a7m\u00a7i\u00a7n\u00a7i\u00a7m\u00a7a\u00a7p": {
                this.disableMinimap();
                break;
            }
            case "\u00a7r\u00a7e\u00a7s\u00a7e\u00a7t\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o": {
                this.reset();
            }
        }
    }

    private boolean receiveConfig(Payload payload) {
        this.receivedPayload = true;
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            log.info("Received server configuration: {}", (Object)payload);
        }
        this.reset();
        if (payload.disableMinimap()) {
            this.disableMinimap();
        }
        if (payload.disableMinimapCaves()) {
            AxolotlClientWaypoints.MINIMAP.allowCaves = false;
        }
        if (payload.disableWorldmapCaves()) {
            WorldMapScreen.allowCaves = false;
            if (payload.allowWorldmapCavesNether()) {
                WorldMapScreen.allowCavesNether = true;
            }
        }
        this.postReceive.forEach(Runnable::run);
        return true;
    }

    private void disableMinimap() {
        AxolotlClientWaypoints.MINIMAP.enabled.force(true, false);
    }

    private void disableCaves() {
        AxolotlClientWaypoints.MINIMAP.allowCaves = false;
        WorldMapScreen.allowCaves = true;
    }

    private void reset() {
        AxolotlClientWaypoints.MINIMAP.enabled.force(false, false);
        AxolotlClientWaypoints.MINIMAP.allowCaves = true;
        WorldMapScreen.allowCaves = true;
        WorldMapScreen.allowCavesNether = false;
    }
}

