/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.waypoints.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.axolotlclient.waypoints.AxolotlClientWaypointsCommon;
import io.github.axolotlclient.waypoints.network.Payload;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import lombok.Generated;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.minecraft.unmapped.C_3292284;
import net.minecraft.unmapped.C_4576025;
import net.ornithemc.osl.networking.api.CustomPayload;
import net.ornithemc.osl.networking.api.server.ServerConnectionEvents;
import net.ornithemc.osl.networking.api.server.ServerPlayNetworking;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AxolotlClientWaypointsServer
implements DedicatedServerModInitializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AxolotlClientWaypointsServer.class);
    private static final Path OPTIONS_PATH = AxolotlClientWaypointsCommon.OPTIONS_PATH.resolveSibling("server_options.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private Payload options;
    private static final int PERMISSION_LEVEL = 3;

    public void onInitializeServer() {
        this.load();
        if (this.options == null) {
            log.warn("Not sending options because we failed to read or instantiate them");
        }
        ServerConnectionEvents.LOGIN.register((handler, server) -> {
            if (this.options != null) {
                ServerPlayNetworking.send((C_3292284)server, (String)"AXOWP|options", (CustomPayload)this.options);
            }
        });
    }

    private void load() {
        try {
            this.readOrGenerateConfig();
        }
        catch (IOException e) {
            log.warn("Failed to read config! Will not register or send packet to clients!", (Throwable)e);
        }
    }

    private void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(OPTIONS_PATH, new OpenOption[0]);){
            GSON.toJson((Object)this.options, (Appendable)writer);
        }
        catch (IOException e) {
            log.warn("Failed to save config!", (Throwable)e);
        }
    }

    private void readOrGenerateConfig() throws IOException {
        Path path = OPTIONS_PATH;
        if (Files.exists(path, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(path);){
                this.options = (Payload)GSON.fromJson((Reader)reader, Payload.class);
            }
        } else {
            this.options = new Payload();
            this.save();
        }
    }

    public static String tr(String key, Object ... args) {
        return C_4576025.m_5618193((String)("axolotlclient_waypoints." + key), (Object[])args);
    }
}

