/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.waypoints.waypoints;

import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.AxolotlClientConfig.impl.util.DrawUtil;
import io.github.axolotlclient.modules.freelook.Perspective;
import io.github.axolotlclient.waypoints.AxolotlClientWaypoints;
import io.github.axolotlclient.waypoints.mixin.GameRendererAccessor;
import io.github.axolotlclient.waypoints.waypoints.Waypoint;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.unmapped.C_0539808;
import net.minecraft.unmapped.C_0557736;
import net.minecraft.unmapped.C_1400833;
import net.minecraft.unmapped.C_2691939;
import net.minecraft.unmapped.C_3362006;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_4461663;
import net.minecraft.unmapped.C_5786166;
import net.minecraft.unmapped.C_7799337;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_8373595;
import net.minecraft.unmapped.C_8525326;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector4f;

public class WaypointRenderer {
    private static final double CUTOFF_DIST = 5.0;
    private final C_8105098 minecraft = C_8105098.m_0408063();
    private final Matrix4f view = new Matrix4f();
    private final Vector4f viewProj = new Vector4f();
    private final Set<Waypoint> worldRendererWaypoints = new HashSet<Waypoint>();

    public void render(float f) {
        if (!AxolotlClientWaypoints.renderWaypoints.get().booleanValue()) {
            return;
        }
        if (!AxolotlClientWaypoints.renderWaypointsInWorld.get().booleanValue()) {
            return;
        }
        if (this.minecraft.f_4601986 == null) {
            return;
        }
        C_8525326 profiler = C_8105098.m_0408063().f_3960058;
        profiler.m_3614560("waypoints");
        C_0539808 cam = this.minecraft.m_5661944();
        C_3754158.m_6326777((float)1.0f, (float)1.0f, (float)1.0f);
        C_3754158.m_8373640();
        C_0557736 camPos = C_1400833.m_7549074((C_0539808)cam, (double)f);
        C_0557736 cpos = cam.m_4800803(f).m_8163229(0.0, (double)cam.m_6131251(), 0.0);
        C_3754158.m_7643110((boolean)false);
        C_3754158.m_7027522();
        float fov = ((GameRendererAccessor)this.minecraft.f_4267957).invokeGetFov(f, true);
        C_7799337 win = new C_7799337(this.minecraft);
        this.worldRendererWaypoints.clear();
        for (Waypoint waypoint : AxolotlClientWaypoints.getCurrentWaypoints()) {
            profiler.m_8238460(waypoint.name());
            this.renderWaypoint(waypoint, camPos, cpos, fov, win.m_1713651(), win.m_5421693());
            profiler.m_8388219();
        }
        C_3754158.m_7643110((boolean)true);
        C_3754158.m_9078814();
        C_3754158.m_2041265();
    }

    private void renderWaypoint(Waypoint waypoint, C_0557736 camPos, C_0557736 camEyePos, float fov, int guiWidth, int guiHeight) {
        int textHeight;
        int height;
        int textWidth = this.minecraft.f_0426313.m_0040387(waypoint.display());
        int width = textWidth + Waypoint.displayXOffset() * 2;
        Result displayStart = this.projectToScreen(guiWidth, guiHeight, camPos, fov, width, height = (textHeight = this.minecraft.f_0426313.f_6725889) + Waypoint.displayYOffset() * 2, waypoint.x(), waypoint.y(), waypoint.z(), new Vector2f(-((float)width / 2.0f * 0.04f), (float)height / 2.0f * 0.04f));
        if (displayStart == null) {
            return;
        }
        Result displayEnd = this.projectToScreen(guiWidth, guiHeight, camPos, fov, width, height, waypoint.x(), waypoint.y(), waypoint.z(), new Vector2f((float)width / 2.0f * 0.04f, -((float)height / 2.0f * 0.04f)));
        if (displayEnd == null) {
            return;
        }
        float projWidth = Math.abs(displayEnd.x() - displayStart.x());
        float projHeight = Math.abs(displayEnd.y() - displayStart.y());
        if (projWidth < (float)width && projHeight < (float)height) {
            return;
        }
        this.worldRendererWaypoints.add(waypoint);
        C_3754158.m_8373640();
        C_3754158.m_5322104((double)(waypoint.x() - camEyePos.f_8797516), (double)(waypoint.y() - camEyePos.f_7064947), (double)(waypoint.z() - camEyePos.f_1767139));
        C_3362006 dispatcher = this.minecraft.m_5440205();
        C_3754158.m_8616673((float)(-dispatcher.f_5107786), (float)0.0f, (float)1.0f, (float)0.0f);
        if (C_8105098.m_0408063().f_9967940.f_3094045 == Perspective.THIRD_PERSON_FRONT.ordinal()) {
            C_3754158.m_8616673((float)(-dispatcher.f_2592027), (float)1.0f, (float)0.0f, (float)0.0f);
        } else {
            C_3754158.m_8616673((float)dispatcher.f_2592027, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        float scale = 0.04f;
        C_3754158.m_4552250((float)(-scale), (float)(-scale), (float)scale);
        C_3754158.m_9671730();
        this.fillRect((float)(-width) / 2.0f, (float)(-height) / 2.0f, -0.1f, (float)width / 2.0f, (float)height / 2.0f, waypoint.color().toInt());
        this.drawFontBatch(waypoint.display(), (float)(-textWidth) / 2.0f, (float)(-textHeight) / 2.0f);
        C_3754158.m_2041265();
    }

    private void fillRect(float x, float y, float z, float x2, float y2, int color) {
        C_5786166 tessellator = C_5786166.m_2065116();
        C_8373595 bufferBuilder = tessellator.m_1454391();
        C_3754158.m_9671730();
        C_3754158.m_2090124();
        C_3754158.m_0833259((int)770, (int)771, (int)1, (int)0);
        C_3754158.m_3323122((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >> 24 & 0xFF) / 255.0f));
        bufferBuilder.m_0421390(7, C_4461663.f_6859334);
        bufferBuilder.m_3299851((double)x, (double)y2, (double)z).m_4365807();
        bufferBuilder.m_3299851((double)x2, (double)y2, (double)z).m_4365807();
        bufferBuilder.m_3299851((double)x2, (double)y, (double)z).m_4365807();
        bufferBuilder.m_3299851((double)x, (double)y, (double)z).m_4365807();
        tessellator.m_8222644();
        C_3754158.m_7547086();
        C_3754158.m_6326777((float)1.0f, (float)1.0f, (float)1.0f);
        C_3754158.m_5313301();
    }

    private void drawFontBatch(String text, float x, float y) {
        this.minecraft.f_0426313.m_4413321(text, x, y, -1, false);
    }

    public void renderWaypoints(float tick) {
        if (!AxolotlClientWaypoints.renderWaypoints.get().booleanValue()) {
            return;
        }
        if (!AxolotlClientWaypoints.renderWaypointsInWorld.get().booleanValue()) {
            return;
        }
        C_8525326 profiler = C_8105098.m_0408063().f_3960058;
        C_0539808 cam = this.minecraft.m_5661944();
        profiler.m_8238460("waypoints");
        C_7799337 win = new C_7799337(this.minecraft);
        C_3754158.m_8373640();
        List<Waypoint> waypoints = AxolotlClientWaypoints.getCurrentWaypoints();
        ArrayList<Runnable> positionDrawers = new ArrayList<Runnable>(waypoints.size());
        for (Waypoint waypoint : waypoints) {
            C_3754158.m_8373640();
            this.renderWaypoint(waypoint, tick, cam, positionDrawers, win.m_1713651(), win.m_5421693());
            C_3754158.m_2041265();
        }
        if (!positionDrawers.isEmpty()) {
            positionDrawers.forEach(Runnable::run);
        }
        C_3754158.m_2041265();
        profiler.m_8388219();
    }

    private Matrix4f getProjectionMatrix(float fov) {
        Matrix4f matrix4f = new Matrix4f();
        return matrix4f.perspective(fov * ((float)Math.PI / 180), (float)this.minecraft.f_0545414 / (float)this.minecraft.f_5990000, 0.05f, (float)(this.minecraft.f_9967940.f_7110074 * 2));
    }

    private void renderWaypoint(Waypoint waypoint, float tick, C_0539808 camera, List<Runnable> positionDrawn, int guiWidth, int guiHeight) {
        boolean displayY;
        boolean _3dOnScreen;
        boolean outOfView;
        float projHeight;
        float projWidth;
        float fov = ((GameRendererAccessor)this.minecraft.f_4267957).invokeGetFov(tick, true);
        int textWidth = this.minecraft.f_0426313.m_0040387(waypoint.display());
        int width = textWidth + Waypoint.displayXOffset() * 2;
        int textHeight = this.minecraft.f_0426313.f_6725889;
        int height = textHeight + Waypoint.displayYOffset() * 2;
        C_0557736 camPos = C_1400833.m_7549074((C_0539808)camera, (double)tick);
        Result displayStart = this.projectToScreen(guiWidth, guiHeight, camPos, fov, width, height, waypoint.x(), waypoint.y(), waypoint.z(), new Vector2f(-((float)width / 2.0f * 0.04f), (float)height / 2.0f * 0.04f));
        Result displayEnd = this.projectToScreen(guiWidth, guiHeight, camPos, fov, width, height, waypoint.x(), waypoint.y(), waypoint.z(), new Vector2f((float)width / 2.0f * 0.04f, -((float)height / 2.0f * 0.04f)));
        Result result = this.projectToScreen(guiWidth, guiHeight, camPos, fov, width, height, waypoint.x(), waypoint.y(), waypoint.z(), null);
        if (result == null) {
            return;
        }
        if (displayStart != null && displayEnd != null) {
            projWidth = Math.abs(displayEnd.x() - displayStart.x());
            projHeight = Math.abs(displayEnd.y() - displayStart.y());
        } else {
            projWidth = 0.0f;
            projHeight = 0.0f;
        }
        C_3754158.m_3172490((float)result.x(), (float)result.y(), (float)0.0f);
        boolean bl = outOfView = result.x() < (float)(-width) / 2.0f || result.x() > (float)guiWidth + (float)width / 2.0f || result.y() < (float)(-height) / 2.0f || result.y() > (float)guiHeight + (float)height / 2.0f;
        if (!AxolotlClientWaypoints.renderOutOfViewWaypointsOnScreenEdge.get().booleanValue() && outOfView) {
            return;
        }
        if (displayEnd != null && displayStart != null) {
            float minX = displayStart.x();
            float minY = displayStart.y();
            float maxX = displayEnd.x();
            float maxY = displayEnd.y();
            _3dOnScreen = minX > 0.0f && minY > 0.0f && minX < (float)guiWidth && minY < (float)guiHeight || minX > 0.0f && maxY > 0.0f && minX < (float)guiWidth && maxY < (float)guiHeight || maxX > 0.0f && maxY > 0.0f && maxX < (float)guiWidth && maxY < (float)guiHeight || maxX > 0.0f && minY > 0.0f && maxX < (float)guiWidth && minY < (float)guiHeight || minX < (float)guiWidth && maxX > 0.0f && minY < (float)guiHeight && maxY > 0.0f;
        } else {
            _3dOnScreen = false;
        }
        boolean displayX = Math.abs(result.x() - (float)guiWidth / 2.0f) < (_3dOnScreen ? Math.max(projWidth, (float)width) : (float)width) / 2.0f + (float)guiWidth / 4.0f;
        boolean bl2 = displayY = Math.abs(result.y() - (float)guiHeight / 2.0f) < (_3dOnScreen ? Math.max((float)height, projHeight) : (float)height) / 2.0f + (float)guiHeight / 4.0f;
        if (displayX && displayY) {
            positionDrawn.add(() -> {
                String line1 = waypoint.name();
                C_3754158.m_8373640();
                C_3754158.m_3172490((float)result.x(), (float)result.y(), (float)0.0f);
                C_3754158.m_3172490((float)0.0f, (float)(Math.max((float)height, projHeight + 4.0f) / 2.0f + 4.0f), (float)0.0f);
                if ((projWidth >= (float)width || projHeight >= (float)height) && _3dOnScreen) {
                    float y = result.y() + Math.max((float)height, projHeight + 4.0f) / 2.0f + 4.0f;
                    float y2 = Math.min(y, displayEnd.y() + 6.0f);
                    C_3754158.m_3172490((float)0.0f, (float)(y2 - y), (float)0.0f);
                }
                Float scale = (Float)AxolotlClientWaypoints.waypointTitleScale.get();
                C_3754158.m_4552250((float)scale.floatValue(), (float)scale.floatValue(), (float)1.0f);
                int line1W = this.minecraft.f_0426313.m_0040387(line1);
                C_2691939.m_7865719((int)(-line1W / 2 - 2), (int)-2, (int)(line1W / 2 + 2), (int)(this.minecraft.f_0426313.f_6725889 + 2), (int)Colors.GRAY.withAlpha(100).toInt());
                DrawUtil.outlineRect((int)(-line1W / 2 - 2), (int)-2, (int)(line1W + 4), (int)(this.minecraft.f_0426313.f_6725889 + 4), (int)Colors.GRAY.toInt());
                this.minecraft.f_0426313.m_4413321(line1, (float)(-line1W) / 2.0f, 0.0f, -1, true);
                if (!waypoint.closerToThan(camPos.f_8797516, camPos.f_7064947, camPos.f_1767139, 5.0)) {
                    C_3754158.m_3172490((float)0.0f, (float)(this.minecraft.f_0426313.f_6725889 + 4), (float)0.0f);
                    String line2 = AxolotlClientWaypoints.tr("distance", "%.2f".formatted(waypoint.distTo(camPos.f_8797516, camPos.f_7064947, camPos.f_1767139)));
                    this.minecraft.f_0426313.m_4413321(line2, (float)(-this.minecraft.f_0426313.m_0040387(line2)) / 2.0f, 0.0f, -1, false);
                }
                C_3754158.m_2041265();
            });
        }
        if ((projWidth >= (float)width || projHeight >= (float)height) && _3dOnScreen && this.worldRendererWaypoints.contains(waypoint)) {
            return;
        }
        C_2691939.m_7865719((int)(-width / 2), (int)(-height / 2), (int)(width / 2), (int)(height / 2), (int)waypoint.color().toInt());
        this.minecraft.f_0426313.m_4413321(waypoint.display(), (float)(-textWidth) / 2.0f, (float)(-textHeight) / 2.0f, -1, false);
    }

    @Nullable
    private Result projectToScreen(int guiWidth, int guiHeight, C_0557736 camPos, float fov, int width, int height, double x, double y, double z, Vector2f orthoOffset) {
        float pitch;
        this.viewProj.set(x, y, z, 1.0);
        C_3362006 dispatcher = this.minecraft.m_5440205();
        float f = pitch = C_8105098.m_0408063().f_9967940.f_3094045 == Perspective.THIRD_PERSON_FRONT.ordinal() ? -dispatcher.f_2592027 : dispatcher.f_2592027;
        if (orthoOffset != null) {
            Matrix4f vec = new Matrix4f();
            Quaternionf camRot = new Quaternionf().rotationYXZ(-dispatcher.f_5107786 * ((float)Math.PI / 180), pitch * ((float)Math.PI / 180), 0.0f).rotateY((float)(-Math.PI)).invert();
            vec.rotate((Quaternionfc)camRot.invert(new Quaternionf()));
            vec.translate(orthoOffset.x(), orthoOffset.y(), 0.0f);
            vec.rotate((Quaternionfc)camRot);
            vec.transform(this.viewProj);
        }
        this.view.rotation((Quaternionfc)new Quaternionf().rotationYXZ(-dispatcher.f_5107786 * ((float)Math.PI / 180), pitch * ((float)Math.PI / 180), 0.0f).rotateY((float)(-Math.PI)).invert()).translate((float)(-camPos.f_8797516), (float)(-camPos.f_7064947), (float)(-camPos.f_1767139));
        Matrix4f projection = this.getProjectionMatrix(fov);
        projection.mul((Matrix4fc)this.view);
        this.viewProj.mul((Matrix4fc)projection);
        if (orthoOffset == null && AxolotlClientWaypoints.renderOutOfViewWaypointsOnScreenEdge.get().booleanValue()) {
            this.viewProj.w = Math.max(Math.abs(this.viewProj.x()), Math.max(Math.abs(this.viewProj.y()), this.viewProj.w()));
        }
        if (this.viewProj.w() <= 0.0f) {
            return null;
        }
        this.viewProj.div(this.viewProj.w());
        float projX = this.viewProj.x();
        float projY = this.viewProj.y();
        float resultX = 0.5f * ((float)guiWidth * (projX + 1.0f) - (float)width * projX);
        float resultY = (float)guiHeight * (0.5f - projY / 2.0f) + (float)height * projY / 2.0f;
        return new Result(resultX, resultY);
    }

    private record Result(float x, float y) {
    }
}

