/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.waypoints.waypoints.gui;

import io.github.axolotlclient.AxolotlClientConfig.impl.ui.ClickableWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.Element;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.Screen;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.TextFieldWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.ElementListWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.EntryListWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.VanillaButtonWidget;
import io.github.axolotlclient.waypoints.AxolotlClientWaypoints;
import io.github.axolotlclient.waypoints.waypoints.Waypoint;
import io.github.axolotlclient.waypoints.waypoints.gui.CreateWaypointScreen;
import io.github.axolotlclient.waypoints.waypoints.gui.EditWaypointScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.unmapped.C_2691939;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_3831727;
import net.minecraft.unmapped.C_4576025;
import net.minecraft.unmapped.C_8105098;

public class WaypointsScreen
extends Screen {
    private final C_3020744 parent;

    public WaypointsScreen(C_3020744 screen) {
        super(AxolotlClientWaypoints.tr("manage", new Object[0]));
        this.parent = screen;
    }

    public void m_3593494() {
        WaypointsList entries = new WaypointsList(this.f_7153641, this.f_3080061, this.f_5465691, this.f_3080061 - 60 - 33, 60, 25);
        this.addDrawableChild((Element)entries);
        TextFieldWidget search = (TextFieldWidget)this.addDrawableChild((Element)new TextFieldWidget(this.f_2020658, this.f_5465691 / 2 - 100, 29, 200, 20, AxolotlClientWaypoints.tr("waypoint_search", new Object[0])));
        search.setHint(AxolotlClientWaypoints.tr("waypoint_search", new Object[0]));
        search.setChangedListener(entries::applySearch);
        this.addDrawableChild((Element)new VanillaButtonWidget(this.f_5465691 / 2 - 150 - 2, this.f_3080061 - 16 - 10, 150, 20, AxolotlClientWaypoints.tr("create_waypoint", new Object[0]), btn -> this.f_7153641.m_6408915((C_3020744)new CreateWaypointScreen((C_3020744)this))));
        this.addDrawableChild((Element)new VanillaButtonWidget(this.f_5465691 / 2 + 2, this.f_3080061 - 16 - 10, 150, 20, C_4576025.m_3547652((String)"gui.done"), btn -> this.onClose()));
        entries.loadEntries(AxolotlClientWaypoints.getCurrentWaypoints(false));
    }

    public void onClose() {
        this.f_7153641.m_6408915(this.parent);
    }

    public void m_8984281() {
        AxolotlClientWaypoints.WAYPOINT_STORAGE.save();
    }

    public void m_7261014(int mouseX, int mouseY, float delta) {
        super.m_7261014(mouseX, mouseY, delta);
        this.m_2717572(this.f_2020658, this.getTitle(), this.f_5465691 / 2, 12, -1);
    }

    private class WaypointsList
    extends ElementListWidget<Entry> {
        private final List<Waypoint> waypoints;
        private String search;

        public WaypointsList(C_8105098 minecraft, int screenHeight, int width, int height, int y, int entryHeight) {
            super(minecraft, width, screenHeight, y, y + height, entryHeight);
            this.waypoints = new ArrayList<Waypoint>();
            this.search = null;
        }

        public void loadEntries(List<Waypoint> waypoints) {
            this.waypoints.clear();
            this.waypoints.addAll(waypoints);
            this.applySearch(this.search);
        }

        public void applySearch(String s) {
            this.search = s;
            this.clearEntries();
            this.waypoints.stream().filter(w -> s == null || w.name().contains(s)).forEach(w -> this.addEntry((EntryListWidget.Entry)new Entry((Waypoint)w)));
        }

        public int getRowWidth() {
            return 300;
        }

        protected int getScrollbarPositionX() {
            return this.getRowRight() + 10;
        }

        private class Entry
        extends ElementListWidget.Entry<Entry> {
            private final List<ClickableWidget> children = new ArrayList<ClickableWidget>();
            private final Waypoint waypoint;
            private final C_8105098 minecraft = C_8105098.m_0408063();

            private Entry(Waypoint waypoint) {
                this.waypoint = waypoint;
                this.children.add((ClickableWidget)new VanillaButtonWidget(0, 0, 50, 20, AxolotlClientWaypoints.tr("edit_waypoint", new Object[0]), btn -> this.minecraft.m_6408915((C_3020744)new EditWaypointScreen((C_3020744)WaypointsScreen.this, waypoint))));
                this.children.add((ClickableWidget)new VanillaButtonWidget(0, 0, 50, 20, AxolotlClientWaypoints.tr("remove_waypoint", new Object[0]), btn -> {
                    WaypointsList.this.removeEntry((EntryListWidget.Entry)this);
                    AxolotlClientWaypoints.WAYPOINT_STORAGE.getWaypoints().remove(waypoint);
                }));
            }

            public void render(int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
                C_3831727 font = this.minecraft.f_0426313;
                C_3754158.m_8373640();
                int textWidth = font.m_0040387(this.waypoint.display());
                int displayWidth = textWidth + Waypoint.displayXOffset() * 2;
                int textHeight = font.f_6725889;
                int displayHeight = textHeight + Waypoint.displayYOffset() * 2;
                C_3754158.m_3172490((float)((float)left + (float)width / 6.0f), (float)((float)top + (float)height / 2.0f), (float)0.0f);
                C_3754158.m_4552250((float)Math.min(1, 100 / displayWidth), (float)Math.min(1, 100 / displayWidth), (float)1.0f);
                C_3754158.m_8373640();
                C_3754158.m_3172490((float)((float)(-displayWidth) / 2.0f), (float)((float)(-displayHeight) / 2.0f), (float)0.0f);
                C_2691939.m_7865719((int)0, (int)0, (int)displayWidth, (int)displayHeight, (int)this.waypoint.color().toInt());
                C_3754158.m_2041265();
                C_3754158.m_3172490((float)((float)(-textWidth) / 2.0f), (float)((float)(-textHeight) / 2.0f), (float)0.0f);
                font.m_4683674(this.waypoint.display(), 0, 0, -1);
                C_3754158.m_2041265();
                C_3754158.m_8373640();
                C_3754158.m_3172490((float)((float)left + (float)width / 2.0f), (float)((float)top + (float)height / 2.0f), (float)0.0f);
                int nameWidth = font.m_0040387(this.waypoint.name());
                font.m_4683674(this.waypoint.name(), -nameWidth / 2, -textHeight / 2, -1);
                C_3754158.m_2041265();
                int buttonsX = left + width;
                for (int i = this.children.size() - 1; i >= 0; --i) {
                    ClickableWidget w = this.children.get(i);
                    w.setX(buttonsX - w.getWidth());
                    buttonsX -= w.getWidth() + 4;
                    w.setY(top + height / 2 - w.getHeight() / 2);
                    w.render(mouseX, mouseY, partialTick);
                }
            }

            public List<? extends Element> children() {
                return this.children;
            }
        }
    }
}

