/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.waypoints.waypoints.gui.util;

import com.google.common.collect.ImmutableList;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.VanillaButtonWidget;
import java.util.Collection;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_4576025;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class CycleButton<T>
extends VanillaButtonWidget {
    public static final BooleanSupplier DEFAULT_ALT_LIST_SELECTOR = C_3020744::m_3048937;
    private static final List<Boolean> BOOLEAN_OPTIONS = ImmutableList.of((Object)Boolean.TRUE, (Object)Boolean.FALSE);
    private final String name;
    private int index;
    private T value;
    private final ValueListSupplier<T> values;
    private final Function<T, String> valueStringifier;
    private final OnValueChange<T> onValueChange;
    private final boolean displayOnlyValue;

    CycleButton(int x, int y, int width, int height, String message, String name, int index, T value, ValueListSupplier<T> values, Function<T, String> valueStringifier, OnValueChange<T> onValueChange, boolean displayOnlyValue) {
        super(x, y, width, height, message, b -> {});
        this.name = name;
        this.index = index;
        this.value = value;
        this.values = values;
        this.valueStringifier = valueStringifier;
        this.onValueChange = onValueChange;
        this.displayOnlyValue = displayOnlyValue;
    }

    public void onPress() {
        if (C_3020744.m_5142737()) {
            this.cycleValue(-1);
        } else {
            this.cycleValue(1);
        }
    }

    private void cycleValue(int delta) {
        List<T> list = this.values.getSelectedList();
        this.index = Math.floorMod(this.index + delta, list.size());
        T object = list.get(this.index);
        this.updateValue(object);
        this.onValueChange.onValueChange(this, object);
    }

    private T getCycledValue(int delta) {
        List<T> list = this.values.getSelectedList();
        return list.get(Math.floorMod(this.index + delta, list.size()));
    }

    public void setValue(T value) {
        List<T> list = this.values.getSelectedList();
        int i = list.indexOf(value);
        if (i != -1) {
            this.index = i;
        }
        this.updateValue(value);
    }

    private void updateValue(T value) {
        String component = this.createLabelForValue(value);
        this.setMessage(component);
        this.value = value;
    }

    private String createLabelForValue(T value) {
        return this.displayOnlyValue ? this.valueStringifier.apply(value) : this.createFullName(value);
    }

    private String createFullName(T value) {
        return this.name + ": " + this.valueStringifier.apply(value);
    }

    public static <T> Builder<T> builder(Function<T, String> valueStringifier) {
        return new Builder<T>(valueStringifier);
    }

    public static Builder<Boolean> booleanBuilder(String componentOn, String componentOff) {
        return new Builder<Boolean>(value -> value != false ? componentOn : componentOff).withValues((Collection<Boolean>)BOOLEAN_OPTIONS);
    }

    public static Builder<Boolean> onOffBuilder() {
        return new Builder<Boolean>(value -> value != false ? C_4576025.m_3547652((String)"options.on") : C_4576025.m_3547652((String)"options.off")).withValues((Collection<Boolean>)BOOLEAN_OPTIONS);
    }

    public static Builder<Boolean> onOffBuilder(boolean initialValue) {
        return CycleButton.onOffBuilder().withInitialValue(initialValue);
    }

    @Generated
    public T getValue() {
        return this.value;
    }

    @Environment(value=EnvType.CLIENT)
    public static interface ValueListSupplier<T> {
        public List<T> getSelectedList();

        public List<T> getDefaultList();

        public static <T> ValueListSupplier<T> create(Collection<T> values) {
            ImmutableList list = ImmutableList.copyOf(values);
            return new ValueListSupplier<T>((List)list){
                final /* synthetic */ List val$list;
                {
                    this.val$list = list;
                }

                @Override
                public List<T> getSelectedList() {
                    return this.val$list;
                }

                @Override
                public List<T> getDefaultList() {
                    return this.val$list;
                }
            };
        }

        public static <T> ValueListSupplier<T> create(final BooleanSupplier altListSelector, List<T> defaultList, List<T> selectedList) {
            ImmutableList list = ImmutableList.copyOf(defaultList);
            ImmutableList list2 = ImmutableList.copyOf(selectedList);
            return new ValueListSupplier<T>(){
                final /* synthetic */ List val$list2;
                final /* synthetic */ List val$list;
                {
                    this.val$list2 = list;
                    this.val$list = list2;
                }

                @Override
                public List<T> getSelectedList() {
                    return altListSelector.getAsBoolean() ? this.val$list2 : this.val$list;
                }

                @Override
                public List<T> getDefaultList() {
                    return this.val$list;
                }
            };
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static interface OnValueChange<T> {
        public void onValueChange(CycleButton<T> var1, T var2);
    }

    @Environment(value=EnvType.CLIENT)
    public static class Builder<T> {
        private int initialIndex;
        @Nullable
        private T initialValue;
        private final Function<T, String> valueStringifier;
        private ValueListSupplier<T> values = ValueListSupplier.create(ImmutableList.of());
        private boolean displayOnlyValue;

        public Builder(Function<T, String> valueStringifier) {
            this.valueStringifier = valueStringifier;
        }

        public Builder<T> withValues(Collection<T> values) {
            return this.withValues(ValueListSupplier.create(values));
        }

        @SafeVarargs
        public final Builder<T> withValues(T ... values) {
            return this.withValues((Collection<T>)ImmutableList.copyOf((Object[])values));
        }

        public Builder<T> withValues(List<T> defaultList, List<T> selectedList) {
            return this.withValues(ValueListSupplier.create(DEFAULT_ALT_LIST_SELECTOR, defaultList, selectedList));
        }

        public Builder<T> withValues(BooleanSupplier altListSelector, List<T> defaultList, List<T> selectedList) {
            return this.withValues(ValueListSupplier.create(altListSelector, defaultList, selectedList));
        }

        public Builder<T> withValues(ValueListSupplier<T> values) {
            this.values = values;
            return this;
        }

        public Builder<T> withInitialValue(T initialValue) {
            this.initialValue = initialValue;
            int i = this.values.getDefaultList().indexOf(initialValue);
            if (i != -1) {
                this.initialIndex = i;
            }
            return this;
        }

        public Builder<T> displayOnlyValue() {
            this.displayOnlyValue = true;
            return this;
        }

        public CycleButton<T> create(int x, int y, int width, int height, String name) {
            return this.create(x, y, width, height, name, (cycleButton, value) -> {});
        }

        public CycleButton<T> create(int x, int y, int width, int height, String name, OnValueChange<T> onValueChange) {
            List<T> list = this.values.getDefaultList();
            if (list.isEmpty()) {
                throw new IllegalStateException("No values for cycle button");
            }
            T object = this.initialValue != null ? this.initialValue : list.get(this.initialIndex);
            String component = this.valueStringifier.apply(object);
            String component2 = this.displayOnlyValue ? component : name + ": " + component;
            return new CycleButton<T>(x, y, width, height, component2, name, this.initialIndex, object, this.values, this.valueStringifier, onValueChange, this.displayOnlyValue);
        }
    }
}

