/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient (Waypoints Mod).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.waypoints;

import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Comparator;
import java.util.List;
import io.github.axolotlclient.AxolotlClientConfig.api.AxolotlClientConfig;
import io.github.axolotlclient.AxolotlClientConfig.api.manager.ConfigManager;
import io.github.axolotlclient.AxolotlClientConfig.api.options.OptionCategory;
import io.github.axolotlclient.AxolotlClientConfig.impl.managers.VersionedJsonConfigManager;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.FloatOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.util.ConfigStyles;
import io.github.axolotlclient.waypoints.map.Minimap;
import io.github.axolotlclient.waypoints.map.WorldMapScreen;
import io.github.axolotlclient.waypoints.mixin.MinecraftServerAccessor;
import io.github.axolotlclient.waypoints.network.Listener;
import io.github.axolotlclient.waypoints.waypoints.Waypoint;
import io.github.axolotlclient.waypoints.waypoints.WaypointRenderer;
import io.github.axolotlclient.waypoints.waypoints.WaypointStorage;
import io.github.axolotlclient.waypoints.waypoints.gui.CreateWaypointScreen;
import io.github.axolotlclient.waypoints.waypoints.gui.WaypointsScreen;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;

@SuppressWarnings("DataFlowIssue")
public class AxolotlClientWaypoints implements ClientModInitializer {

	public static final Minimap MINIMAP = new Minimap();
	public static final WaypointStorage WAYPOINT_STORAGE = new WaypointStorage();
	public static final WaypointRenderer WAYPOINT_RENDERER = new WaypointRenderer();
	public static final Listener NETWORK_LISTENER = new Listener();

	private final OptionCategory waypoints = OptionCategory.create("waypoints");
	public static BooleanOption renderWaypoints = new BooleanOption("render_waypoints", true);
	public static BooleanOption renderWaypointsInWorld = new BooleanOption("render_waypoints_in_world", true);
	public static BooleanOption renderOutOfViewWaypointsOnScreenEdge = new BooleanOption("render_out_of_view_waypoints", true);
	public static FloatOption waypointTitleScale = new FloatOption("waypoint_title_scale", 1f, 0.1f, 2f);

	private final class_304.class_11900 category = class_304.class_11900.method_74698(rl(AxolotlClientWaypointsCommon.MODID));
	private final class_304 map = new class_304(AxolotlClientWaypointsCommon.MODID + ".world_map", class_3675.field_32027, category);
	private final class_304 manageWaypoints = new class_304(AxolotlClientWaypointsCommon.MODID + ".waypoints_menu", class_3675.field_32025, category);
	private final class_304 newWaypoint = new class_304(AxolotlClientWaypointsCommon.MODID + ".create_waypoint", class_3675.field_32028, category);
	private final class_304 toggleWaypointRendering = new class_304(AxolotlClientWaypointsCommon.MODID + ".toggle_waypoint_rendering", class_3675.field_16237.method_1444(), category);

	@Override
	public void onInitializeClient() {
		AxolotlClientWaypointsCommon.init();
		MINIMAP.init();

		AxolotlClientWaypointsCommon.category.add(waypoints);
		waypoints.add(renderWaypoints, renderWaypointsInWorld, renderOutOfViewWaypointsOnScreenEdge, waypointTitleScale);

		ConfigManager configManager;
		AxolotlClientConfig.getInstance().register(configManager = new VersionedJsonConfigManager(AxolotlClientWaypointsCommon.OPTIONS_PATH, AxolotlClientWaypointsCommon.category, 1,
			(oldVersion, newVersion, rootCategory, json) -> json));
		configManager.load();
		configManager.save();

		KeyBindingHelper.registerKeyBinding(map);
		KeyBindingHelper.registerKeyBinding(manageWaypoints);
		KeyBindingHelper.registerKeyBinding(newWaypoint);
		KeyBindingHelper.registerKeyBinding(toggleWaypointRendering);
		ClientTickEvents.END_CLIENT_TICK.register(mc -> {
			if (map.method_1436()) {
				mc.method_1507(new WorldMapScreen());
			} else if (manageWaypoints.method_1436()) {
				mc.method_1507(new WaypointsScreen(mc.field_1755));
			} else if (newWaypoint.method_1436()) {
				mc.method_1507(new CreateWaypointScreen(mc.field_1755));
			}
			if (toggleWaypointRendering.method_1436()) {
				renderWaypointsInWorld.toggle();
				configManager.save();
			}
		});
		NETWORK_LISTENER.init();
	}

	public static class_437 createOptionsScreen(class_437 parent) {
		return ConfigStyles.createScreen(parent, AxolotlClientWaypointsCommon.category);
	}

	public static class_2960 rl(String path) {
		return class_2960.method_60655(AxolotlClientWaypointsCommon.MODID, path);
	}

	public static class_2561 tr(String key, Object... args) {
		return class_2561.method_43469(AxolotlClientWaypointsCommon.MODID + "." + key, args);
	}

	public static String tra(String key) {
		return class_1074.method_4662(AxolotlClientWaypointsCommon.MODID + "." + key);
	}

	public static List<Waypoint> getCurrentWaypoints() {
		return getCurrentWaypoints(true);
	}

	public static List<Waypoint> getCurrentWaypoints(boolean dimension) {
		var mc = class_310.method_1551();
		var pos = mc.field_1724.method_73189().method_46409();
		return WAYPOINT_STORAGE.getCurrentlyAvailableWaypoints(dimension ? mc.field_1687.method_27983().method_29177().toString() : null)
			.sorted(Comparator.comparingDouble(w -> w.squaredDistTo(pos)))
			.toList();
	}

	private static String getB64(String s) {
		return new String(Base64.getUrlEncoder().encode(s.getBytes(StandardCharsets.UTF_8)));
	}

	public static Path getCurrentStorageDir() {
		var mc = class_310.method_1551();
		return getCurrentWorldStorageDir()
			.resolve(getB64(mc.field_1687.method_27983().method_29177().toString()));
	}

	public static Path getCurrentWorldStorageDir() {
		var mc = class_310.method_1551();
		String str;
		if (mc.method_1558() != null) {
			str = mc.method_1558().field_3761;
		} else {
			str = ((MinecraftServerAccessor) mc.method_1576()).getStorageSource().method_27005();
		}
		return AxolotlClientWaypointsCommon.MOD_STORAGE_DIR.resolve(getB64(str));
	}

	public static boolean playerHasOp() {
		return class_310.method_1551().field_1724.method_64475(4);
	}
}
