/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient (Waypoints Mod).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.waypoints.waypoints.gui;

import java.util.ArrayList;
import java.util.List;

import io.github.axolotlclient.waypoints.AxolotlClientWaypoints;
import io.github.axolotlclient.waypoints.waypoints.Waypoint;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6379;
import net.minecraft.class_7842;
import net.minecraft.class_7847;
import net.minecraft.class_8132;
import net.minecraft.class_8667;
import net.minecraft.client.gui.components.*;

public class WaypointsScreen extends class_437 {

	private final class_437 parent;
	private WaypointsList entries;
	private final class_8132 haF = new class_8132(this, 60, 33);
	private boolean initialized;

	public WaypointsScreen(class_437 screen) {
		super(AxolotlClientWaypoints.tr("manage"));
		this.parent = screen;
	}

	@Override
	protected void method_25426() {
		if (!initialized) {
			initialized = true;
			entries = new WaypointsList(field_22787, haF.method_25368(), haF.method_57727(), haF.method_48998(), 25);
			haF.method_48999(entries);

			var header = haF.method_48992(class_8667.method_52741()).method_52735(8);
			header.method_52738(new class_7842(method_25440(), method_64506()), class_7847::method_46467).method_25358(200);
			var search = header.method_52736(new class_342(method_64506(), 200, 20, AxolotlClientWaypoints.tr("waypoint_search")));
			search.method_47404(AxolotlClientWaypoints.tr("waypoint_search"));
			search.method_1863(entries::applySearch);

			var footer = haF.method_48996(class_8667.method_52742()).method_52735(4);
			footer.method_52736(class_4185.method_46430(AxolotlClientWaypoints.tr("create_waypoint"), btn -> field_22787.method_1507(new CreateWaypointScreen(this))).method_46431());
			footer.method_52736(class_4185.method_46430(class_5244.field_24334, btn -> method_25419()).method_46431());
		} else {
			entries.method_57712(field_22789, haF);
		}

		haF.method_48222();
		haF.method_48206(this::method_37063);

		entries.loadEntries(AxolotlClientWaypoints.getCurrentWaypoints(false));
	}

	@Override
	public void method_25419() {
		AxolotlClientWaypoints.WAYPOINT_STORAGE.save();
		field_22787.method_1507(parent);
	}

	private class WaypointsList extends class_4265<WaypointsList.Entry> {

		private final List<Waypoint> waypoints = new ArrayList<>();
		private String search = null;

		public WaypointsList(class_310 minecraft, int width, int height, int y, int entryHeight) {
			super(minecraft, width, height, y, entryHeight);
		}

		public void loadEntries(List<Waypoint> waypoints) {
			this.waypoints.clear();
			this.waypoints.addAll(waypoints);
			applySearch(search);
		}

		public void applySearch(String s) {
			this.search = s;
			method_25339();
			waypoints.stream().filter(w -> s == null || w.name().contains(s)).forEach(w -> method_25321(new Entry(w)));
		}

		@Override
		public int method_25322() {
			return 300;
		}

		private class Entry extends class_4265.class_4266<Entry> {

			private final List<class_339> children = new ArrayList<>();
			private final Waypoint waypoint;
			private final class_310 minecraft = class_310.method_1551();

			private Entry(Waypoint waypoint) {
				this.waypoint = waypoint;
				children.add(class_4185.method_46430(AxolotlClientWaypoints.tr("edit_waypoint"), btn ->
					minecraft.method_1507(new EditWaypointScreen(WaypointsScreen.this, waypoint))).method_46432(50).method_46431());
				children.add(class_4185.method_46430(AxolotlClientWaypoints.tr("remove_waypoint"), btn -> {
					method_25330(this);
					AxolotlClientWaypoints.WAYPOINT_STORAGE.getWaypoints().remove(waypoint);
				}).method_46432(50).method_46431());
			}

			@Override
			public List<? extends class_6379> method_37025() {
				return children;
			}

			@Override
			public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
				var left = method_73380();
				var top = method_73382();
				var font = minecraft.field_1772;
				guiGraphics.method_51448().pushMatrix();
				int textWidth = font.method_1727(waypoint.display());
				int displayWidth = textWidth + Waypoint.displayXOffset() * 2;
				int textHeight = font.field_2000;
				int displayHeight = textHeight + Waypoint.displayYOffset() * 2;
				guiGraphics.method_51448().translate(left + field_22758 / 6f, top + field_22759 / 2f);
				guiGraphics.method_51448().scale(Math.min(1, 100 / displayWidth));
				guiGraphics.method_51448().pushMatrix();
				guiGraphics.method_51448().translate(-displayWidth / 2f, -displayHeight / 2f);
				guiGraphics.method_25294(0, 0, displayWidth, displayHeight, waypoint.color().toInt());
				guiGraphics.method_51448().popMatrix();
				guiGraphics.method_51448().translate(-textWidth / 2f, -textHeight / 2f);
				guiGraphics.method_25303(font, waypoint.display(), 0, 0, -1);
				guiGraphics.method_51448().popMatrix();
				guiGraphics.method_51448().pushMatrix();
				guiGraphics.method_51448().translate(left + field_22758 / 2f, top + field_22759 / 2f);
				int nameWidth = font.method_1727(waypoint.name());
				guiGraphics.method_25303(font, waypoint.name(), -nameWidth / 2, -font.field_2000 / 2, -1);
				guiGraphics.method_51448().popMatrix();

				int buttonsX = left + field_22758;
				for (int i = children.size() - 1; i >= 0; i--) {
					class_339 w = children.get(i);
					w.method_46421(buttonsX - w.method_25368());
					buttonsX -= w.method_25368() + 4;
					w.method_46419(top + field_22759 / 2 - w.method_25364() / 2);
					w.method_25394(guiGraphics, mouseX, mouseY, partialTick);
				}
			}

			@Override
			public List<? extends class_364> method_25396() {
				return children;
			}
		}
	}
}
