/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.waypoints.map;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import io.github.axolotlclient.waypoints.AxolotlClientWaypoints;
import io.github.axolotlclient.waypoints.util.ARGB;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.resource.v1.ResourceLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3620;
import net.minecraft.class_4013;

public class TextureSampler {
    private static final class_310 minecraft = class_310.method_1551();
    private static final Object2IntMap<class_2680> sampleCache = new Object2IntOpenHashMap();
    private static final Object2ObjectMap<class_2960, class_1011> atlasCache = new Object2ObjectOpenHashMap();
    private static boolean sampling;
    private static final List<Supplier<CompletableFuture<Integer>>> sampleQueue;

    public static CompletableFuture<Integer> getSample(class_2680 state, class_1937 level, class_2338 pos, class_3620.class_6594 brightness) {
        if (state.method_26215()) {
            return CompletableFuture.completedFuture(0);
        }
        if (sampleCache.containsKey((Object)state)) {
            return CompletableFuture.completedFuture(TextureSampler.applyTransforms(sampleCache.getInt((Object)state), state, level, pos, brightness));
        }
        Supplier<CompletableFuture> sup = () -> {
            if (sampleCache.containsKey((Object)state)) {
                int cached = sampleCache.getInt((Object)state);
                if (!sampleQueue.isEmpty()) {
                    Supplier[] list = (Supplier[])sampleQueue.toArray(Supplier[]::new);
                    sampleQueue.clear();
                    for (Supplier e : list) {
                        e.get();
                    }
                }
                sampling = false;
                return CompletableFuture.completedFuture(TextureSampler.applyTransforms(cached, state, level, pos, brightness));
            }
            class_1087 model = minecraft.method_1554().method_4743().method_3335(state);
            class_1058 tex = model.method_68511();
            return ((CompletableFuture)TextureSampler.downloadAtlas(tex.method_45852()).thenApply(i -> TextureSampler.sampleSprite(i, tex))).thenApply(x -> {
                sampleCache.put((Object)state, x.intValue());
                if (!sampleQueue.isEmpty()) {
                    Supplier[] list = (Supplier[])sampleQueue.toArray(Supplier[]::new);
                    sampleQueue.clear();
                    for (Supplier e : list) {
                        e.get();
                    }
                }
                sampling = false;
                return TextureSampler.applyTransforms(x, state, level, pos, brightness);
            });
        };
        if (!sampling) {
            sampling = true;
            return sup.get();
        }
        CompletableFuture<Integer> cf = new CompletableFuture<Integer>();
        sampleQueue.add(() -> ((CompletableFuture)sup.get()).thenApply(i -> {
            cf.complete((Integer)i);
            return i;
        }));
        return cf;
    }

    private static int applyTransforms(int color, class_2680 state, class_1937 level, class_2338 pos, class_3620.class_6594 brightness) {
        int col = minecraft.method_1505().method_1697(state, (class_1920)level, pos, 0);
        class_3610 fluid = state.method_26227();
        if (!fluid.method_15769() && fluid.method_15767(class_3486.field_15517)) {
            int b = ((class_1959)TextureSampler.minecraft.field_1687.method_23753(pos).comp_349()).method_8687();
            float shade = TextureSampler.minecraft.field_1687.method_24852(class_2350.field_11036, true);
            int f = ARGB.colorFromFloat((float)1.0f, (float)(ARGB.redFloat((int)b) * shade), (float)(ARGB.greenFloat((int)b) * shade), (float)(ARGB.blueFloat((int)b) * shade));
            color = ARGB.color((int)ARGB.alpha((int)color), (int)f);
        }
        if (col != -1 && TextureSampler.isGrayscaleColor(color)) {
            color = ARGB.color((int)ARGB.alpha((int)color), (int)col);
        }
        return ARGB.scaleRGB((int)color, (int)brightness.field_34764);
    }

    private static boolean isGrayscaleColor(int color) {
        return ARGB.red((int)color) == ARGB.green((int)color) && ARGB.red((int)color) == ARGB.blue((int)color);
    }

    private static CompletableFuture<class_1011> downloadAtlas(class_2960 loc) {
        if (atlasCache.containsKey((Object)loc)) {
            return CompletableFuture.completedFuture((class_1011)atlasCache.get((Object)loc));
        }
        RenderSystem.assertOnRenderThread();
        CompletableFuture<class_1011> cf = new CompletableFuture<class_1011>();
        GpuTexture gpuTexture = minecraft.method_1531().method_4619(loc).method_68004();
        int bufferSize = gpuTexture.getFormat().pixelSize() * gpuTexture.getWidth(0) * gpuTexture.getHeight(0);
        GpuBuffer gpuBuffer = RenderSystem.getDevice().createBuffer(() -> "Texture Atlas buffer", 9, bufferSize);
        CommandEncoder commandEncoder = RenderSystem.getDevice().createCommandEncoder();
        commandEncoder.copyTextureToBuffer(gpuTexture, gpuBuffer, 0, () -> {
            try (GpuBuffer.MappedView mappedView = commandEncoder.mapBuffer(gpuBuffer, true, false);){
                int textureWidth = gpuTexture.getWidth(0);
                int textureHeight = gpuTexture.getHeight(0);
                class_1011 img = new class_1011(textureWidth, textureHeight, false);
                for (int n = 0; n < textureHeight; ++n) {
                    for (int o = 0; o < textureWidth; ++o) {
                        img.method_4305(o, n, mappedView.data().getInt((o + n * textureWidth) * gpuTexture.getFormat().pixelSize()));
                    }
                }
                atlasCache.put((Object)loc, (Object)img);
                cf.complete(img);
            }
            gpuBuffer.close();
        }, 0);
        return cf;
    }

    private static int sampleSprite(class_1011 image, class_1058 sprite) {
        int sampled = 0;
        for (int n = sprite.method_35807(); n < sprite.method_35807() + sprite.method_45851().method_45815(); ++n) {
            for (int o = sprite.method_35806(); o < sprite.method_35806() + sprite.method_45851().method_45807(); ++o) {
                int c = image.method_61940(o, n);
                sampled = TextureSampler.getColorAvg(sampled, c);
            }
        }
        return sampled;
    }

    private static int getColorAvg(int a, int b) {
        if (a == 0) {
            return b;
        }
        if (ARGB.alpha((int)b) == 0) {
            return a;
        }
        return ARGB.average((int)a, (int)b);
    }

    static {
        sampleQueue = new ArrayList<Supplier<CompletableFuture<Integer>>>();
        ResourceLoader.get((class_3264)class_3264.field_14188).registerReloader(AxolotlClientWaypoints.rl("reload_listener"), (class_3302)((class_4013)rm -> {
            atlasCache.values().forEach(class_1011::close);
            atlasCache.clear();
            sampleCache.clear();
            sampleQueue.clear();
            sampling = false;
        }));
    }
}

