/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.waypoints.waypoints;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.AxolotlClientConfig.impl.util.DrawUtil;
import io.github.axolotlclient.waypoints.AxolotlClientWaypoints;
import io.github.axolotlclient.waypoints.mixin.GameRendererAccessor;
import io.github.axolotlclient.waypoints.waypoints.Waypoint;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_10209;
import net.minecraft.class_10366;
import net.minecraft.class_10799;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3695;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_9779;
import net.minecraft.class_9909;
import net.minecraft.class_9916;
import net.minecraft.class_9922;
import net.minecraft.class_9960;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class WaypointRenderer {
    private static final double CUTOFF_DIST = 5.0;
    private final class_310 minecraft = class_310.method_1551();
    private final class_1921 QUADS = class_1921.method_24049((String)"waypoint_quads", (int)1536, (boolean)false, (boolean)true, (RenderPipeline)class_10799.field_56879, (class_1921.class_4688)class_1921.class_4688.method_23598().method_23617(false));
    private final Matrix4f view = new Matrix4f();
    private final Vector4f viewProj = new Vector4f();
    private final Set<Waypoint> worldRendererWaypoints = new HashSet<Waypoint>();

    public void render(class_9922 allocator, class_9960 targets, class_9779 deltaTracker) {
        if (!AxolotlClientWaypoints.renderWaypoints.get().booleanValue()) {
            return;
        }
        if (!AxolotlClientWaypoints.renderWaypointsInWorld.get().booleanValue()) {
            return;
        }
        if (this.minecraft.field_1687 == null) {
            return;
        }
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15405("waypoints");
        float f = deltaTracker.method_60637(true);
        class_9909 frameGraphBuilder = new class_9909();
        targets.field_53091 = frameGraphBuilder.method_61914("main", (Object)this.minecraft.method_1522());
        class_9916 pass = frameGraphBuilder.method_61911("waypoints");
        targets.field_53091 = pass.method_61933(targets.field_53091);
        pass.method_61929(() -> {
            class_4597.class_4598 bufferSource = this.minecraft.method_22940().method_23000();
            float fov = ((GameRendererAccessor)this.minecraft.field_1773).invokeGetFov(this.minecraft.field_1773.method_19418(), f, true);
            RenderSystem.setProjectionMatrix((GpuBufferSlice)((GameRendererAccessor)this.minecraft.field_1773).getHud3dProjectionMatrixBuffer().method_71095(this.minecraft.method_22683().method_4489(), this.minecraft.method_22683().method_4506(), fov), (class_10366)class_10366.field_54953);
            class_4587 stack = new class_4587();
            class_4184 cam = this.minecraft.field_1773.method_19418();
            stack.method_22903();
            stack.method_22907((Quaternionfc)cam.method_23767().invert());
            class_243 camPos = AxolotlClientWaypoints.WAYPOINT_RENDERER.minecraft.field_1773.method_19418().method_19326();
            this.worldRendererWaypoints.clear();
            for (Waypoint waypoint : AxolotlClientWaypoints.getCurrentWaypoints()) {
                profiler.method_15396(waypoint.name());
                this.renderWaypoint(waypoint, stack, camPos, cam, bufferSource, fov);
                profiler.method_15407();
            }
            stack.method_22909();
            bufferSource.method_37104();
            if (!stack.method_67795()) {
                throw new IllegalStateException("Pose stack not empty");
            }
        });
        frameGraphBuilder.method_61909(allocator);
    }

    private void renderWaypoint(Waypoint waypoint, class_4587 stack, class_243 camPos, class_4184 cam, class_4597.class_4598 bufferSource, float fov) {
        int textWidth = this.minecraft.field_1772.method_1727(waypoint.display());
        int width = textWidth + Waypoint.displayXOffset() * 2;
        Objects.requireNonNull(this.minecraft.field_1772);
        int textHeight = 9;
        int height = textHeight + Waypoint.displayYOffset() * 2;
        Result displayStart = this.projectToScreen(cam, fov, width, height, waypoint.x(), waypoint.y(), waypoint.z(), new Vector2f(-((float)width / 2.0f * 0.04f), (float)height / 2.0f * 0.04f));
        if (displayStart == null) {
            return;
        }
        Result displayEnd = this.projectToScreen(cam, fov, width, height, waypoint.x(), waypoint.y(), waypoint.z(), new Vector2f((float)width / 2.0f * 0.04f, -((float)height / 2.0f * 0.04f)));
        if (displayEnd == null) {
            return;
        }
        float projWidth = Math.abs(displayEnd.x() - displayStart.x());
        float projHeight = Math.abs(displayEnd.y() - displayStart.y());
        if (projWidth < (float)width && projHeight < (float)height) {
            return;
        }
        this.worldRendererWaypoints.add(waypoint);
        stack.method_22903();
        stack.method_22904(waypoint.x() - camPos.method_10216(), waypoint.y() - camPos.method_10214(), waypoint.z() - camPos.method_10215());
        stack.method_22907((Quaternionfc)cam.method_23767().invert(new Quaternionf()));
        float scale = 0.04f;
        stack.method_22905(scale, -scale, scale);
        this.fillRect(stack, bufferSource, (float)(-width) / 2.0f, (float)(-height) / 2.0f, 0.0f, (float)width / 2.0f, (float)height / 2.0f, waypoint.color().toInt());
        this.drawFontBatch(waypoint.display(), (float)(-textWidth) / 2.0f, (float)(-textHeight) / 2.0f, stack.method_23760().method_23761(), (class_4597)bufferSource);
        stack.method_22909();
    }

    private void fillRect(class_4587 stack, class_4597.class_4598 source, float x, float y, float z, float x2, float y2, int color) {
        class_4588 buf = source.method_73477(this.QUADS);
        Matrix4f matrix = stack.method_23760().method_23761();
        buf.method_22918(matrix, x, y, z).method_39415(color);
        buf.method_22918(matrix, x, y2, z).method_39415(color);
        buf.method_22918(matrix, x2, y2, z).method_39415(color);
        buf.method_22918(matrix, x2, y, z).method_39415(color);
    }

    private void drawFontBatch(String text, float x, float y, Matrix4f matrix, class_4597 bufferSource) {
        this.minecraft.field_1772.method_27521(text, x, y, -1, false, matrix, bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
    }

    public void renderWaypoints(class_332 graphics, class_9779 deltaTracker) {
        if (!AxolotlClientWaypoints.renderWaypoints.get().booleanValue()) {
            return;
        }
        if (!AxolotlClientWaypoints.renderWaypointsInWorld.get().booleanValue()) {
            return;
        }
        class_3695 profiler = class_10209.method_64146();
        class_4184 cam = this.minecraft.field_1773.method_19418();
        profiler.method_15396("waypoints");
        graphics.method_51448().pushMatrix();
        List<Waypoint> waypoints = AxolotlClientWaypoints.getCurrentWaypoints();
        ArrayList<Runnable> positionDrawers = new ArrayList<Runnable>(waypoints.size());
        for (Waypoint waypoint : waypoints) {
            graphics.method_51448().pushMatrix();
            this.renderWaypoint(waypoint, graphics, deltaTracker, cam, positionDrawers);
            graphics.method_51448().popMatrix();
        }
        if (!positionDrawers.isEmpty()) {
            positionDrawers.forEach(Runnable::run);
        }
        graphics.method_51448().popMatrix();
        profiler.method_15407();
    }

    private void renderWaypoint(Waypoint waypoint, class_332 graphics, class_9779 tracker, class_4184 camera, List<Runnable> positionDrawers) {
        boolean displayY;
        boolean _3dOnScreen;
        boolean outOfView;
        float projHeight;
        float projWidth;
        float tick = tracker.method_60637(true);
        float fov = ((GameRendererAccessor)this.minecraft.field_1773).invokeGetFov(camera, tick, true);
        Matrix3x2fStack pose = graphics.method_51448();
        int textWidth = this.minecraft.field_1772.method_1727(waypoint.display());
        int width = textWidth + Waypoint.displayXOffset() * 2;
        Objects.requireNonNull(this.minecraft.field_1772);
        int textHeight = 9;
        int height = textHeight + Waypoint.displayYOffset() * 2;
        class_243 camPos = camera.method_71156();
        Result displayStart = this.projectToScreen(camera, fov, width, height, waypoint.x(), waypoint.y(), waypoint.z(), new Vector2f(-((float)width / 2.0f * 0.04f), (float)height / 2.0f * 0.04f));
        Result displayEnd = this.projectToScreen(camera, fov, width, height, waypoint.x(), waypoint.y(), waypoint.z(), new Vector2f((float)width / 2.0f * 0.04f, -((float)height / 2.0f * 0.04f)));
        Result result = this.projectToScreen(camera, fov, width, height, waypoint.x(), waypoint.y(), waypoint.z(), null);
        if (result == null) {
            return;
        }
        if (displayStart != null && displayEnd != null) {
            projWidth = Math.abs(displayEnd.x() - displayStart.x());
            projHeight = Math.abs(displayEnd.y() - displayStart.y());
        } else {
            projWidth = 0.0f;
            projHeight = 0.0f;
        }
        pose.translate(result.x(), result.y());
        boolean bl = outOfView = result.x() < (float)(-width) / 2.0f || result.x() > (float)graphics.method_51421() + (float)width / 2.0f || result.y() < (float)(-height) / 2.0f || result.y() > (float)graphics.method_51443() + (float)height / 2.0f;
        if (!AxolotlClientWaypoints.renderOutOfViewWaypointsOnScreenEdge.get().booleanValue() && outOfView) {
            return;
        }
        if (displayEnd != null && displayStart != null) {
            float minX = displayStart.x();
            float minY = displayStart.y();
            float maxX = displayEnd.x();
            float maxY = displayEnd.y();
            int guiWidth = graphics.method_51421();
            int guiHeight = graphics.method_51443();
            _3dOnScreen = minX > 0.0f && minY > 0.0f && minX < (float)guiWidth && minY < (float)guiHeight || minX > 0.0f && maxY > 0.0f && minX < (float)guiWidth && maxY < (float)guiHeight || maxX > 0.0f && maxY > 0.0f && maxX < (float)guiWidth && maxY < (float)guiHeight || maxX > 0.0f && minY > 0.0f && maxX < (float)guiWidth && minY < (float)guiHeight || minX < (float)guiWidth && maxX > 0.0f && minY < (float)guiHeight && maxY > 0.0f;
        } else {
            _3dOnScreen = false;
        }
        boolean displayX = Math.abs(result.x() - (float)graphics.method_51421() / 2.0f) < (_3dOnScreen ? Math.max(projWidth, (float)width) : (float)width) / 2.0f + (float)graphics.method_51421() / 4.0f;
        boolean bl2 = displayY = Math.abs(result.y() - (float)graphics.method_51443() / 2.0f) < (_3dOnScreen ? Math.max((float)height, projHeight) : (float)height) / 2.0f + (float)graphics.method_51443() / 4.0f;
        if (displayX && displayY) {
            pose.pushMatrix();
            pose.translate(0.0f, Math.max((float)height, projHeight + 4.0f) / 2.0f + 4.0f);
            Vector2f pos = pose.transformPosition(new Vector2f());
            if ((projWidth >= (float)width || projHeight >= (float)height) && _3dOnScreen) {
                pos.y = Math.min(pos.y, displayEnd.y() + 6.0f);
            }
            positionDrawers.add(() -> {
                String line1 = waypoint.name();
                pose.pushMatrix();
                pose.translate((Vector2fc)pos);
                graphics.method_51448().scale(((Float)AxolotlClientWaypoints.waypointTitleScale.get()).floatValue());
                int line1W = this.minecraft.field_1772.method_1727(line1);
                int n = -line1W / 2 - 2;
                int n2 = line1W / 2 + 2;
                Objects.requireNonNull(this.minecraft.field_1772);
                graphics.method_25294(n, -2, n2, 9 + 2, Colors.GRAY.withAlpha(100).toInt());
                int n3 = -line1W / 2 - 2;
                Objects.requireNonNull(this.minecraft.field_1772);
                DrawUtil.outlineRect((class_332)graphics, (int)n3, (int)-2, (int)(line1W + 4), (int)(9 + 4), (int)Colors.GRAY.toInt());
                graphics.method_51433(this.minecraft.field_1772, line1, -line1W / 2, 0, -1, true);
                if (!waypoint.closerToThan(camPos.method_10216(), camPos.method_10214(), camPos.method_10215(), 5.0)) {
                    Objects.requireNonNull(this.minecraft.field_1772);
                    pose.translate(0.0f, (float)(9 + 4));
                    class_2561 line2 = AxolotlClientWaypoints.tr("distance", "%.2f".formatted(waypoint.distTo(camPos.method_10216(), camPos.method_10214(), camPos.method_10215())));
                    graphics.method_51439(this.minecraft.field_1772, line2, -this.minecraft.field_1772.method_27525((class_5348)line2) / 2, 0, -1, false);
                }
                pose.popMatrix();
            });
            pose.popMatrix();
        }
        if ((projWidth >= (float)width || projHeight >= (float)height) && _3dOnScreen && this.worldRendererWaypoints.contains(waypoint)) {
            return;
        }
        graphics.method_25294(-width / 2, -height / 2, width / 2, height / 2, waypoint.color().toInt());
        graphics.method_51433(this.minecraft.field_1772, waypoint.display(), -textWidth / 2, -textHeight / 2, -1, false);
    }

    @Nullable
    private Result projectToScreen(class_4184 camera, float fov, float xScreenMargin, float yScreenMargin, double x, double y, double z, Vector2f orthoOffset) {
        this.viewProj.set(x, y, z, 1.0);
        if (orthoOffset != null) {
            Matrix4f vec = new Matrix4f();
            vec.rotate((Quaternionfc)camera.method_23767().invert(new Quaternionf()));
            vec.translate(orthoOffset.x(), orthoOffset.y(), 0.0f);
            vec.rotate((Quaternionfc)camera.method_23767());
            vec.transform(this.viewProj);
        }
        this.view.rotation((Quaternionfc)camera.method_23767()).translate((Vector3fc)camera.method_71156().method_46409().negate());
        Matrix4f projection = this.minecraft.field_1773.method_22973(fov);
        projection.mul((Matrix4fc)this.view);
        this.viewProj.mul((Matrix4fc)projection);
        if (orthoOffset == null && AxolotlClientWaypoints.renderOutOfViewWaypointsOnScreenEdge.get().booleanValue()) {
            this.viewProj.w = Math.max(Math.abs(this.viewProj.x()), Math.max(Math.abs(this.viewProj.y()), this.viewProj.w()));
        }
        if (this.viewProj.w() <= 0.0f) {
            return null;
        }
        this.viewProj.div(this.viewProj.w());
        float projX = this.viewProj.x();
        float projY = this.viewProj.y();
        float resultX = 0.5f * ((float)this.minecraft.method_22683().method_4486() * (projX + 1.0f) - xScreenMargin * projX);
        float resultY = (float)this.minecraft.method_22683().method_4502() * (0.5f - projY / 2.0f) + yScreenMargin * projY / 2.0f;
        return new Result(resultX, resultY);
    }

    private record Result(float x, float y) {
    }
}

