/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient (Waypoints Mod).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.waypoints.map.widgets;

import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.ClickableWidget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_4976084;
import net.minecraft.unmapped.C_5819357;
import net.minecraft.unmapped.C_8105098;
import org.lwjgl.input.Keyboard;

@Environment(EnvType.CLIENT)
public abstract class AbstractSliderButton extends ClickableWidget {
	private static final C_0561170 SLIDER_LOCATION = new C_0561170("textures/gui/slider.png");
	protected static final int TEXTURE_WIDTH = 200;
	protected static final int TEXTURE_HEIGHT = 20;
	protected static final int TEXTURE_BORDER_X = 20;
	protected static final int TEXTURE_BORDER_Y = 4;
	protected static final int TEXT_MARGIN = 2;
	private static final int HEIGHT = 20;
	private static final int HANDLE_HALF_WIDTH = 4;
	private static final int HANDLE_WIDTH = 8;
	private static final int BACKGROUND = 0;
	private static final int BACKGROUND_FOCUSED = 1;
	private static final int HANDLE = 2;
	private static final int HANDLE_FOCUSED = 3;
	protected double value;
	private boolean canChangeValue;

	public AbstractSliderButton(int x, int y, int width, int height, String message, double value) {
		super(x, y, width, height, message);
		this.value = value;
	}


	@Override
	public void drawWidget(int mouseX, int mouseY, float partialTick) {
		C_8105098 minecraft = C_8105098.m_0408063();
		//RenderSystem.enableBlend();
		//RenderSystem.defaultBlendFunc();
		//RenderSystem.enableDepthTest();
		minecraft.m_1218956().m_5325521(WIDGETS_LOCATION);
		this.m_4354119(this.getX(), this.getY(), 0, 46, this.getWidth() / 2, this.getHeight());
		this.m_4354119(this.getX() + this.getWidth() / 2, this.getY(), 200 - this.getWidth() / 2, 46, this.getWidth() / 2, this.getHeight());
		int i = (this.isHovered() ? 2 : 1) * 20;
		this.m_4354119(this.getX() + (int) (this.value * (double) (this.getWidth() - 8)), this.getY(), 0, 46 + i, 4, 20);
		this.m_4354119(this.getX() + (int) (this.value * (double) (this.getWidth() - 8)) + 4, this.getY(), 196, 46 + i, 4, 20);

		drawScrollingText(getMessage(), getX(), getY(), getWidth(), getHeight(), Colors.WHITE);
	}

	@Override
	public void onClick(double mouseX, double mouseY) {
		this.setValueFromMouse(mouseX);
	}

	@Override
	public void setFocused(boolean focused) {
		super.setFocused(focused);
		if (!focused) {
			this.canChangeValue = false;
		} else {
			//InputType inputType = Minecraft.getInstance().getLastInputType();
			//if (inputType == InputType.MOUSE || inputType == InputType.KEYBOARD_TAB) {
			this.canChangeValue = true;
			//}
		}
	}

	@Override
	public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
		if (keyCode == Keyboard.KEY_SPACE || keyCode == Keyboard.KEY_RETURN) {
			this.canChangeValue = !this.canChangeValue;
			return true;
		} else {
			if (this.canChangeValue) {
				boolean bl = keyCode == 263;
				if (bl || keyCode == 262) {
					float f = bl ? -1.0F : 1.0F;
					this.setValue(this.value + f / (this.getWidth() - 8));
					return true;
				}
			}

			return false;
		}
	}

	private void setValueFromMouse(double mouseX) {
		this.setValue((mouseX - (this.getX() + 4)) / (this.getWidth() - 8));
	}

	private void setValue(double value) {
		double d = this.value;
		this.value = C_4976084.m_0987703(value, 0.0, 1.0);
		if (d != this.value) {
			this.applyValue();
		}

		this.updateMessage();
	}

	@Override
	protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
		this.setValueFromMouse(mouseX);
		super.onDrag(mouseX, mouseY, dragX, dragY);
	}

	@Override
	public void playDownSound(C_5819357 soundManager) {

	}

	@Override
	public void onRelease(double mouseX, double mouseY) {
		super.playDownSound(C_8105098.m_0408063().m_7555106());
	}

	protected abstract void updateMessage();

	protected abstract void applyValue();
}
