/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient (Waypoints Mod).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.waypoints.waypoints.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.ColorOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.ColorWidget;
import io.github.axolotlclient.waypoints.AxolotlClientWaypoints;
import io.github.axolotlclient.waypoints.waypoints.Waypoint;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5676;
import net.minecraft.class_6382;
import net.minecraft.class_7842;
import net.minecraft.class_7843;
import net.minecraft.class_7852;
import net.minecraft.class_8021;
import net.minecraft.class_8132;
import net.minecraft.class_8667;
import net.minecraft.client.gui.components.*;
import net.minecraft.client.gui.layouts.*;

public class EditWaypointScreen extends class_437 {

	private final class_8132 haFL = new class_8132(this);
	private final class_437 parent;
	private double x = -1, y = -1, z = -1;
	private class_4185 save;
	private boolean initialized;
	private final List<class_8021> centeredLayouts = new ArrayList<>();
	private final Waypoint toEdit;

	public EditWaypointScreen(class_437 screen, Waypoint toEdit) {
		super(AxolotlClientWaypoints.tr("edit_waypoint_title"));
		this.parent = screen;
		this.toEdit = toEdit;
	}

	@Override
	protected void method_25426() {
		if (!initialized) {
			haFL.method_57726(method_25440(), method_64506());
			ColorOption color = new ColorOption("", toEdit.color().immutable());

			var contents = haFL.method_48999(class_8667.method_52741()).method_52735(4);
			contents.method_52736(new class_7842(AxolotlClientWaypoints.tr("waypoint_position"), method_64506())).method_48597().method_25358(haFL.method_25368());
			var dimensionLine = contents.method_52736(class_8667.method_52742()).method_52735(4);
			dimensionLine.method_52736(new class_7842(AxolotlClientWaypoints.tr("waypoint_position.dimension"), method_64506())).method_53533(20);
			var dimension = dimensionLine.method_52736(new class_342(method_64506(), 150, 20, AxolotlClientWaypoints.tr("waypoint_position_dimension")));
			dimension.method_1852(toEdit.dimension());
			var positionLine = contents.method_52736(class_8667.method_52742()).method_52735(4);
			positionLine.method_52736(new class_7842(AxolotlClientWaypoints.tr("waypoint_position.x_label"), method_64506())).method_53533(20);
			var x = positionLine.method_52736(new class_342(method_64506(), 75, 20, AxolotlClientWaypoints.tr("waypoint_position.x")));
			positionLine.method_52736(new class_7842(AxolotlClientWaypoints.tr("waypoint_position.y_label"), method_64506())).method_53533(20);
			var y = positionLine.method_52736(new class_342(method_64506(), 75, 20, AxolotlClientWaypoints.tr("waypoint_position.y")));
			positionLine.method_52736(new class_7842(AxolotlClientWaypoints.tr("waypoint_position.z_label"), method_64506())).method_53533(20);
			var z = positionLine.method_52736(new class_342(method_64506(), 75, 20, AxolotlClientWaypoints.tr("waypoint_position.z")));
			x.method_1863(s -> {
				try {
					this.x = Double.parseDouble(s);
				} catch (Exception ignored) {
					this.x = -1;
				}
			});
			y.method_1863(s -> {
				try {
					this.y = Double.parseDouble(s);
				} catch (Exception ignored) {
					this.y = -1;
				}
			});
			z.method_1863(s -> {
				try {
					this.z = Double.parseDouble(s);
				} catch (Exception ignored) {
					this.z = -1;
				}
			});
			x.method_1852(String.valueOf(toEdit.x()));
			y.method_1852(String.valueOf(toEdit.y()));
			z.method_1852(String.valueOf(toEdit.z()));
			contents.method_52736(class_7852.method_46513(10));

			contents.method_52736(new class_7842(AxolotlClientWaypoints.tr("waypoint_display"), method_64506())).method_48597().method_25358(haFL.method_25368());
			var nameLine = contents.method_52736(class_8667.method_52742()).method_52735(4);
			nameLine.method_52736(new class_7842(AxolotlClientWaypoints.tr("waypoint_display.name_label"), method_64506())).method_53533(20);
			var name = nameLine.method_52736(new class_342(method_64506(), 100, 20, AxolotlClientWaypoints.tr("waypoint_display.name")));
			nameLine.method_52736(new class_7842(AxolotlClientWaypoints.tr("waypoint_display.display_label"), method_64506())).method_53533(20);
			var display = nameLine.method_52736(new class_342(method_64506(), 50, 20, AxolotlClientWaypoints.tr("waypoint_display.display")));
			var lockButton = nameLine.method_52736(class_5676.method_32613(true).method_57720(AxolotlClientWaypoints.tr("waypoint_display.unlock_display"), (btn, v) -> {
				display.field_22763 = !v;
			}));
			lockButton.method_25358(100);
			name.method_1852(toEdit.name());
			name.method_1863(s -> {
				if (lockButton.method_32603()) {
					var d = s.trim();
					display.method_1852(d.isEmpty() ? "" : d.substring(0, 1).toUpperCase(Locale.ROOT));
				}
			});
			display.field_22763 = false;
			display.method_1852(toEdit.display());
			name.method_1880(150);
			display.method_1880(10);
			contents.method_52736(class_7852.method_46513(10));

			contents.method_52736(new class_7842(AxolotlClientWaypoints.tr("waypoint_color"), method_64506())).method_48597().method_25358(haFL.method_25368());
			var colorLine = contents.method_52736(class_8667.method_52742()).method_52735(4);
			colorLine.method_52736(new class_339(0, 0, 100, 20, class_2561.method_43473()) {
				@Override
				protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
					guiGraphics.method_25294(method_46426(), method_46427(), method_55442(), method_55443(), color.get().toInt());
					guiGraphics.method_49601(method_46426(), method_46427(), method_25368(), method_25364(), Colors.BLACK.toInt());
				}

				@Override
				protected void method_47399(class_6382 narrationElementOutput) {

				}
			}).field_22763 = false;
			colorLine.method_52736(new ColorWidget(0, 0, 100, 20, color));

			var footer = haFL.method_48996(class_8667.method_52742()).method_52735(4);
			save = footer.method_52736(class_4185.method_46430(class_5244.field_24334, btn -> {
				AxolotlClientWaypoints.WAYPOINT_STORAGE.replace(toEdit, new Waypoint(dimension.method_1882(), this.x, this.y, this.z, color.getOriginal(), name.method_1882(), display.method_1882()));
				field_22787.method_1507(parent);
			}).method_46431());
			footer.method_52736(class_4185.method_46430(class_5244.field_24335, btn -> field_22787.method_1507(parent)).method_46431());

			initialized = true;
			centeredLayouts.add(dimensionLine);
			centeredLayouts.add(positionLine);
			centeredLayouts.add(nameLine);
			centeredLayouts.add(colorLine);
		}
		haFL.method_48222();
		centeredLayouts.forEach(child -> class_7843.method_46442(child, 0, child.method_46427(), haFL.method_25368(), child.method_25364()));
		haFL.method_48206(this::method_37063);
	}

	@Override
	public void method_25393() {
		save.field_22763 = x != -1 && y != -1 && z != -1;
	}
}
