/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient (Waypoints Mod).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.waypoints.map.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2902;
import net.minecraft.class_7995;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;

public class LevelChunkStorage {

	public record Entry(class_2791 chunk) {
		public void write(class_2540 buf) {
			LevelChunkStorage.write(chunk, buf);
		}

		public static Entry read(class_1937 level, class_2540 buf) {
			return new Entry(LevelChunkStorage.read(level, buf));
		}

		public void write(Path path) throws IOException {

			var buf = buffer();
			write(buf);
			Files.copy(new ByteBufInputStream(buf), path, StandardCopyOption.REPLACE_EXISTING);

		}

		public static Entry read(Path path, class_1937 level) throws IOException {
			return read(level, new class_2540(Unpooled.wrappedBuffer(Files.readAllBytes(path))));
		}
	}

	public static void writeEntries(List<Entry> entries, class_2540 buf) {
		buf.method_34062(entries, (b, e) -> e.write(b));
	}

	public static List<Entry> readEntries(class_1937 level, class_2540 buf) {
		return buf.method_34066(e -> Entry.read(level, e));
	}

	public static class_2540 buffer() {
		return new class_2540(Unpooled.buffer());
	}

	private static final Object2IntMap<class_2902.class_2903> IDS = class_156.method_656(() -> {
		Object2IntMap<class_2902.class_2903> map = new Object2IntArrayMap<>(5);
		map.put(class_2902.class_2903.field_13194, 0);
		map.put(class_2902.class_2903.field_13202, 1);
		map.put(class_2902.class_2903.field_13195, 2);
		map.put(class_2902.class_2903.field_13200, 3);
		map.put(class_2902.class_2903.field_13197, 4);
		map.put(class_2902.class_2903.field_13203, 5);
		return map;
	});

	private static final IntFunction<class_2902.class_2903> BY_ID = class_7995.method_47914(IDS::getInt, class_2902.class_2903.values(), class_7995.class_7996.field_41664);

	public static void write(class_2791 chunk, class_2540 buf) {
		buf.method_36130(chunk.method_12004());
		var heightmaps = chunk.method_12011()
			.stream()
			.filter(entryx -> entryx.getKey().method_16137())
			.collect(Collectors.toMap(Map.Entry::getKey, entryx -> entryx.getValue().method_12598().clone()));
		buf.method_34063(heightmaps, (buf1, types) -> buf1.method_10804(IDS.getInt(types)), class_2540::method_10789);

		buf.writeInt(chunk.method_12006().length);
		for (class_2826 section : chunk.method_12006()) {
			section.method_12257(buf);
			section.method_38294().method_12325(buf);
		}


	}

	public static class_2818 read(class_1937 level, class_2540 buf) {
		var pos = buf.method_36133();
		var heightmaps = buf.method_34067(buf1 -> BY_ID.apply(buf1.method_10816()), class_2540::method_33134);

		var chunk = new class_2818(level, pos);
		int sectionCount = buf.readInt();
		if (sectionCount != chunk.method_12006().length) {
			return chunk;
		}
		for (var section : chunk.method_12006()) {
			section.method_12258(buf);
			section.method_49526(buf);
		}
		heightmaps.forEach(chunk::method_12037);
		chunk.method_51522();
		return chunk;
	}
}
