/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient (Waypoints Mod).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.waypoints.waypoints.gui.util;

import java.util.function.Consumer;

import lombok.Getter;
import lombok.Setter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_437;
import net.minecraft.class_7842;
import net.minecraft.class_7847;
import net.minecraft.class_8021;
import net.minecraft.class_8133;

@Environment(EnvType.CLIENT)
public class HeaderAndFooterLayout implements class_8133 {
	public static final int DEFAULT_HEADER_AND_FOOTER_HEIGHT = 33;
	private static final int CONTENT_MARGIN_TOP = 30;
	private final FrameLayout headerFrame = new FrameLayout();
	private final FrameLayout footerFrame = new FrameLayout();
	private final FrameLayout contentsFrame = new FrameLayout();
	private final class_437 screen;
	@Getter
	@Setter
	private int headerHeight;
	@Getter
	@Setter
	private int footerHeight;

	public HeaderAndFooterLayout(class_437 screen) {
		this(screen, DEFAULT_HEADER_AND_FOOTER_HEIGHT);
	}

	public HeaderAndFooterLayout(class_437 screen, int height) {
		this(screen, height, height);
	}

	public HeaderAndFooterLayout(class_437 screen, int headerHeight, int footerHeight) {
		this.screen = screen;
		this.headerHeight = headerHeight;
		this.footerHeight = footerHeight;
		this.headerFrame.defaultChildLayoutSetting().method_46463(0.5F, 0.5F);
		this.footerFrame.defaultChildLayoutSetting().method_46463(0.5F, 0.5F);
	}

	@Override
	public void method_46421(int x) {
	}

	@Override
	public void method_46419(int y) {
	}

	@Override
	public int method_46426() {
		return 0;
	}

	@Override
	public int method_46427() {
		return 0;
	}

	@Override
	public int method_25368() {
		return this.screen.field_22789;
	}

	@Override
	public int method_25364() {
		return this.screen.field_22790;
	}

	public int getContentHeight() {
		return this.screen.field_22790 - this.getHeaderHeight() - this.getFooterHeight();
	}

	@Override
	public void method_48227(Consumer<class_8021> visitor) {
		this.headerFrame.method_48227(visitor);
		this.contentsFrame.method_48227(visitor);
		this.footerFrame.method_48227(visitor);
	}

	@Override
	public void method_48222() {
		int i = this.getHeaderHeight();
		int j = this.getFooterHeight();
		this.headerFrame.setMinWidth(this.screen.field_22789);
		this.headerFrame.setMinHeight(i);
		this.headerFrame.method_48229(0, 0);
		this.headerFrame.method_48222();
		this.footerFrame.setMinWidth(this.screen.field_22789);
		this.footerFrame.setMinHeight(j);
		this.footerFrame.method_48222();
		this.footerFrame.method_46419(this.screen.field_22790 - j);
		this.contentsFrame.setMinWidth(this.screen.field_22789);
		this.contentsFrame.method_48222();
		int k = i + CONTENT_MARGIN_TOP;
		int l = this.screen.field_22790 - j - this.contentsFrame.method_25364();
		this.contentsFrame.method_48229(0, Math.min(k, l));
	}

	public <T extends class_8021> T addToHeader(T child) {
		return this.headerFrame.addChild(child);
	}

	public <T extends class_8021> T addToHeader(T child, Consumer<class_7847> layoutSettingsFactory) {
		return this.headerFrame.addChild(child, layoutSettingsFactory);
	}

	public void addTitleHeader(class_2561 message, class_327 font) {
		this.headerFrame.addChild(new class_7842(message, font));
	}

	public <T extends class_8021> T addToFooter(T child) {
		return this.footerFrame.addChild(child);
	}

	public <T extends class_8021> T addToFooter(T child, Consumer<class_7847> layoutSettingsFactory) {
		return this.footerFrame.addChild(child, layoutSettingsFactory);
	}

	public <T extends class_8021> T addToContents(T child) {
		return this.contentsFrame.addChild(child);
	}

	public <T extends class_8021> T addToContents(T child, Consumer<class_7847> layoutSettingFactory) {
		return this.contentsFrame.addChild(child, layoutSettingFactory);
	}
}
