/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient (Waypoints Mod).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.waypoints.mixin;

import io.github.axolotlclient.waypoints.AxolotlClientWaypoints;
import net.minecraft.unmapped.C_0332750;
import net.minecraft.unmapped.C_5722573;
import net.minecraft.unmapped.C_9232485;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(C_5722573.class)
public class ClientPacketListenerMixin {

	@Inject(method = "handleLogin", at = @At("TAIL"))
	private void onLogin(C_9232485 loginS2CPacket, CallbackInfo ci) {
		AxolotlClientWaypoints.WAYPOINT_STORAGE.load();
	}

	@Inject(method = "handleChatMessage", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/chat/ChatGui;addMessage(Lnet/minecraft/text/Text;)V"))
	private void onChatMessage(C_0332750 chatMessageS2CPacket, CallbackInfo ci) {
		AxolotlClientWaypoints.NETWORK_LISTENER.onReceiveChatMessage(chatMessageS2CPacket.m_8344134().m_2117196());
	}
}
