/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient (Waypoints Mod).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.waypoints.waypoints.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.unmapped.C_2691939;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_4576025;
import net.minecraft.unmapped.C_8105098;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.ClickableWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.Element;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.TextFieldWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.ElementListWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.VanillaButtonWidget;
import io.github.axolotlclient.waypoints.AxolotlClientWaypoints;
import io.github.axolotlclient.waypoints.waypoints.Waypoint;

public class WaypointsScreen extends io.github.axolotlclient.AxolotlClientConfig.impl.ui.Screen {

	private final C_3020744 parent;

	public WaypointsScreen(C_3020744 screen) {
		super(AxolotlClientWaypoints.tr("manage"));
		this.parent = screen;
	}

	@Override
	public void m_3593494() {
		WaypointsList entries = new WaypointsList(f_7153641, f_3080061, f_5465691, f_3080061 - 60 - 33, 60, 25);
		addDrawableChild(entries);

		var search = addDrawableChild(new TextFieldWidget(f_2020658, f_5465691 / 2 - 100, 60 / 2 - 37 / 2 + 9 + 8, 200, 20, AxolotlClientWaypoints.tr("waypoint_search")));
		search.setHint(AxolotlClientWaypoints.tr("waypoint_search"));
		search.setChangedListener(entries::applySearch);


		addDrawableChild(new VanillaButtonWidget(f_5465691 / 2 - 150 - 2, f_3080061 - 33 / 2 - 20 / 2, 150, 20, AxolotlClientWaypoints.tr("create_waypoint"), btn -> f_7153641.m_6408915(new CreateWaypointScreen(this))));
		addDrawableChild(new VanillaButtonWidget(f_5465691 / 2 + 2, f_3080061 - 33 / 2 - 20 / 2, 150, 20, C_4576025.m_3547652("gui.done"), btn -> onClose()));

		entries.loadEntries(AxolotlClientWaypoints.getCurrentWaypoints(false));
	}

	public void onClose() {
		f_7153641.m_6408915(parent);
	}

	@Override
	public void m_7261014(int mouseX, int mouseY, float delta) {
		super.m_7261014(mouseX, mouseY, delta);
		m_2717572(f_2020658, getTitle(), f_5465691 / 2, 60 / 2 - 37 / 2, -1);
	}

	private class WaypointsList extends ElementListWidget<WaypointsList.Entry> {

		private final List<Waypoint> waypoints = new ArrayList<>();
		private String search = null;

		public WaypointsList(C_8105098 minecraft, int screenHeight, int width, int height, int y, int entryHeight) {
			super(minecraft, width, screenHeight, y, y + height, entryHeight);
		}

		public void loadEntries(List<Waypoint> waypoints) {
			this.waypoints.clear();
			this.waypoints.addAll(waypoints);
			applySearch(search);
		}

		public void applySearch(String s) {
			this.search = s;
			clearEntries();
			waypoints.stream().filter(w -> s == null || w.name().contains(s)).forEach(w -> addEntry(new io.github.axolotlclient.waypoints.waypoints.gui.WaypointsScreen.WaypointsList.Entry(w)));
		}

		@Override
		public int getRowWidth() {
			return 300;
		}

		private class Entry extends ElementListWidget.Entry<io.github.axolotlclient.waypoints.waypoints.gui.WaypointsScreen.WaypointsList.Entry> {

			private final List<ClickableWidget> children = new ArrayList<>();
			private final Waypoint waypoint;
			private final C_8105098 minecraft = C_8105098.m_0408063();

			private Entry(Waypoint waypoint) {
				this.waypoint = waypoint;
				children.add(new VanillaButtonWidget(0, 0, 50, 20, AxolotlClientWaypoints.tr("edit_waypoint"), btn ->
					minecraft.m_6408915(new EditWaypointScreen(WaypointsScreen.this, waypoint))));
				children.add(new VanillaButtonWidget(0, 0, 50, 20, AxolotlClientWaypoints.tr("remove_waypoint"), btn -> {
					removeEntry(this);
					AxolotlClientWaypoints.WAYPOINT_STORAGE.getWaypoints().remove(waypoint);
				}));
			}

			@Override
			public void render(int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
				var font = minecraft.f_0426313;
				C_3754158.m_8373640();
				int textWidth = font.m_0040387(waypoint.display());
				int displayWidth = textWidth + Waypoint.displayXOffset() * 2;
				int textHeight = font.f_6725889;
				int displayHeight = textHeight + Waypoint.displayYOffset() * 2;
				C_3754158.m_3172490(left + width / 6f, top + height / 2f, 0);
				C_3754158.m_4552250(Math.min(1, 100 / displayWidth), Math.min(1, 100 / displayWidth), 1);
				C_3754158.m_8373640();
				C_3754158.m_3172490(-displayWidth / 2f, -displayHeight / 2f, 0);
				C_2691939.m_7865719(0, 0, displayWidth, displayHeight, waypoint.color().toInt());
				C_3754158.m_2041265();
				C_3754158.m_3172490(-textWidth / 2f, -textHeight / 2f, 0);
				font.m_4683674(waypoint.display(), 0, 0, -1);
				C_3754158.m_2041265();
				C_3754158.m_8373640();
				C_3754158.m_3172490(left + width / 2f, top + height / 2f, 0);
				int nameWidth = font.m_0040387(waypoint.name());
				font.m_4683674(waypoint.name(), -nameWidth / 2, -textHeight / 2, -1);
				C_3754158.m_2041265();

				int buttonsX = left + width;
				for (int i = children.size() - 1; i >= 0; i--) {
					var w = children.get(i);
					w.setX(buttonsX - w.getWidth());
					buttonsX -= w.getWidth() + 4;
					w.setY(top + height / 2 - w.getHeight() / 2);
					w.render(mouseX, mouseY, partialTick);
				}
			}

			@Override
			public List<? extends Element> children() {
				return children;
			}
		}
	}
}
