/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient (Waypoints Mod).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.waypoints.waypoints.gui.util;

import io.github.axolotlclient.AxolotlClientConfig.impl.ui.ClickableWidget;
import lombok.Getter;
import net.minecraft.unmapped.C_3831727;

public class StringWidget extends ClickableWidget {
	private final C_3831727 font;

	public StringWidget(int width, int height, String message, C_3831727 font) {
		this(0, 0, width, height, message, font, 0.5f);
	}

	@Getter
	private float alignX;
	@Getter
	private int color = -1;

	public StringWidget(String message, C_3831727 font) {
		this(0, 0, font.m_0040387(message), 9, message, font, 0.5f);
	}

	public StringWidget(int x, int y, int width, int height, String message, C_3831727 font, float alignX) {
		super(x, y, width, height, message);
		this.font = font;
		this.alignX = alignX;
		active = false;
	}

	public StringWidget setColor(int color) {
		this.color = color;
		return this;
	}

	private StringWidget horizontalAlignment(float horizontalAlignment) {
		this.alignX = horizontalAlignment;
		return this;
	}

	public StringWidget alignLeft() {
		return this.horizontalAlignment(0.0F);
	}

	public StringWidget alignCenter() {
		return this.horizontalAlignment(0.5F);
	}

	public StringWidget alignRight() {
		return this.horizontalAlignment(1.0F);
	}

	@Override
	public void render(int mouseX, int mouseY, float partialTick) {
		String component = getMessage();
		int i = this.getX() + Math.round(this.alignX * (this.getWidth() - font.m_0040387(component)));
		int j = this.getY() + (this.getHeight() - 9) / 2;
		font.m_4683674(component, i, j, getColor());
	}

	@Override
	public SelectionType getType() {
		return SelectionType.NONE;
	}

	@Override
	public boolean isFocused() {
		return false;
	}

	@Override
	public void setFocused(boolean b) {

	}
}
