/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient (Waypoints Mod).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.waypoints.map.widgets;

import io.github.axolotlclient.waypoints.AxolotlClientWaypoints;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4185;

public class DropdownButton extends class_4185 {
	private static final class_2960 ARROW_UP = AxolotlClientWaypoints.rl("dropdown/up"),
		ARROW_UP_HIGHLIGHTED = AxolotlClientWaypoints.rl("dropdown/up_highlighted"),
		ARROW_DOWN = AxolotlClientWaypoints.rl("dropdown/down"),
		ARROW_DOWN_HIGHLIGHTED = AxolotlClientWaypoints.rl("dropdown/down_highlighted");

	private boolean state;

	public DropdownButton(int x, int y, int width, int height, class_2561 message, PressConsumer onPress) {
		super(x, y, width, height, message, btn -> {
			var dropdown = (DropdownButton) btn;
			dropdown.state = !dropdown.state;
			onPress.pressed(btn, dropdown.state);
		}, field_40754);
	}

	@Override
	protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		if (state) {
			guiGraphics.method_52706(method_49606() ? ARROW_UP_HIGHLIGHTED : ARROW_UP, method_46426(), method_46427(), method_25368(), method_25364());
		} else {
			guiGraphics.method_52706(method_49606() ? ARROW_DOWN_HIGHLIGHTED : ARROW_DOWN, method_46426(), method_46427(), method_25368(), method_25364());
		}
	}

	public interface PressConsumer {
		void pressed(class_4185 button, boolean state);
	}
}
