/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.waypoints;

import io.github.axolotlclient.AxolotlClientConfig.api.AxolotlClientConfig;
import io.github.axolotlclient.AxolotlClientConfig.api.manager.ConfigManager;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.api.options.OptionCategory;
import io.github.axolotlclient.AxolotlClientConfig.impl.managers.VersionedJsonConfigManager;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.FloatOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.util.ConfigStyles;
import io.github.axolotlclient.waypoints.AxolotlClientWaypointsCommon;
import io.github.axolotlclient.waypoints.BooleanOption;
import io.github.axolotlclient.waypoints.map.Minimap;
import io.github.axolotlclient.waypoints.map.WorldMapScreen;
import io.github.axolotlclient.waypoints.mixin.MinecraftServerAccessor;
import io.github.axolotlclient.waypoints.network.Listener;
import io.github.axolotlclient.waypoints.waypoints.Waypoint;
import io.github.axolotlclient.waypoints.waypoints.WaypointRenderer;
import io.github.axolotlclient.waypoints.waypoints.WaypointStorage;
import io.github.axolotlclient.waypoints.waypoints.gui.CreateWaypointScreen;
import io.github.axolotlclient.waypoints.waypoints.gui.WaypointsScreen;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import org.joml.Vector3f;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AxolotlClientWaypoints
implements ClientModInitializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AxolotlClientWaypoints.class);
    public static final Minimap MINIMAP = new Minimap();
    public static final WaypointStorage WAYPOINT_STORAGE = new WaypointStorage();
    public static final WaypointRenderer WAYPOINT_RENDERER = new WaypointRenderer();
    public static final Listener NETWORK_LISTENER = new Listener();
    private final OptionCategory waypoints = OptionCategory.create((String)"waypoints");
    public static BooleanOption renderWaypoints = new BooleanOption("render_waypoints", Boolean.valueOf(true));
    public static BooleanOption renderWaypointsInWorld = new BooleanOption("render_waypoints_in_world", Boolean.valueOf(true));
    public static BooleanOption renderOutOfViewWaypointsOnScreenEdge = new BooleanOption("render_out_of_view_waypoints", Boolean.valueOf(true));
    public static FloatOption waypointTitleScale = new FloatOption("waypoint_title_scale", Float.valueOf(1.0f), Float.valueOf(0.1f), Float.valueOf(2.0f));
    private final String category = "key.category.axolotlclient_waypoints.axolotlclient_waypoints";
    private final class_304 map = new class_304("axolotlclient_waypoints.world_map", 77, "key.category.axolotlclient_waypoints.axolotlclient_waypoints");
    private final class_304 manageWaypoints = new class_304("axolotlclient_waypoints.waypoints_menu", 75, "key.category.axolotlclient_waypoints.axolotlclient_waypoints");
    private final class_304 newWaypoint = new class_304("axolotlclient_waypoints.create_waypoint", 78, "key.category.axolotlclient_waypoints.axolotlclient_waypoints");
    private final class_304 toggleWaypointRendering = new class_304("axolotlclient_waypoints.toggle_waypoint_rendering", class_3675.field_16237.method_1444(), "key.category.axolotlclient_waypoints.axolotlclient_waypoints");

    public void onInitializeClient() {
        AxolotlClientWaypointsCommon.init();
        MINIMAP.init();
        AxolotlClientWaypointsCommon.category.add(new OptionCategory[]{this.waypoints});
        this.waypoints.add(new Option[]{renderWaypoints, renderWaypointsInWorld, renderOutOfViewWaypointsOnScreenEdge, waypointTitleScale});
        try {
            Files.createDirectories(FabricLoader.getInstance().getConfigDir().resolve("axolotlclient_waypoints"), new FileAttribute[0]);
        }
        catch (IOException e) {
            log.warn("Failed to create config dir, options may not save correctly!", (Throwable)e);
        }
        VersionedJsonConfigManager configManager = new VersionedJsonConfigManager(AxolotlClientWaypointsCommon.OPTIONS_PATH, AxolotlClientWaypointsCommon.category, 1, (oldVersion, newVersion, rootCategory, json) -> json);
        AxolotlClientConfig.getInstance().register((ConfigManager)configManager);
        configManager.load();
        configManager.save();
        KeyBindingHelper.registerKeyBinding((class_304)this.map);
        KeyBindingHelper.registerKeyBinding((class_304)this.manageWaypoints);
        KeyBindingHelper.registerKeyBinding((class_304)this.newWaypoint);
        KeyBindingHelper.registerKeyBinding((class_304)this.toggleWaypointRendering);
        ClientTickEvents.END_CLIENT_TICK.register(arg_0 -> this.lambda$onInitializeClient$1((ConfigManager)configManager, arg_0));
        NETWORK_LISTENER.init();
    }

    public static class_437 createOptionsScreen(class_437 parent) {
        return ConfigStyles.createScreen((class_437)parent, (OptionCategory)AxolotlClientWaypointsCommon.category);
    }

    public static class_2960 rl(String path) {
        return class_2960.method_60655((String)"axolotlclient_waypoints", (String)path);
    }

    public static class_2561 tr(String key, Object ... args) {
        return class_2561.method_43469((String)("axolotlclient_waypoints." + key), (Object[])args);
    }

    public static String tra(String key) {
        return class_1074.method_4662((String)("axolotlclient_waypoints." + key), (Object[])new Object[0]);
    }

    public static List<Waypoint> getCurrentWaypoints() {
        return AxolotlClientWaypoints.getCurrentWaypoints(true);
    }

    public static List<Waypoint> getCurrentWaypoints(boolean dimension) {
        class_310 mc = class_310.method_1551();
        Vector3f pos = mc.field_1724.method_19538().method_46409();
        return WAYPOINT_STORAGE.getCurrentlyAvailableWaypoints(dimension ? mc.field_1687.method_27983().method_29177().toString() : null).sorted(Comparator.comparingDouble(w -> w.squaredDistTo(pos))).toList();
    }

    private static String getB64(String s) {
        return new String(Base64.getUrlEncoder().encode(s.getBytes(StandardCharsets.UTF_8)));
    }

    public static Path getCurrentStorageDir() {
        class_310 mc = class_310.method_1551();
        return AxolotlClientWaypoints.getCurrentWorldStorageDir().resolve(AxolotlClientWaypoints.getB64(mc.field_1687.method_27983().method_29177().toString()));
    }

    public static Path getCurrentWorldStorageDir() {
        class_310 mc = class_310.method_1551();
        String str = mc.method_1576() == null ? mc.method_1558().field_3761 : ((MinecraftServerAccessor)mc.method_1576()).getStorageSource().method_27005();
        return AxolotlClientWaypointsCommon.MOD_STORAGE_DIR.resolve(AxolotlClientWaypoints.getB64(str));
    }

    public static boolean playerHasOp() {
        return class_310.method_1551().field_1724.method_5687(4);
    }

    private /* synthetic */ void lambda$onInitializeClient$1(ConfigManager configManager, class_310 mc) {
        if (this.map.method_1436()) {
            mc.method_1507((class_437)new WorldMapScreen());
        } else if (this.manageWaypoints.method_1436()) {
            mc.method_1507((class_437)new WaypointsScreen(mc.field_1755));
        } else if (this.newWaypoint.method_1436()) {
            mc.method_1507((class_437)new CreateWaypointScreen(mc.field_1755));
        }
        if (this.toggleWaypointRendering.method_1436()) {
            renderWaypointsInWorld.toggle();
            configManager.save();
        }
    }
}

