/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.waypoints.map;

import io.github.axolotlclient.AxolotlClientConfig.api.options.OptionCategory;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.waypoints.AxolotlClientWaypoints;
import io.github.axolotlclient.waypoints.AxolotlClientWaypointsCommon;
import io.github.axolotlclient.waypoints.HudCreator;
import io.github.axolotlclient.waypoints.map.MinimapCommon;
import io.github.axolotlclient.waypoints.util.ARGB;
import io.github.axolotlclient.waypoints.waypoints.Waypoint;
import java.util.Objects;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1163;
import net.minecraft.class_1291;
import net.minecraft.class_156;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3620;
import net.minecraft.class_4076;
import net.minecraft.class_437;
import net.minecraft.class_485;
import net.minecraft.class_638;
import net.minecraft.class_9779;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Minimap
extends MinimapCommon {
    private static final class_2960 texLocation = AxolotlClientWaypoints.rl("minimap");
    public static final class_2960 arrowLocation = AxolotlClientWaypoints.rl("arrow");
    private final class_1011 pixels = new class_1011(128, 128, false);
    public long updateDuration = -1L;
    private class_1043 tex;
    private int mapCenterX;
    private int mapCenterZ;
    private boolean usingHud;
    public boolean allowCaves = true;
    private final class_310 minecraft = class_310.method_1551();

    public void init() {
        super.init();
        AxolotlClientWaypointsCommon.category.add(new OptionCategory[]{minimap});
        if (AxolotlClientWaypointsCommon.AXOLOTLCLIENT_PRESENT) {
            this.usingHud = true;
            HudCreator.createHud((MinimapCommon)this);
        }
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public void setup() {
        this.tex = new class_1043(this.pixels);
        this.minecraft.method_1531().method_4616(texLocation, (class_1044)this.tex);
        this.pixels.method_4326(0, 0, this.pixels.method_4307(), this.pixels.method_4323(), ARGB.opaque((int)0));
    }

    public void renderMapOverlay(class_332 guiGraphics, class_9779 deltaTracker) {
        class_485 effectRenderingInventoryScreen;
        class_437 class_4372;
        if (this.usingHud) {
            return;
        }
        this.x = this.minecraft.method_22683().method_4486() - 128 - 10;
        this.y = 10;
        if (this.minecraft.method_1530()) {
            this.y += 15;
        }
        if (!(this.minecraft.field_1724.method_6026().isEmpty() || this.minecraft.field_1755 != null && (class_4372 = this.minecraft.field_1755) instanceof class_485 && (effectRenderingInventoryScreen = (class_485)class_4372).method_38934())) {
            if (this.minecraft.field_1724.method_6026().stream().anyMatch(e -> !((class_1291)e.method_5579().comp_349()).method_5573())) {
                this.y += 26;
            }
            this.y += 20;
        }
        this.renderMap(guiGraphics);
    }

    public void renderMap(AxoRenderContext ctx) {
        this.renderMap((class_332)ctx);
    }

    public void renderMap(class_332 guiGraphics) {
        if (!this.isEnabled()) {
            return;
        }
        guiGraphics.method_51448().method_22903();
        Vector3f vec1 = guiGraphics.method_51448().method_23760().method_23761().transformPosition((float)this.x, (float)this.y, 0.0f, new Vector3f());
        Vector3f vec2 = guiGraphics.method_51448().method_23760().method_23761().transformPosition((float)(this.x + 128), (float)(this.y + 128), 0.0f, new Vector3f());
        guiGraphics.method_44379(class_3532.method_15375((float)vec1.x), class_3532.method_15375((float)vec1.y), class_3532.method_15375((float)vec2.x), class_3532.method_15375((float)vec2.y));
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)this.x, (float)this.y, 0.0f);
        guiGraphics.method_51448().method_46416(64.0f, 64.0f, 0.0f);
        if (!this.lockMapToNorth.get().booleanValue()) {
            guiGraphics.method_51448().method_23760().method_23761().rotate((float)(-((double)((this.minecraft.field_1724.method_43078() + 180.0f) / 180.0f) * Math.PI)), 0.0f, 0.0f, 1.0f);
        }
        guiGraphics.method_51448().method_22905((float)Math.sqrt(2.0), (float)Math.sqrt(2.0), 1.0f);
        guiGraphics.method_51448().method_22905((float)((Integer)this.mapScale.get()).intValue(), (float)((Integer)this.mapScale.get()).intValue(), 1.0f);
        guiGraphics.method_51448().method_46416(-64.0f, -64.0f, 0.0f);
        float offX = -((float)(this.minecraft.field_1724.method_23317() - (double)this.mapCenterX));
        float offZ = -((float)(this.minecraft.field_1724.method_23321() - (double)this.mapCenterZ));
        guiGraphics.method_51448().method_46416(offX, offZ, 0.0f);
        guiGraphics.method_25290(texLocation, 0, 0, 0.0f, 0.0f, this.pixels.method_4307(), this.pixels.method_4323(), this.pixels.method_4307(), this.pixels.method_4323());
        guiGraphics.method_51448().method_22909();
        guiGraphics.method_44380();
        if (this.minimapOutline.get().booleanValue() && !this.usingHud) {
            guiGraphics.method_49601(this.x, this.y, 128, 128, this.outlineColor.get().toInt());
        }
        if (this.showWaypoints.get().booleanValue()) {
            this.renderMapWaypoints(guiGraphics);
        }
        if (this.showCardinalDirections.get().booleanValue()) {
            Vector3f pos = new Vector3f();
            guiGraphics.method_51448().method_22903();
            String[] directions = new String[]{"N", "W", "E", "S"};
            for (int i : new int[]{-2, 1, 2, -1}) {
                String label = directions[i < 0 ? i + 2 : i + 1];
                int labelWidth = this.minecraft.field_1772.method_1727(label);
                Objects.requireNonNull(this.minecraft.field_1772);
                int labelHeight = 9;
                guiGraphics.method_51448().method_22903();
                guiGraphics.method_51448().method_34426();
                guiGraphics.method_51448().method_46416((float)(this.x + 64), (float)(this.y + 64), 0.0f);
                if (!this.lockMapToNorth.get().booleanValue()) {
                    guiGraphics.method_51448().method_23760().method_23761().rotate((float)(-((double)((this.minecraft.field_1724.method_43078() + 180.0f) / 180.0f) * Math.PI)), 0.0f, 0.0f, 1.0f);
                }
                guiGraphics.method_51448().method_46416((float)(i % 2 * 128), (float)((int)((float)i / 2.0f) * 128), 0.0f);
                pos.zero();
                guiGraphics.method_51448().method_23760().method_23761().transformPosition(pos);
                guiGraphics.method_51448().method_22909();
                pos.x = Math.clamp(pos.x, (float)this.x, (float)(this.x + 128));
                pos.y = Math.clamp(pos.y, (float)this.y, (float)(this.y + 128));
                guiGraphics.method_51448().method_22903();
                guiGraphics.method_51448().method_23760().method_23761().translate((Vector3fc)pos);
                guiGraphics.method_51448().method_22905(0.5f, 0.5f, 1.0f);
                guiGraphics.method_25294(-(labelWidth / 2 + 2), -(labelHeight / 2 + 2), labelWidth / 2 + 2, labelHeight / 2 + 2, 0x77888888);
                guiGraphics.method_25303(this.minecraft.field_1772, label, -labelWidth / 2, -labelHeight / 2, -1);
                guiGraphics.method_51448().method_22909();
            }
            guiGraphics.method_51448().method_22909();
        }
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)(this.x + 64), (float)(this.y + 64), 0.0f);
        if (this.lockMapToNorth.get().booleanValue()) {
            guiGraphics.method_51448().method_23760().method_23761().rotate((float)((double)((this.minecraft.field_1724.method_43078() + 180.0f) / 180.0f) * Math.PI), 0.0f, 0.0f, 1.0f);
        }
        guiGraphics.method_51448().method_22905(0.5f * (float)((Integer)this.arrowScale.get()).intValue(), 0.5f * (float)((Integer)this.arrowScale.get()).intValue(), 1.0f);
        int arrowSize = 15;
        guiGraphics.method_51448().method_46416((float)(-arrowSize) / 2.0f, (float)(-arrowSize) / 2.0f, 1.0f);
        guiGraphics.method_52706(arrowLocation, 0, 0, arrowSize, arrowSize);
        guiGraphics.method_51448().method_22909();
        guiGraphics.method_51448().method_22909();
    }

    private void renderMapWaypoints(class_332 graphics) {
        if (!AxolotlClientWaypoints.renderWaypoints.get().booleanValue()) {
            return;
        }
        graphics.method_51448().method_22903();
        Vector3f pos = new Vector3f();
        for (Waypoint waypoint : AxolotlClientWaypoints.getCurrentWaypoints()) {
            graphics.method_51448().method_22903();
            float posX = (float)(waypoint.x() - this.minecraft.field_1724.method_23317());
            float posY = (float)(waypoint.z() - this.minecraft.field_1724.method_23321());
            pos.zero();
            graphics.method_51448().method_22903();
            graphics.method_51448().method_34426();
            graphics.method_51448().method_46416((float)this.x, (float)this.y, 0.0f);
            graphics.method_51448().method_46416(64.0f, 64.0f, 0.0f);
            graphics.method_51448().method_22905((float)Math.sqrt(2.0), (float)Math.sqrt(2.0), 1.0f);
            graphics.method_51448().method_22905((float)((Integer)this.mapScale.get()).intValue(), (float)((Integer)this.mapScale.get()).intValue(), 1.0f);
            if (!this.lockMapToNorth.get().booleanValue()) {
                graphics.method_51448().method_23760().method_23761().rotate((float)(-Math.toRadians(this.minecraft.field_1724.method_43078() + 180.0f)), 0.0f, 0.0f, 1.0f);
            }
            graphics.method_51448().method_46416(posX, posY, 1.0f);
            graphics.method_51448().method_23760().method_23761().transformPosition(pos);
            graphics.method_51448().method_22909();
            pos.x = class_3532.method_15363((float)pos.x, (float)this.x, (float)(this.x + 128));
            pos.y = class_3532.method_15363((float)pos.y, (float)this.y, (float)(this.y + 128));
            graphics.method_51448().method_23760().method_23761().translate((Vector3fc)pos);
            int textWidth = this.minecraft.field_1772.method_1727(waypoint.display());
            Objects.requireNonNull(this.minecraft.field_1772);
            int textHeight = 9;
            graphics.method_25294(-(textWidth / 2) - Waypoint.displayXOffset(), -(textHeight / 2) - Waypoint.displayYOffset(), textWidth / 2 + Waypoint.displayXOffset(), textHeight / 2 + Waypoint.displayYOffset(), waypoint.color().toInt());
            graphics.method_51433(this.minecraft.field_1772, waypoint.display(), -(textWidth / 2), -textHeight / 2, -1, false);
            graphics.method_51448().method_22909();
        }
        graphics.method_51448().method_22909();
    }

    public void updateMapView() {
        if (!this.isEnabled()) {
            this.updateDuration = -1L;
            return;
        }
        long start = class_156.method_648();
        int centerX = this.minecraft.field_1724.method_31477();
        int centerZ = this.minecraft.field_1724.method_31479();
        this.mapCenterX = centerX;
        this.mapCenterZ = centerZ;
        int size = this.pixels.method_4307();
        int texHalfWidth = size / 2;
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        class_2338.class_2339 mutableBlockPos2 = new class_2338.class_2339();
        class_638 level = this.minecraft.field_1687;
        class_2818 centerChunk = level.method_8497(class_4076.method_18675((int)centerX), class_4076.method_18675((int)centerZ));
        int surface = centerChunk.method_12005(class_2902.class_2903.field_13202, centerX, centerZ);
        mutableBlockPos.method_10103(centerX, surface, centerZ);
        int solidBlocksAbovePlayer = 0;
        boolean atSurface = false;
        if (level.method_8597().comp_643()) {
            atSurface = this.minecraft.field_1724.method_31478() >= level.method_8597().comp_653();
        } else if (surface + 1 <= this.minecraft.field_1724.method_31478()) {
            atSurface = true;
        } else {
            while (solidBlocksAbovePlayer <= 3 && surface > this.minecraft.field_1724.method_31478() && surface > level.method_31607()) {
                class_2680 state = centerChunk.method_8320((class_2338)mutableBlockPos);
                mutableBlockPos.method_33098(surface--);
                if (state.method_26167((class_1922)level, mutableBlockPos.method_10074()) || !state.method_26225() || !state.method_26230((class_1922)level, (class_2338)mutableBlockPos)) continue;
                ++solidBlocksAbovePlayer;
            }
            if (solidBlocksAbovePlayer <= 2) {
                atSurface = true;
            }
        }
        boolean updated = false;
        for (int x = 0; x < size; ++x) {
            double d = 0.0;
            for (int z = -1; z < size; ++z) {
                int chunkX = centerX + x - texHalfWidth;
                int chunkZ = centerZ + z - texHalfWidth;
                class_2791 levelChunk = level.method_8402(class_4076.method_18675((int)chunkX), class_4076.method_18675((int)chunkZ), class_2806.field_12803, false);
                if (levelChunk != null) {
                    int color;
                    class_2680 blockState;
                    int fluidDepth = 0;
                    double e = 0.0;
                    mutableBlockPos.method_10103(chunkX, 0, chunkZ);
                    int y = levelChunk.method_12005(class_2902.class_2903.field_13202, mutableBlockPos.method_10263(), mutableBlockPos.method_10260()) + 1;
                    if (!atSurface) {
                        y = Math.min(y, this.minecraft.field_1724.method_31478());
                    }
                    if (y <= level.method_31607()) {
                        blockState = class_2246.field_10124.method_9564();
                    } else {
                        do {
                            mutableBlockPos.method_33098(--y);
                        } while ((blockState = levelChunk.method_8320((class_2338)mutableBlockPos)).method_26205((class_1922)level, (class_2338)mutableBlockPos) == class_3620.field_16008 && y > level.method_31607());
                        if (y > level.method_31607() && !blockState.method_26227().method_15769()) {
                            class_2680 blockState2;
                            int highestFullBlockY = y - 1;
                            mutableBlockPos2.method_10101((class_2382)mutableBlockPos);
                            do {
                                mutableBlockPos2.method_33098(highestFullBlockY--);
                                blockState2 = levelChunk.method_8320((class_2338)mutableBlockPos2);
                                ++fluidDepth;
                            } while (highestFullBlockY > level.method_31607() && !blockState2.method_26227().method_15769());
                            class_3610 fluidState = blockState.method_26227();
                            blockState = !fluidState.method_15769() && !blockState.method_26206((class_1922)level, (class_2338)mutableBlockPos, class_2350.field_11036) ? fluidState.method_15759() : blockState;
                        }
                    }
                    e += (double)y;
                    class_3620 mapColor = blockState.method_26205((class_1922)level, (class_2338)mutableBlockPos);
                    if (mapColor == class_3620.field_16019) {
                        class_2680 floorBlock = levelChunk.method_8320((class_2338)mutableBlockPos2);
                        int floorColor = floorBlock.method_26205((class_1922)level, (class_2338)mutableBlockPos2).field_16011;
                        int biomeColor = this.enableBiomeBlending.get() != false ? class_1163.method_4961((class_1920)level, (class_2338)mutableBlockPos) : mapColor.field_16011;
                        float shade = level.method_24852(class_2350.field_11036, true);
                        int waterColor = ARGB.fromABGR((int)biomeColor);
                        waterColor = ARGB.colorFromFloat((float)1.0f, (float)(ARGB.redFloat((int)waterColor) * shade), (float)(ARGB.greenFloat((int)waterColor) * shade), (float)(ARGB.blueFloat((int)waterColor) * shade));
                        color = waterColor = ARGB.average((int)waterColor, (int)ARGB.scaleRGB((int)floorColor, (float)(1.0f - (float)fluidDepth / 15.0f)));
                    } else {
                        double f = (e - d) * 4.0 / 5.0 + ((double)(x + z & 1) - 0.5) * 0.4;
                        class_3620.class_6594 brightness = f > 0.6 ? class_3620.class_6594.field_34761 : (f < -0.6 ? class_3620.class_6594.field_34759 : class_3620.class_6594.field_34760);
                        color = mapColor.method_15820(brightness);
                    }
                    d = e;
                    if (z < 0 || Integer.rotateRight(this.pixels.method_4315(x, z), 4) == color) continue;
                    this.pixels.method_4305(x, z, ARGB.opaque((int)color));
                    updated = true;
                    continue;
                }
                if (z < 0 || Integer.rotateRight(this.pixels.method_4315(x, z), 4) == 0) continue;
                this.pixels.method_4305(x, z, ARGB.opaque((int)0));
                updated = true;
            }
        }
        if (updated) {
            this.tex.method_4524();
        }
        this.updateDuration = class_156.method_648() - start;
    }
}

