/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.waypoints.map.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2902;
import net.minecraft.class_7995;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class LevelChunkStorage {
    private static final Object2IntMap<class_2902.class_2903> IDS = (Object2IntMap)class_156.method_656(() -> {
        Object2IntArrayMap map = new Object2IntArrayMap(5);
        map.put((Object)class_2902.class_2903.field_13194, 0);
        map.put((Object)class_2902.class_2903.field_13202, 1);
        map.put((Object)class_2902.class_2903.field_13195, 2);
        map.put((Object)class_2902.class_2903.field_13200, 3);
        map.put((Object)class_2902.class_2903.field_13197, 4);
        map.put((Object)class_2902.class_2903.field_13203, 5);
        return map;
    });
    private static final IntFunction<class_2902.class_2903> BY_ID = class_7995.method_47914(arg_0 -> IDS.getInt(arg_0), (Object[])class_2902.class_2903.values(), (class_7995.class_7996)class_7995.class_7996.field_41664);
    public static final class_9139<ByteBuf, class_2902.class_2903> STREAM_CODEC = class_9135.method_56375(BY_ID, arg_0 -> IDS.getInt(arg_0));

    public static void writeEntries(List<Entry> entries, class_2540 buf) {
        buf.method_34062(entries, (b, e) -> e.write((class_2540)b));
    }

    public static List<Entry> readEntries(class_1937 level, class_2540 buf) {
        return buf.method_34066(e -> Entry.read(level, e));
    }

    public static class_2540 buffer() {
        return new class_2540(Unpooled.buffer());
    }

    public static void write(class_2791 chunk, class_2540 buf) {
        buf.method_36130(chunk.method_12004());
        Map<class_2902.class_2903, long[]> heightmaps = chunk.method_12011().stream().filter(entryx -> ((class_2902.class_2903)entryx.getKey()).method_16137()).collect(Collectors.toMap(Map.Entry::getKey, entryx -> (long[])((class_2902)entryx.getValue()).method_12598().clone()));
        buf.method_34063(heightmaps, STREAM_CODEC, class_2540::method_10789);
        buf.method_53002(chunk.method_12006().length);
        for (class_2826 section : chunk.method_12006()) {
            section.method_12257(buf);
            section.method_38294().method_12325(buf);
        }
    }

    public static class_2818 read(class_1937 level, class_2540 buf) {
        class_1923 pos = buf.method_36133();
        Map heightmaps = buf.method_34067(STREAM_CODEC, class_2540::method_33134);
        class_2818 chunk = new class_2818(level, pos);
        int sectionCount = buf.readInt();
        if (sectionCount != chunk.method_12006().length) {
            return chunk;
        }
        for (class_2826 section : chunk.method_12006()) {
            section.method_12258(buf);
            section.method_49526(buf);
        }
        heightmaps.forEach((arg_0, arg_1) -> ((class_2818)chunk).method_12037(arg_0, arg_1));
        chunk.method_51522();
        return chunk;
    }

    public record Entry(class_2791 chunk) {
        public void write(class_2540 buf) {
            LevelChunkStorage.write(this.chunk, buf);
        }

        public static Entry read(class_1937 level, class_2540 buf) {
            return new Entry((class_2791)LevelChunkStorage.read(level, buf));
        }

        public void write(Path path) throws IOException {
            class_2540 buf = LevelChunkStorage.buffer();
            this.write(buf);
            Files.copy((InputStream)new ByteBufInputStream((ByteBuf)buf), path, StandardCopyOption.REPLACE_EXISTING);
        }

        public static Entry read(Path path, class_1937 level) throws IOException {
            return Entry.read(level, new class_2540(Unpooled.wrappedBuffer((byte[])Files.readAllBytes(path))));
        }
    }
}

