/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.waypoints.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.axolotlclient.waypoints.AxolotlClientWaypointsCommon;
import io.github.axolotlclient.waypoints.network.Payload;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import lombok.Generated;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_8710;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AxolotlClientWaypointsServer
implements DedicatedServerModInitializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AxolotlClientWaypointsServer.class);
    private static final Path OPTIONS_PATH = AxolotlClientWaypointsCommon.OPTIONS_PATH.resolveSibling("server_options.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private Payload options;
    private static final int PERMISSION_LEVEL = 3;

    public void onInitializeServer() {
        this.load();
        PayloadTypeRegistry.configurationS2C().register(Payload.TYPE, Payload.CODEC);
        PayloadTypeRegistry.playS2C().register(Payload.TYPE, Payload.CODEC);
        CommandRegistrationCallback.EVENT.register((commandDispatcher, commandBuildContext, commandSelection) -> {
            LiteralArgumentBuilder modifyConfig = (LiteralArgumentBuilder)class_2170.method_9247((String)"modify_config").requires(c -> c.method_9259(3));
            for (Method m : Payload.class.getMethods()) {
                if (m.getParameterCount() != 1 || m.getParameterTypes()[0] != Boolean.TYPE || Modifier.isStatic(m.getModifiers())) continue;
                for (Field f : Payload.class.getDeclaredFields()) {
                    if (!m.getName().contains(Character.toUpperCase(f.getName().charAt(0)) + f.getName().substring(1))) continue;
                    modifyConfig.then(class_2170.method_9247((String)f.getName()).then(class_2170.method_9244((String)f.getName(), (ArgumentType)BoolArgumentType.bool()).executes(c -> {
                        if (this.options == null) {
                            this.options = new Payload();
                        }
                        try {
                            this.options = (Payload)m.invoke((Object)this.options, BoolArgumentType.getBool((CommandContext)c, (String)f.getName()));
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                        this.save();
                        this.reconfigure((CommandContext<class_2168>)c);
                        return 0;
                    })));
                }
            }
            commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"axolotlclient_waypoints").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(c -> c.method_9259(3))).executes(c -> {
                this.load();
                ((class_2168)c.getSource()).method_9226(() -> AxolotlClientWaypointsServer.tr("reload_complete", new Object[0]), true);
                this.reconfigure((CommandContext<class_2168>)c);
                return 0;
            }))).then(class_2170.method_9247((String)"show_config").executes(c -> {
                if (this.options != null) {
                    ((class_2168)c.getSource()).method_9226(() -> AxolotlClientWaypointsServer.tr("current_config", GSON.toJson((Object)this.options)), true);
                } else {
                    ((class_2168)c.getSource()).method_9213(AxolotlClientWaypointsServer.tr("current_config_unavailable", new Object[0]));
                }
                return 0;
            }))).then((ArgumentBuilder)modifyConfig));
        });
        if (this.options == null) {
            log.warn("Not sending options because we failed to read or instantiate them");
        }
        ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> {
            if (this.options != null) {
                handler.method_14364((class_2596)new class_2658((class_8710)this.options));
            }
        });
    }

    private void reconfigure(CommandContext<class_2168> c) {
        ((class_2168)c.getSource()).method_9211().method_3760().method_14571().forEach(p -> p.field_13987.method_14364((class_2596)new class_2658((class_8710)this.options)));
    }

    private void load() {
        try {
            this.readOrGenerateConfig();
        }
        catch (IOException e) {
            log.warn("Failed to read config! Will not register or send packet to clients!", (Throwable)e);
        }
    }

    private void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(OPTIONS_PATH, new OpenOption[0]);){
            GSON.toJson((Object)this.options, (Appendable)writer);
        }
        catch (IOException e) {
            log.warn("Failed to save config!", (Throwable)e);
        }
    }

    private void readOrGenerateConfig() throws IOException {
        Path path = OPTIONS_PATH;
        if (Files.exists(path, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(path);){
                this.options = (Payload)GSON.fromJson((Reader)reader, Payload.class);
            }
        } else {
            this.options = new Payload();
            this.save();
        }
    }

    private static class_2561 tr(String key, Object ... args) {
        return class_2561.method_43469((String)("axolotlclient_waypoints." + key), (Object[])args);
    }
}

