/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient (Waypoints Mod).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.waypoints.waypoints.gui.util;

import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_7845;
import net.minecraft.class_7847;
import net.minecraft.class_8021;
import net.minecraft.class_8133;

@Environment(EnvType.CLIENT)
public class LinearLayout implements class_8133 {
	private final class_7845 wrapped;
	private final LinearLayout.Orientation orientation;
	private int nextChildIndex = 0;

	private LinearLayout(LinearLayout.Orientation orientation) {
		this(0, 0, orientation);
	}

	public LinearLayout(int width, int height, LinearLayout.Orientation orientation) {
		this.wrapped = new class_7845(width, height);
		this.orientation = orientation;
	}

	public LinearLayout spacing(int spacing) {
		this.orientation.setSpacing(this.wrapped, spacing);
		return this;
	}

	public class_7847 newCellSettings() {
		return this.wrapped.method_46457();
	}

	public class_7847 defaultCellSetting() {
		return this.wrapped.method_46458();
	}

	public <T extends class_8021> T addChild(T child, class_7847 layoutSettings) {
		return this.orientation.addChild(this.wrapped, child, this.nextChildIndex++, layoutSettings);
	}

	public <T extends class_8021> T addChild(T child) {
		return this.addChild(child, this.newCellSettings());
	}

	public <T extends class_8021> T addChild(T child, Consumer<class_7847> layoutSettingsFactory) {
		return this.orientation.addChild(this.wrapped, child, this.nextChildIndex++, class_156.method_654(this.newCellSettings(), layoutSettingsFactory));
	}

	@Override
	public void method_48227(Consumer<class_8021> visitor) {
		this.wrapped.method_48227(visitor);
	}

	@Override
	public void method_48222() {
		this.wrapped.method_48222();
	}

	@Override
	public int method_25368() {
		return this.wrapped.method_25368();
	}

	@Override
	public int method_25364() {
		return this.wrapped.method_25364();
	}

	@Override
	public void method_46421(int x) {
		this.wrapped.method_46421(x);
	}

	@Override
	public void method_46419(int y) {
		this.wrapped.method_46419(y);
	}

	@Override
	public int method_46426() {
		return this.wrapped.method_46426();
	}

	@Override
	public int method_46427() {
		return this.wrapped.method_46427();
	}

	public static LinearLayout vertical() {
		return new LinearLayout(LinearLayout.Orientation.VERTICAL);
	}

	public static LinearLayout horizontal() {
		return new LinearLayout(LinearLayout.Orientation.HORIZONTAL);
	}

	public boolean rectContainsPoint(int x, int y) {
		var rect = method_48202();
		return x >= rect.method_49620() && x < rect.method_49621() && y >= rect.method_49618() && y < rect.method_49619();
	}

	@Environment(EnvType.CLIENT)
	public enum Orientation {
		HORIZONTAL,
		VERTICAL;

		void setSpacing(class_7845 layout, int spacing) {
			switch (this) {
				case HORIZONTAL:
					layout.method_48635(spacing);
					break;
				case VERTICAL:
					layout.method_48636(spacing);
			}
		}

		public <T extends class_8021> T addChild(class_7845 layout, T element, int index, class_7847 layoutSettings) {
			return switch (this) {
				case HORIZONTAL -> layout.method_46455(element, 0, index, layoutSettings);
				case VERTICAL -> layout.method_46455(element, index, 0, layoutSettings);
			};
		}
	}
}
