/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient (Waypoints Mod).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.waypoints.map;

import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.waypoints.AxolotlClientWaypoints;
import io.github.axolotlclient.waypoints.AxolotlClientWaypointsCommon;
import io.github.axolotlclient.waypoints.HudCreator;
import io.github.axolotlclient.waypoints.util.ARGB;
import io.github.axolotlclient.waypoints.waypoints.Waypoint;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1163;
import net.minecraft.class_156;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3620;
import net.minecraft.class_4076;
import net.minecraft.class_485;
import org.joml.Vector3f;

public class Minimap extends MinimapCommon {

	private static final class_2960 texLocation = AxolotlClientWaypoints.rl("minimap");
	public static final class_2960 arrowLocation = AxolotlClientWaypoints.rl("textures/gui/sprites/arrow.png");
	private final class_1011 pixels = new class_1011(viewDistance, viewDistance, false);
	public long updateDuration = -1;
	private class_1043 tex;
	private int mapCenterX, mapCenterZ;
	private boolean usingHud;
	public boolean allowCaves = true;

	private final class_310 minecraft = class_310.method_1551();

	public void init() {
		minimap.add(enabled, lockMapToNorth, arrowScale, minimapOutline, outlineColor, enableBiomeBlending, mapScale, showWaypoints, showCardinalDirections);
		AxolotlClientWaypointsCommon.category.add(Minimap.minimap);
		if (AxolotlClientWaypointsCommon.AXOLOTLCLIENT_PRESENT) {
			usingHud = true;
			var save = HudCreator.createHud(this);
			ClientLifecycleEvents.CLIENT_STOPPING.register(mc -> save.run());
		}
	}

	public boolean isEnabled() {
		return enabled.get();
	}

	public void setup() {
		minecraft.method_1531().method_4616(texLocation, tex = new class_1043(pixels));
		pixels.method_4326(0, 0, pixels.method_4307(), pixels.method_4323(), ARGB.opaque(0));
		this.x = minecraft.method_22683().method_4489() - size - 10;
		this.y = 10;
	}

	public void renderMapOverlay(class_332 guiGraphics, float delta) {
		if (usingHud) {
			return;
		}
		this.x = minecraft.method_22683().method_4486() - size - 10;
		this.y = 10;
		if (minecraft.method_1530()) {
			this.y += 15;
		}
		if (!minecraft.field_1724.method_6026().isEmpty() && (minecraft.field_1755 == null ||
			!(this.minecraft.field_1755 instanceof class_485<?> effectRenderingInventoryScreen && effectRenderingInventoryScreen.method_38934()))) {
			if (minecraft.field_1724.method_6026().stream().anyMatch(e -> !e.method_5579().method_5573())) {
				this.y += 26;
			}
			this.y += 20;
		}
		renderMap(guiGraphics);
	}

	public void renderMap(AxoRenderContext ctx) {
		renderMap((class_332) ctx);
	}

	public void renderMap(class_332 guiGraphics) {
		if (!isEnabled()) {
			return;
		}
		guiGraphics.method_51448().method_22903();
		{
			guiGraphics.method_44379(x, y, x + size, y + size);
			guiGraphics.method_51448().method_22903();
			guiGraphics.method_51448().method_46416(x, y, 0);
			guiGraphics.method_51448().method_46416(radius, radius, 0);
			if (!lockMapToNorth.get()) {
				guiGraphics.method_51448().method_23760().method_23761().rotate((float) -(((minecraft.field_1724.method_43078() + 180) / 180) * Math.PI), 0, 0, 1);
			}
			guiGraphics.method_51448().method_22905((float) Math.sqrt(2), (float) Math.sqrt(2), 1);
			guiGraphics.method_51448().method_22905(mapScale.get(), mapScale.get(), 1);
			guiGraphics.method_51448().method_46416(-radius, -radius, 0);
			float offX, offZ;
			offX = -(float) (minecraft.field_1724.method_23317() - mapCenterX);
			offZ = -(float) (minecraft.field_1724.method_23321() - mapCenterZ);
			guiGraphics.method_51448().method_46416(offX, offZ, 0);
			guiGraphics.method_25290(texLocation, 0, 0, 0, 0, pixels.method_4307(), pixels.method_4323(), size, size);
			guiGraphics.method_51448().method_22909();
			guiGraphics.method_44380();
		}

		if (minimapOutline.get() && !usingHud) {
			guiGraphics.method_49601(x, y, size, size, outlineColor.get().toInt());
		}
		if (showWaypoints.get()) {
			renderMapWaypoints(guiGraphics);
		}
		if (showCardinalDirections.get()) {
			Vector3f pos = new Vector3f();
			guiGraphics.method_51448().method_22903();
			var directions = new String[]{"N", "W", "E", "S"};
			for (int i : new int[]{-2, 1, 2, -1}) {
				var label = directions[i < 0 ? i + 2 : i + 1];
				var labelWidth = minecraft.field_1772.method_1727(label);
				var labelHeight = minecraft.field_1772.field_2000;
				guiGraphics.method_51448().method_22903();
				guiGraphics.method_51448().method_34426();
				guiGraphics.method_51448().method_46416(x + radius, y + radius, 0);
				if (!lockMapToNorth.get()) {
					guiGraphics.method_51448().method_23760().method_23761().rotate((float) -(((minecraft.field_1724.method_43078() + 180) / 180) * Math.PI), 0, 0, 1);
				}
				guiGraphics.method_51448().method_46416((i % 2) * size, ((int) (i / 2f)) * size, 0);
				pos.zero();
				guiGraphics.method_51448().method_23760().method_23761().transformPosition(pos);
				guiGraphics.method_51448().method_22909();
				pos.x = class_3532.method_15363(pos.x, x, x + size);
				pos.y = class_3532.method_15363(pos.y, y, y + size);
				guiGraphics.method_51448().method_22903();
				guiGraphics.method_51448().method_23760().method_23761().translate(pos);
				guiGraphics.method_51448().method_22905(0.5f, 0.5f, 1);
				guiGraphics.method_25294(-(labelWidth / 2 + 2), -(labelHeight / 2 + 2), labelWidth / 2 + 2, labelHeight / 2 + 2, 0x77888888);
				guiGraphics.method_25303(minecraft.field_1772, label, -labelWidth / 2, -labelHeight / 2, -1);
				guiGraphics.method_51448().method_22909();
			}
			guiGraphics.method_51448().method_22909();
		}

		guiGraphics.method_51448().method_22903();
		guiGraphics.method_51448().method_46416(x + radius, y + radius, 0);
		if (lockMapToNorth.get()) {
			guiGraphics.method_51448().method_23760().method_23761().rotate((float) (((minecraft.field_1724.method_43078() + 180) / 180) * Math.PI), 0, 0, 1);
		}
		guiGraphics.method_51448().method_22905(0.5f * arrowScale.get(), 0.5f * arrowScale.get(), 1);
		int arrowSize = 15;
		guiGraphics.method_51448().method_46416(-arrowSize / 2f, -arrowSize / 2f, 1);
		guiGraphics.method_25290(arrowLocation, 0, 0, 0, 0, arrowSize, arrowSize, arrowSize, arrowSize);
		guiGraphics.method_51448().method_22909();

		guiGraphics.method_51448().method_22909();
	}

	private void renderMapWaypoints(class_332 graphics) {
		if (!AxolotlClientWaypoints.renderWaypoints.get()) return;
		graphics.method_51448().method_22903();
		Vector3f pos = new Vector3f();
		for (Waypoint waypoint : AxolotlClientWaypoints.getCurrentWaypoints()) {
			graphics.method_51448().method_22903();
			float posX = (float) (waypoint.x() - minecraft.field_1724.method_23317());
			float posY = (float) (waypoint.z() - minecraft.field_1724.method_23321());

			{
				pos.zero();
				graphics.method_51448().method_22903();
				graphics.method_51448().method_34426();
				graphics.method_51448().method_46416(x, y, 0);
				graphics.method_51448().method_46416(radius, radius, 0);
				graphics.method_51448().method_22905((float) Math.sqrt(2), (float) Math.sqrt(2), 1);
				graphics.method_51448().method_22905(mapScale.get(), mapScale.get(), 1);
				if (!lockMapToNorth.get()) {
					graphics.method_51448().method_23760().method_23761().rotate((float) -Math.toRadians(minecraft.field_1724.method_43078() + 180), 0, 0, 1);
				}
				graphics.method_51448().method_46416(posX, posY, 1);
				graphics.method_51448().method_23760().method_23761().transformPosition(pos);
				graphics.method_51448().method_22909();
			}

			{
				pos.x = class_3532.method_15363(pos.x, x, x + size);
				pos.y = class_3532.method_15363(pos.y, y, y + size);
				graphics.method_51448().method_23760().method_23761().translate(pos);
			}

			int textWidth = minecraft.field_1772.method_1727(waypoint.display());
			int textHeight = minecraft.field_1772.field_2000;
			graphics.method_25294(-(textWidth / 2) - Waypoint.displayXOffset(), -(textHeight / 2) - Waypoint.displayYOffset(), (textWidth / 2) + Waypoint.displayXOffset(), (textHeight / 2) + Waypoint.displayYOffset(), waypoint.color().toInt());
			graphics.method_51433(minecraft.field_1772, waypoint.display(), -(textWidth / 2), -textHeight / 2, -1, false);
			graphics.method_51448().method_22909();
		}
		graphics.method_51448().method_22909();
	}

	public void updateMapView() {
		if (!isEnabled()) {
			updateDuration = -1;
			return;
		}
		long start = class_156.method_648();
		int centerX = minecraft.field_1724.method_31477();
		int centerZ = minecraft.field_1724.method_31479();
		mapCenterX = centerX;
		mapCenterZ = centerZ;
		int size = pixels.method_4307();
		int texHalfWidth = size / 2;

		class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
		class_2338.class_2339 mutableBlockPos2 = new class_2338.class_2339();

		var level = minecraft.field_1687;
		var centerChunk = level.method_8497(class_4076.method_18675(centerX), class_4076.method_18675(centerZ));
		var surface = centerChunk.method_12005(class_2902.class_2903.field_13202, centerX, centerZ);
		mutableBlockPos.method_10103(centerX, surface, centerZ);
		int solidBlocksAbovePlayer = 0;
		boolean atSurface = false;
		if (level.method_8597().comp_643()) {
			atSurface = minecraft.field_1724.method_31478() >= level.method_8597().comp_653();
		} else if (surface + 1 <= minecraft.field_1724.method_31478()) {
			atSurface = true;
		} else {
			while (solidBlocksAbovePlayer <= 3 && surface > minecraft.field_1724.method_31478() && surface > level.method_31607()) {
				class_2680 state = centerChunk.method_8320(mutableBlockPos);
				mutableBlockPos.method_33098(surface--);
				if (!(state.method_26167(level, mutableBlockPos.method_10074()) || !state.method_26225() || !state.method_26230(level, mutableBlockPos))) {
					solidBlocksAbovePlayer++;
				}
			}
			if (solidBlocksAbovePlayer <= 2) {
				atSurface = true;
			}
		}

		boolean updated = false;
		for (int x = 0; x < size; x++) {
			double d = 0.0;
			for (int z = -1; z < size; z++) {
				int chunkX = (centerX + x - texHalfWidth);
				int chunkZ = (centerZ + z - texHalfWidth);
				class_2791 levelChunk = level.method_8402(class_4076.method_18675(chunkX), class_4076.method_18675(chunkZ), class_2806.field_12803, false);
				if (levelChunk != null) {
					int fluidDepth = 0;
					double e = 0.0;
					mutableBlockPos.method_10103(chunkX, 0, chunkZ);
					int y = levelChunk.method_12005(class_2902.class_2903.field_13202, mutableBlockPos.method_10263(), mutableBlockPos.method_10260()) + 1;
					if (!atSurface) {
						y = Math.min(y, minecraft.field_1724.method_31478());
					}
					class_2680 blockState;
					if (y <= level.method_31607()) {
						blockState = class_2246.field_10124.method_9564();
					} else {
						do {
							mutableBlockPos.method_33098(--y);
							blockState = levelChunk.method_8320(mutableBlockPos);
						} while (blockState.method_26205(level, mutableBlockPos) == class_3620.field_16008 && y > level.method_31607());

						if (y > level.method_31607() && !blockState.method_26227().method_15769()) {
							int highestFullBlockY = y - 1;
							mutableBlockPos2.method_10101(mutableBlockPos);

							class_2680 blockState2;
							do {
								mutableBlockPos2.method_33098(highestFullBlockY--);
								blockState2 = levelChunk.method_8320(mutableBlockPos2);
								fluidDepth++;
							} while (highestFullBlockY > level.method_31607() && !blockState2.method_26227().method_15769());

							class_3610 fluidState = blockState.method_26227();
							blockState = !fluidState.method_15769() && !blockState.method_26206(level, mutableBlockPos, class_2350.field_11036) ? fluidState.method_15759() : blockState;
						}
					}

					e += y;
					var mapColor = blockState.method_26205(level, mutableBlockPos);

					int color;
					if (mapColor == class_3620.field_16019) {
						var floorBlock = levelChunk.method_8320(mutableBlockPos2);
						var floorColor = floorBlock.method_26205(level, mutableBlockPos2).field_16011;
						int biomeColor = enableBiomeBlending.get() ? class_1163.method_4961(level, mutableBlockPos) : mapColor.field_16011;
						float shade = level.method_24852(class_2350.field_11036, true);
						int waterColor = biomeColor;
						waterColor = ARGB.colorFromFloat(1f, ARGB.redFloat(waterColor) * shade, ARGB.greenFloat(waterColor) * shade, ARGB.blueFloat(waterColor) * shade);
						waterColor = ARGB.average(waterColor, ARGB.scaleRGB(floorColor, 1f - fluidDepth / 15f));
						color = waterColor;
					} else {
						double f = (e - d) * 4.0 / (1 + 4) + ((x + z & 1) - 0.5) * 0.4;
						class_3620.class_6594 brightness;
						if (f > 0.6) {
							brightness = class_3620.class_6594.field_34761;
						} else if (f < -0.6) {
							brightness = class_3620.class_6594.field_34759;
						} else {
							brightness = class_3620.class_6594.field_34760;
						}
						color = mapColor.method_15820(brightness);
					}

					d = e;

					if (z >= 0 && Integer.rotateRight(pixels.method_4315(x, z), 4) != color) {
						pixels.method_4305(x, z, ARGB.opaque(color));
						updated = true;
					}
				} else {
					if (z >= 0 && Integer.rotateRight(pixels.method_4315(x, z), 4) != 0) {
						pixels.method_4305(x, z, ARGB.opaque(0));
						updated = true;
					}
				}
			}
		}
		if (updated) {
			tex.method_4524();
		}
		updateDuration = class_156.method_648() - start;
	}
}
