/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient (Waypoints Mod).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.waypoints.waypoints.gui.util;

import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_339;
import net.minecraft.class_8021;

@Environment(EnvType.CLIENT)
public class SpacerElement implements class_8021 {
	private int x;
	private int y;
	private final int width;
	private final int height;

	public SpacerElement(int width, int height) {
		this(0, 0, width, height);
	}

	public SpacerElement(int x, int y, int width, int height) {
		this.x = x;
		this.y = y;
		this.width = width;
		this.height = height;
	}

	public static SpacerElement width(int width) {
		return new SpacerElement(width, 0);
	}

	public static SpacerElement height(int height) {
		return new SpacerElement(0, height);
	}

	@Override
	public void method_46421(int x) {
		this.x = x;
	}

	@Override
	public void method_46419(int y) {
		this.y = y;
	}

	@Override
	public int method_46426() {
		return this.x;
	}

	@Override
	public int method_46427() {
		return this.y;
	}

	@Override
	public int method_25368() {
		return this.width;
	}

	@Override
	public int method_25364() {
		return this.height;
	}

	@Override
	public void method_48206(Consumer<class_339> consumer) {
	}
}
