/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient (Waypoints Mod).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.waypoints.waypoints.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.ColorOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.ColorWidget;
import io.github.axolotlclient.waypoints.AxolotlClientWaypoints;
import io.github.axolotlclient.waypoints.waypoints.Waypoint;
import io.github.axolotlclient.waypoints.waypoints.gui.util.*;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5676;
import net.minecraft.class_6382;
import net.minecraft.class_8021;
import net.minecraft.client.gui.components.*;

public class EditWaypointScreen extends class_437 {

	private final HeaderAndFooterLayout haFL = new HeaderAndFooterLayout(this);
	private final class_437 parent;
	private double x = -1, y = -1, z = -1;
	private class_4185 save;
	private boolean initialized;
	private final List<class_8021> centeredLayouts = new ArrayList<>();
	private final Waypoint toEdit;

	public EditWaypointScreen(class_437 screen, Waypoint toEdit) {
		super(AxolotlClientWaypoints.tr("edit_waypoint_title"));
		this.parent = screen;
		this.toEdit = toEdit;
	}

	@Override
	public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		method_25420(guiGraphics);
		super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
	}

	@Override
	protected void method_25426() {
		if (!initialized) {
			haFL.addTitleHeader(method_25440(), field_22793);
			ColorOption color = new ColorOption("", toEdit.color().immutable());

			var contents = haFL.addToContents(LinearLayout.vertical()).spacing(4);
			contents.addChild(new StringWidget(AxolotlClientWaypoints.tr("waypoint_position"), field_22793)).method_48597().method_25358(haFL.method_25368());
			var dimensionLine = contents.addChild(LinearLayout.horizontal()).spacing(4);
			dimensionLine.addChild(new StringWidget(AxolotlClientWaypoints.tr("waypoint_position.dimension"), field_22793)).setHeight(20);
			var dimension = dimensionLine.addChild(new class_342(field_22793, 0, 0, 150, 20, AxolotlClientWaypoints.tr("waypoint_position_dimension")));
			dimension.method_1852(toEdit.dimension());
			var positionLine = contents.addChild(LinearLayout.horizontal()).spacing(4);
			positionLine.addChild(new StringWidget(AxolotlClientWaypoints.tr("waypoint_position.x_label"), field_22793)).setHeight(20);
			var x = positionLine.addChild(new class_342(field_22793, 0, 0, 75, 20, AxolotlClientWaypoints.tr("waypoint_position.x")));
			positionLine.addChild(new StringWidget(AxolotlClientWaypoints.tr("waypoint_position.y_label"), field_22793)).setHeight(20);
			var y = positionLine.addChild(new class_342(field_22793, 0, 0, 75, 20, AxolotlClientWaypoints.tr("waypoint_position.y")));
			positionLine.addChild(new StringWidget(AxolotlClientWaypoints.tr("waypoint_position.z_label"), field_22793)).setHeight(20);
			var z = positionLine.addChild(new class_342(field_22793, 0, 0, 75, 20, AxolotlClientWaypoints.tr("waypoint_position.z")));
			x.method_1863(s -> {
				try {
					this.x = Double.parseDouble(s);
				} catch (Exception ignored) {
					this.x = -1;
				}
			});
			y.method_1863(s -> {
				try {
					this.y = Double.parseDouble(s);
				} catch (Exception ignored) {
					this.y = -1;
				}
			});
			z.method_1863(s -> {
				try {
					this.z = Double.parseDouble(s);
				} catch (Exception ignored) {
					this.z = -1;
				}
			});
			x.method_1852(String.valueOf(toEdit.x()));
			y.method_1852(String.valueOf(toEdit.y()));
			z.method_1852(String.valueOf(toEdit.z()));
			contents.addChild(SpacerElement.height(10));

			contents.addChild(new StringWidget(AxolotlClientWaypoints.tr("waypoint_display"), field_22793)).method_48597().method_25358(haFL.method_25368());
			var nameLine = contents.addChild(LinearLayout.horizontal()).spacing(4);
			nameLine.addChild(new StringWidget(AxolotlClientWaypoints.tr("waypoint_display.name_label"), field_22793)).setHeight(20);
			var name = nameLine.addChild(new class_342(field_22793, 0, 0, 100, 20, AxolotlClientWaypoints.tr("waypoint_display.name")));
			nameLine.addChild(new StringWidget(AxolotlClientWaypoints.tr("waypoint_display.display_label"), field_22793)).setHeight(20);
			var display = nameLine.addChild(new class_342(field_22793, 0, 0, 50, 20, AxolotlClientWaypoints.tr("waypoint_display.display")));
			var lockButton = nameLine.addChild(class_5676.method_32613(true).method_32617(0, 0, 100, 20, AxolotlClientWaypoints.tr("waypoint_display.unlock_display"), (btn, v) -> {
				display.field_22763 = !v;
			}));
			lockButton.method_25358(100);
			name.method_1852(toEdit.name());
			name.method_1863(s -> {
				if (lockButton.method_32603()) {
					var d = s.trim();
					display.method_1852(d.isEmpty() ? "" : d.substring(0, 1).toUpperCase(Locale.ROOT));
				}
			});
			display.field_22763 = false;
			display.method_1852(toEdit.display());
			name.method_1880(150);
			display.method_1880(10);
			contents.addChild(SpacerElement.height(10));

			contents.addChild(new StringWidget(AxolotlClientWaypoints.tr("waypoint_color"), field_22793)).method_48597().method_25358(haFL.method_25368());
			var colorLine = contents.addChild(LinearLayout.horizontal()).spacing(4);
			colorLine.addChild(new class_339(0, 0, 100, 20, class_2561.method_43473()) {
				@Override
				protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
					guiGraphics.method_25294(method_46426(), method_46427(), method_46426()+method_25368(), method_46427()+method_25364(), color.get().toInt());
					guiGraphics.method_49601(method_46426(), method_46427(), method_25368(), method_25364(), Colors.BLACK.toInt());
				}

				@Override
				protected void method_47399(class_6382 narrationElementOutput) {

				}
			}).field_22763 = false;
			colorLine.addChild(new ColorWidget(0, 0, 100, 20, color));

			var footer = haFL.addToFooter(LinearLayout.horizontal()).spacing(4);
			save = footer.addChild(class_4185.method_46430(class_5244.field_24334, btn -> {
				AxolotlClientWaypoints.WAYPOINT_STORAGE.replace(toEdit, new Waypoint(dimension.method_1882(), this.x, this.y, this.z, color.getOriginal(), name.method_1882(), display.method_1882()));
				field_22787.method_1507(parent);
			}).method_46431());
			footer.addChild(class_4185.method_46430(class_5244.field_24335, btn -> field_22787.method_1507(parent)).method_46431());

			initialized = true;
			centeredLayouts.add(dimensionLine);
			centeredLayouts.add(positionLine);
			centeredLayouts.add(nameLine);
			centeredLayouts.add(colorLine);
		}
		haFL.method_48222();
		centeredLayouts.forEach(child -> FrameLayout.centerInRectangle(child, 0, child.method_46427(), haFL.method_25368(), child.method_25364()));
		haFL.method_48206(this::method_37063);
	}

	@Override
	public void method_25393() {
		method_25396().stream().filter(e -> e instanceof class_342)
			.map(e -> (class_342) e).forEach(class_342::method_1865);
		save.field_22763 = x != -1 && y != -1 && z != -1;
	}
}
