/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient (Waypoints Mod).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.waypoints.waypoints.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

import io.github.axolotlclient.waypoints.AxolotlClientWaypoints;
import io.github.axolotlclient.waypoints.waypoints.Waypoint;
import io.github.axolotlclient.waypoints.waypoints.gui.util.HeaderAndFooterLayout;
import io.github.axolotlclient.waypoints.waypoints.gui.util.LinearLayout;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6379;
import net.minecraft.class_7842;
import net.minecraft.class_8021;
import net.minecraft.client.gui.components.*;

public class WaypointsScreen extends class_437 {

	private final class_437 parent;

	public WaypointsScreen(class_437 screen) {
		super(AxolotlClientWaypoints.tr("manage"));
		this.parent = screen;
	}

	@Override
	protected void method_25426() {
		HeaderAndFooterLayout haF = new HeaderAndFooterLayout(this, 60, 33);
		WaypointsList entries = new WaypointsList(field_22787, field_22790, haF.method_25368(), haF.getContentHeight(), haF.getHeaderHeight(), 25);
		haF.addToContents(entries);

		var header = haF.addToHeader(LinearLayout.vertical()).spacing(8);
		header.addChild(new class_7842(method_25440(), field_22793).method_48597()).method_25358(200);
		var search = header.addChild(new class_342(field_22793, 0, 0, 200, 20, AxolotlClientWaypoints.tr("waypoint_search")));
		search.method_47404(AxolotlClientWaypoints.tr("waypoint_search"));
		search.method_1863(entries::applySearch);

		var footer = haF.addToFooter(LinearLayout.horizontal()).spacing(4);
		footer.addChild(class_4185.method_46430(AxolotlClientWaypoints.tr("create_waypoint"), btn -> field_22787.method_1507(new CreateWaypointScreen(this))).method_46431());
		footer.addChild(class_4185.method_46430(class_5244.field_24334, btn -> method_25419()).method_46431());


		haF.method_48222();
		method_37063(entries);
		haF.method_48206(this::method_37063);

		entries.loadEntries(AxolotlClientWaypoints.getCurrentWaypoints(false));
	}

	@Override
	public void method_25419() {
		AxolotlClientWaypoints.WAYPOINT_STORAGE.save();
		field_22787.method_1507(parent);
	}

	@Override
	public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		method_25420(guiGraphics);
		super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
	}

	@Override
	public void method_25393() {
		method_25396().stream().filter(e -> e instanceof class_342)
			.map(e -> (class_342) e).forEach(class_342::method_1865);
	}

	private class WaypointsList extends class_4265<WaypointsList.Entry> implements class_8021 {

		private final List<Waypoint> waypoints = new ArrayList<>();
		private String search = null;

		public WaypointsList(class_310 minecraft, int screenHeight, int width, int height, int y, int entryHeight) {
			super(minecraft, width, screenHeight, y, y + height, entryHeight);
		}

		public void loadEntries(List<Waypoint> waypoints) {
			this.waypoints.clear();
			this.waypoints.addAll(waypoints);
			applySearch(search);
		}

		public void applySearch(String s) {
			this.search = s;
			method_25339();
			waypoints.stream().filter(w -> s == null || w.name().contains(s)).forEach(w -> method_25321(new Entry(w)));
		}

		@Override
		public int method_25322() {
			return 300;
		}

		@Override
		public void method_46421(int x) {
			method_25333(x);
		}

		@Override
		public void method_46419(int y) {
			int height = field_19086 - field_19085;
			field_19085 = y;
			field_19086 = field_19085 + height;
		}

		@Override
		public int method_46426() {
			return field_19088;
		}

		@Override
		public int method_46427() {
			return field_19085;
		}

		@Override
		public int method_25368() {
			return field_19087 - field_19088;
		}

		@Override
		public int method_25364() {
			return field_19086 - field_19085;
		}

		@Override
		public void method_48206(Consumer<class_339> consumer) {
			method_25396().stream().flatMap(entry -> entry.children.stream()).forEach(consumer);
		}

		public void updateSize(int width, HeaderAndFooterLayout layout) {
			this.method_25323(width, field_22743, layout.getHeaderHeight(), layout.getContentHeight() - layout.getHeaderHeight());
		}

		@Override
		protected int method_25329() {
			return method_31383()+10;
		}

		private class Entry extends class_4265.class_4266<Entry> {

			private final List<class_339> children = new ArrayList<>();
			private final Waypoint waypoint;
			private final class_310 minecraft = class_310.method_1551();

			private Entry(Waypoint waypoint) {
				this.waypoint = waypoint;
				children.add(class_4185.method_46430(AxolotlClientWaypoints.tr("edit_waypoint"), btn ->
					minecraft.method_1507(new EditWaypointScreen(WaypointsScreen.this, waypoint))).method_46432(50).method_46431());
				children.add(class_4185.method_46430(AxolotlClientWaypoints.tr("remove_waypoint"), btn -> {
					method_25330(this);
					AxolotlClientWaypoints.WAYPOINT_STORAGE.getWaypoints().remove(waypoint);
				}).method_46432(50).method_46431());
			}

			@Override
			public List<? extends class_6379> method_37025() {
				return children;
			}

			@Override
			public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
				var font = minecraft.field_1772;
				guiGraphics.method_51448().method_22903();
				int textWidth = font.method_1727(waypoint.display());
				int displayWidth = textWidth + Waypoint.displayXOffset() * 2;
				int textHeight = font.field_2000;
				int displayHeight = textHeight + Waypoint.displayYOffset() * 2;
				guiGraphics.method_51448().method_46416(left + width / 6f, top + height / 2f, 0);
				guiGraphics.method_51448().method_22905(Math.min(1, 100 / displayWidth), Math.min(1, 100 / displayWidth), 1);
				guiGraphics.method_51448().method_22903();
				guiGraphics.method_51448().method_46416(-displayWidth / 2f, -displayHeight / 2f, 0);
				guiGraphics.method_25294(0, 0, displayWidth, displayHeight, waypoint.color().toInt());
				guiGraphics.method_51448().method_22909();
				guiGraphics.method_51448().method_46416(-textWidth / 2f, -textHeight / 2f, 0);
				guiGraphics.method_25303(font, waypoint.display(), 0, 0, -1);
				guiGraphics.method_51448().method_22909();
				guiGraphics.method_51448().method_22903();
				guiGraphics.method_51448().method_46416(left + width / 2f, top + height / 2f, 0);
				int nameWidth = font.method_1727(waypoint.name());
				guiGraphics.method_25303(font, waypoint.name(), -nameWidth / 2, -font.field_2000 / 2, -1);
				guiGraphics.method_51448().method_22909();

				int buttonsX = left + width;
				for (int i = children.size() - 1; i >= 0; i--) {
					class_339 w = children.get(i);
					w.method_46421(buttonsX - w.method_25368());
					buttonsX -= w.method_25368() + 4;
					w.method_46419(top + height / 2 - w.method_25364() / 2);
					w.method_25394(guiGraphics, mouseX, mouseY, partialTick);
				}
			}

			@Override
			public List<? extends class_364> method_25396() {
				return children;
			}
		}
	}
}
