/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient (Waypoints Mod).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.waypoints.map.widgets;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5244;

@Environment(EnvType.CLIENT)
public class ImageButton extends class_4185 {
	protected final WidgetSprites sprites;

	public ImageButton(int x, int y, int width, int height, WidgetSprites sprites, class_4185.class_4241 onPress) {
		this(x, y, width, height, sprites, onPress, class_5244.field_39003);
	}

	public ImageButton(int x, int y, int width, int height, WidgetSprites sprites, class_4185.class_4241 onPress, class_2561 message) {
		super(x, y, width, height, message, onPress, field_40754);
		this.sprites = sprites;
	}

	public ImageButton(int width, int height, WidgetSprites sprites, class_4185.class_4241 onPress, class_2561 message) {
		this(0, 0, width, height, sprites, onPress, message);
	}

	@Override
	public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		class_2960 resourceLocation = this.sprites.get(this.method_37303(), this.method_25367());
		guiGraphics.method_25290(resourceLocation, this.method_46426(), this.method_46427(), 0, 0, this.field_22758, this.field_22759, field_22758, field_22759);
	}
}
