/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.waypoints.waypoints.gui.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_3532;
import net.minecraft.class_7838;
import net.minecraft.class_7847;
import net.minecraft.class_8021;
import net.minecraft.class_8030;

@Environment(value=EnvType.CLIENT)
public class FrameLayout
extends class_7838 {
    private final List<ChildContainer> children = new ArrayList<ChildContainer>();
    private int minWidth;
    private int minHeight;
    private final class_7847 defaultChildLayoutSettings = class_7847.method_46481().method_46463(0.5f, 0.5f);

    public FrameLayout() {
        this(0, 0, 0, 0);
    }

    public FrameLayout(int width, int height) {
        this(0, 0, width, height);
    }

    public FrameLayout(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.setMinDimensions(width, height);
    }

    public FrameLayout setMinDimensions(int minWidth, int minHeight) {
        return this.setMinWidth(minWidth).setMinHeight(minHeight);
    }

    public FrameLayout setMinHeight(int minHeight) {
        this.minHeight = minHeight;
        return this;
    }

    public FrameLayout setMinWidth(int minWidth) {
        this.minWidth = minWidth;
        return this;
    }

    public class_7847 newChildLayoutSettings() {
        return this.defaultChildLayoutSettings.method_46478();
    }

    public class_7847 defaultChildLayoutSetting() {
        return this.defaultChildLayoutSettings;
    }

    public void method_48222() {
        super.method_48222();
        int i = this.minWidth;
        int j = this.minHeight;
        for (ChildContainer childContainer : this.children) {
            i = Math.max(i, childContainer.method_46424());
            j = Math.max(j, childContainer.method_46422());
        }
        for (ChildContainer childContainer : this.children) {
            childContainer.method_46423(this.method_46426(), i);
            childContainer.method_46425(this.method_46427(), j);
        }
        this.field_41813 = i;
        this.field_41814 = j;
    }

    public <T extends class_8021> T addChild(T child) {
        return this.addChild(child, this.newChildLayoutSettings());
    }

    public <T extends class_8021> T addChild(T child, class_7847 layoutSettings) {
        this.children.add(new ChildContainer(child, layoutSettings));
        return child;
    }

    public <T extends class_8021> T addChild(T child, Consumer<class_7847> layoutSettingsFactory) {
        return this.addChild(child, (class_7847)class_156.method_654((Object)this.newChildLayoutSettings(), layoutSettingsFactory));
    }

    public void method_48227(Consumer<class_8021> visitor) {
        this.children.forEach(childContainer -> visitor.accept(childContainer.field_40752));
    }

    public static void centerInRectangle(class_8021 child, int x, int y, int width, int height) {
        FrameLayout.alignInRectangle(child, x, y, width, height, 0.5f, 0.5f);
    }

    public static void centerInRectangle(class_8021 child, class_8030 rectangle) {
        FrameLayout.centerInRectangle(child, rectangle.comp_1195().comp_1193(), rectangle.comp_1195().comp_1194(), rectangle.comp_1196(), rectangle.comp_1197());
    }

    public static void alignInRectangle(class_8021 child, class_8030 rectangle, float deltaX, float deltaY) {
        FrameLayout.alignInRectangle(child, rectangle.method_49620(), rectangle.method_49618(), rectangle.comp_1196(), rectangle.comp_1197(), deltaX, deltaY);
    }

    public static void alignInRectangle(class_8021 child, int x, int y, int width, int height, float deltaX, float deltaY) {
        FrameLayout.alignInDimension(x, width, child.method_25368(), arg_0 -> ((class_8021)child).method_46421(arg_0), deltaX);
        FrameLayout.alignInDimension(y, height, child.method_25364(), arg_0 -> ((class_8021)child).method_46419(arg_0), deltaY);
    }

    public static void alignInDimension(int position, int rectangleLength, int childLength, Consumer<Integer> setter, float delta) {
        int i = (int)class_3532.method_16439((float)delta, (float)0.0f, (float)(rectangleLength - childLength));
        setter.accept(position + i);
    }

    @Environment(value=EnvType.CLIENT)
    static class ChildContainer
    extends class_7838.class_7839 {
        protected ChildContainer(class_8021 layoutElement, class_7847 layoutSettings) {
            super(layoutElement, layoutSettings);
        }
    }
}

