/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient (Waypoints Mod).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.waypoints.map;

import java.util.List;

import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.waypoints.AxolotlClientWaypoints;
import io.github.axolotlclient.waypoints.waypoints.gui.CreateWaypointScreen;
import io.github.axolotlclient.waypoints.waypoints.gui.EditWaypointScreen;
import lombok.extern.slf4j.Slf4j;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7852;
import net.minecraft.class_8021;
import net.minecraft.class_8130;
import net.minecraft.class_8667;

@SuppressWarnings("DataFlowIssue")
@Slf4j
public class ContextMenuScreen extends class_437 {

	private final class_437 parent;
	private final int posX;
	private final int posY;
	private final class_8667 layout = class_8667.method_52741();
	private final Type type;

	public ContextMenuScreen(class_437 parent, int x, int y, Type type) {
		super(AxolotlClientWaypoints.tr("context_menu"));
		this.parent = parent;
		this.posX = x + 4;
		this.posY = y + 4;
		this.type = type;
	}

	public ContextMenuScreen(class_437 parent, double x, double y, Type type) {
		this(parent, (int) x, (int) y, type);
	}

	@Override
	protected void method_25426() {
		parent.method_25423(field_22787, field_22789, field_22790);

		type.build(field_22787, parent).forEach(layout::method_52736);

		layout.method_48206(w -> {
			w.method_25358(100);
			w.method_53533(12);
		});

		layout.method_48229(posX, posY);
		layout.method_52740().method_46467();
		layout.method_48222();

		boolean updated = false;
		if (layout.method_46427()+layout.method_25364() > field_22790) {
			layout.method_46419(field_22790-layout.method_25364());
			updated = true;
		}
		if (layout.method_46426()+layout.method_25368() > field_22789) {
			layout.method_46421(field_22789-layout.method_25368());
			updated = true;
		}
		if (updated) {
			layout.method_48222();
		}

		layout.method_48206(this::method_37063);
	}

	@Override
	public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {

	}

	@Override
	public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		if (parent != null) {
			parent.method_25394(guiGraphics, posX - 4, posY - 4, partialTick);
		}
		guiGraphics.method_49601(layout.method_46426() - 1, layout.method_46427() - 1, layout.method_25368() + 2, layout.method_25364() + 2, Colors.GRAY.toInt());
		guiGraphics.method_25294(layout.method_46426() - 1, layout.method_46427() - 1, layout.method_46426() + layout.method_25368() + 2, layout.method_46427() + layout.method_25364() + 2, Colors.DARK_GRAY.withAlpha(100).toInt());
		super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
	}

	@Override
	public boolean method_25402(double mouseX, double mouseY, int button) {
		if (layout.method_48202().method_58137((int) mouseX, (int) mouseY)) {
			return super.method_25402(mouseX, mouseY, button);
		}
		method_25419();
		return parent.method_25402(mouseX, mouseY, button);
	}

	@Override
	public void method_25419() {
		field_22787.method_1507(parent);
	}

	@Override
	public void method_25432() {
		parent.method_25432();
	}

	private static class TitleWidget extends class_8130 {

		public TitleWidget(int x, int y, int width, int height, class_2561 message, class_327 font) {
			super(x, y, width, height, message, font);
		}

		public TitleWidget(class_2561 message, class_327 font) {
			this(0, 0, font.method_27525(message), font.field_2000, message, font);
		}

		@Override
		protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
			method_52718(guiGraphics, method_48977(), method_25369(), method_46426() + 1, method_46427(), method_55442() - 1, method_55443(), method_48979());
		}
	}

	public sealed interface Type permits Type.Map, Type.Waypoint {
		record Map(String dimension, int worldPosX, int worldPosY, int worldPosZ) implements Type {

			@Override
			public List<class_8021> build(class_310 minecraft, class_437 parent) {
				List<class_8021> entries = new java.util.ArrayList<>();
				entries.add(class_7852.method_46513(4));
				entries.add(new TitleWidget(AxolotlClientWaypoints.tr("position", String.valueOf(worldPosX), String.valueOf(worldPosY), String.valueOf(worldPosZ)), minecraft.field_1772));
				entries.add(class_7852.method_46513(4));
				entries.add(class_4185.method_46430(AxolotlClientWaypoints.tr("create_waypoint"), btn ->
					minecraft.method_1507(new CreateWaypointScreen(parent, worldPosX+0.5f, worldPosY, worldPosZ+0.5f))).method_46431());
				if (AxolotlClientWaypoints.playerHasOp()) {
					entries.add(class_4185.method_46430(AxolotlClientWaypoints.tr("teleport_waypoint"), btn -> {
						minecraft.method_1562().method_45730("execute in %s run teleport @s %s %s %s".formatted(dimension, worldPosX, worldPosY+1, worldPosZ));
						parent.method_25419();
					}).method_46431());
				}
				return entries;
			}
		}

		record Waypoint(io.github.axolotlclient.waypoints.waypoints.Waypoint waypoint) implements Type {
			@Override
			public List<class_8021> build(class_310 minecraft, class_437 parent) {
				List<class_8021> entries = new java.util.ArrayList<>();
				entries.add(class_7852.method_46513(4));
				entries.add(new TitleWidget(class_2561.method_43470(waypoint.name()), minecraft.field_1772));
				entries.add(class_7852.method_46513(4));
				entries.add(class_4185.method_46430(AxolotlClientWaypoints.tr("edit_waypoint"), btn ->
					minecraft.method_1507(new EditWaypointScreen(parent, waypoint))).method_46431());
				if (AxolotlClientWaypoints.playerHasOp()) {
					entries.add(class_4185.method_46430(AxolotlClientWaypoints.tr("teleport_waypoint"), btn -> {
						minecraft.method_1562().method_45730("execute in %s run teleport @s %s %s %s".formatted(waypoint.dimension(), waypoint.x(), waypoint.y()+1, waypoint.z()));
						parent.method_25419();
					}).method_46431());
				}
				return entries;
			}
		}

		List<class_8021> build(class_310 minecraft, class_437 parent);
	}
}
