/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.waypoints.map;

import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.waypoints.AxolotlClientWaypoints;
import io.github.axolotlclient.waypoints.map.ContextMenuScreen;
import io.github.axolotlclient.waypoints.map.Minimap;
import io.github.axolotlclient.waypoints.map.util.LevelChunkStorage;
import io.github.axolotlclient.waypoints.map.widgets.DropdownButton;
import io.github.axolotlclient.waypoints.util.ARGB;
import io.github.axolotlclient.waypoints.waypoints.Waypoint;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_3610;
import net.minecraft.class_3620;
import net.minecraft.class_364;
import net.minecraft.class_4076;
import net.minecraft.class_437;
import net.minecraft.class_638;
import net.minecraft.class_8666;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldMapScreen
extends class_437 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorldMapScreen.class);
    private static final int TILE_SIZE = 16;
    private static final class_2960 OPTIONS_SPRITE = AxolotlClientWaypoints.rl("options");
    private static final class_2960 OPTIONS_HOVERED_SPRITE = OPTIONS_SPRITE.method_48331("_hovered");
    private final Map<Vector2i, LazyTile> tiles = new ConcurrentHashMap<Vector2i, LazyTile>();
    private final Vector3f dragOffset = new Vector3f();
    private float scale = 1.0f;
    public static boolean allowCaves = true;
    public static boolean allowCavesNether;
    private boolean atSurface;
    private int caveY;
    private class_2960 dimension;
    private Waypoint hoveredWaypoint = null;
    private boolean initializedOnce = false;
    private Runnable optionUpdate;

    public WorldMapScreen() {
        super(AxolotlClientWaypoints.tr("worldmap", new Object[0]));
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25420(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)this.field_22789 / 2.0f, (float)this.field_22790 / 2.0f, 0.0f);
        guiGraphics.method_51448().method_23760().method_23761().translate((Vector3fc)this.dragOffset);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_22905(this.scale, this.scale, 1.0f);
        class_243 playerPos = this.field_22787.field_1724.method_19538();
        for (LazyTile tile : this.tiles.values()) {
            tile.render(guiGraphics, (float)playerPos.method_10216(), (float)playerPos.method_10215(), this.scale, partialTick, this.caveY, this.atSurface);
        }
        int x = this.getWorldX(mouseX);
        int z = this.getWorldZ(mouseY);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)(-playerPos.method_10216()), (float)(-playerPos.method_10215()), 0.0f);
        int tileX = x / 16;
        int tileY = z / 16;
        if (x < 0 && x % 16 != 0) {
            --tileX;
        }
        if (z < 0 && z % 16 != 0) {
            --tileY;
        }
        guiGraphics.method_51448().method_46416((float)(tileX * 16), (float)(tileY * 16), 0.0f);
        guiGraphics.method_25294(0, 0, 16, 16, 0x33FFFFFF);
        guiGraphics.method_49601(0, 0, 16, 16, 0x33FFFFFF);
        guiGraphics.method_51448().method_22909();
        guiGraphics.method_51448().method_22909();
        this.renderMapWaypoints(guiGraphics, mouseX, mouseY);
        guiGraphics.method_51448().method_23760().method_23761().rotate((float)((double)((this.field_22787.field_1724.method_43078() + 180.0f) / 180.0f) * Math.PI), 0.0f, 0.0f, 1.0f);
        guiGraphics.method_51448().method_22905(0.5f * (float)((Integer)AxolotlClientWaypoints.MINIMAP.arrowScale.get()).intValue(), 0.5f * (float)((Integer)AxolotlClientWaypoints.MINIMAP.arrowScale.get()).intValue(), 1.0f);
        int arrowSize = 15;
        guiGraphics.method_51448().method_46416((float)(-arrowSize) / 2.0f, (float)(-arrowSize) / 2.0f, 0.0f);
        guiGraphics.method_52706(Minimap.arrowLocation, 0, 0, arrowSize, arrowSize);
        guiGraphics.method_51448().method_22909();
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        int x = this.getWorldX(mouseX);
        int z = this.getWorldZ(mouseY);
        guiGraphics.method_27534(this.field_22793, AxolotlClientWaypoints.tr("position", String.valueOf(x), String.valueOf(this.getY(x, z)), String.valueOf(z)), this.field_22789 / 2, this.field_22790 - 15, Colors.GRAY.toInt());
    }

    private int getY(int x, int z) {
        class_2680 blockState;
        LazyTile tile;
        class_2791 c;
        int tileX = x / 16;
        int tileY = z / 16;
        if (x < 0 && x % 16 != 0) {
            --tileX;
        }
        if (z < 0 && z % 16 != 0) {
            --tileY;
        }
        if ((c = (tile = this.tiles.get(new Vector2i(tileX, tileY))) == null || tile.tile == null ? this.field_22787.field_1687.method_8402(class_4076.method_18675((int)x), class_4076.method_18675((int)z), class_2806.field_12803, false) : tile.tile.chunk.chunk()) == null) {
            return this.field_22787.field_1687.method_31607();
        }
        int y = c.method_12005(class_2902.class_2903.field_13202, x, z);
        if (this.atSurface) {
            return y;
        }
        y = Math.min(y, this.caveY);
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339(x, 0, z);
        do {
            mutableBlockPos.method_33098(--y);
        } while ((blockState = c.method_8320((class_2338)mutableBlockPos)).method_26205((class_1922)this.field_22787.field_1687, (class_2338)mutableBlockPos) == class_3620.field_16008 && y > this.field_22787.field_1687.method_31607());
        return y;
    }

    private int getWorldX(int guiX) {
        return class_3532.method_15357((double)(this.field_22787.field_1724.method_23317() - (double)(((float)this.field_22789 / 2.0f + this.dragOffset.x() - (float)guiX) / this.scale)));
    }

    private int getWorldZ(int guiZ) {
        return class_3532.method_15357((double)(this.field_22787.field_1724.method_23321() - (double)(((float)this.field_22790 / 2.0f + this.dragOffset.y() - (float)guiZ) / this.scale)));
    }

    private void renderMapWaypoints(class_332 graphics, int mouseX, int mouseY) {
        if (!AxolotlClientWaypoints.renderWaypoints.get().booleanValue()) {
            return;
        }
        graphics.method_51448().method_22903();
        Vector3f pos = new Vector3f();
        this.hoveredWaypoint = null;
        for (Waypoint waypoint : AxolotlClientWaypoints.getCurrentWaypoints()) {
            graphics.method_51448().method_22903();
            float posX = (float)(waypoint.x() - this.field_22787.field_1724.method_23317()) + 1.0f;
            float posY = (float)(waypoint.z() - this.field_22787.field_1724.method_23321()) + 1.0f;
            graphics.method_51448().method_46416(posX * this.scale, posY * this.scale, 0.0f);
            pos.zero();
            graphics.method_51448().method_23760().method_23761().transformPosition(pos);
            int textWidth = this.field_22793.method_1727(waypoint.display());
            int width = textWidth + Waypoint.displayXOffset() * 2;
            Objects.requireNonNull(this.field_22793);
            int textHeight = 9;
            int height = textHeight + Waypoint.displayYOffset() * 2;
            pos.sub((float)width / 2.0f, (float)height / 2.0f, 0.0f);
            graphics.method_25294(-(width / 2), -(height / 2), width / 2, height / 2, waypoint.color().toInt());
            graphics.method_51433(this.field_22793, waypoint.display(), -(textWidth / 2), -textHeight / 2, -1, false);
            if (this.hoveredWaypoint == null && (float)mouseX >= pos.x() && (float)mouseY >= pos.y() && (float)mouseX < pos.x() + (float)width && (float)mouseY < pos.y() + (float)height) {
                this.hoveredWaypoint = waypoint;
                graphics.method_49601(-width / 2, -height / 2, width, height, Colors.WHITE.toInt());
            }
            graphics.method_51448().method_22909();
        }
        graphics.method_51448().method_22909();
    }

    private void collectPlayerYData() {
        class_638 level = this.field_22787.field_1687;
        if (allowCaves || allowCavesNether && level.method_8597().comp_643()) {
            int playerX = this.field_22787.field_1724.method_31477();
            int playerZ = this.field_22787.field_1724.method_31479();
            class_2818 centerChunk = level.method_8497(class_4076.method_18675((int)playerX), class_4076.method_18675((int)playerZ));
            int surface = centerChunk.method_12005(class_2902.class_2903.field_13202, playerX, playerZ);
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339(playerX, surface, playerZ);
            int solidBlocksAbovePlayer = 0;
            this.atSurface = false;
            if (level.method_8597().comp_643()) {
                this.atSurface = this.field_22787.field_1724.method_31478() >= level.method_8597().comp_653();
            } else if (surface + 1 <= this.field_22787.field_1724.method_31478()) {
                this.atSurface = true;
            } else {
                while (solidBlocksAbovePlayer <= 3 && surface > this.field_22787.field_1724.method_31478() && surface > level.method_31607()) {
                    class_2680 state = centerChunk.method_8320((class_2338)mutableBlockPos);
                    mutableBlockPos.method_33098(surface--);
                    if (state.method_26167((class_1922)level, mutableBlockPos.method_10074()) || !state.method_26225() || !state.method_26230((class_1922)level, (class_2338)mutableBlockPos)) continue;
                    ++solidBlocksAbovePlayer;
                }
                if (solidBlocksAbovePlayer <= 2) {
                    this.atSurface = true;
                }
            }
        } else {
            this.atSurface = true;
        }
        this.caveY = this.field_22787.field_1724.method_31478();
        this.dimension = level.method_27983().method_29177();
    }

    private void createTiles() {
        int playerZ;
        int playerX = this.field_22787.field_1724.method_31477();
        LazyTile playerTile = this.createTile(playerX, playerZ = this.field_22787.field_1724.method_31479(), this.atSurface, this.caveY);
        if (playerTile != null) {
            HashMap<Vector2i, LazyTile> loadedTiles = new HashMap<Vector2i, LazyTile>(this.tiles);
            this.tiles.clear();
            this.tiles.put(new Vector2i(playerTile.tilePosX(), playerTile.tilePosY()), playerTile);
            this.triggerNeighbourLoad(playerTile, this.atSurface, this.caveY, playerTile);
            loadedTiles.forEach((v, t) -> {
                if (!this.tiles.containsKey(v)) {
                    this.tiles.put((Vector2i)v, (LazyTile)t);
                }
            });
        }
    }

    private void triggerNeighbourLoad(LazyTile tile, boolean atSurface, int caveY, LazyTile origin) {
        ArrayList<Runnable> queue = new ArrayList<Runnable>();
        this.loadNeighbour(tile, -1, -1, atSurface, caveY, queue, origin);
        this.loadNeighbour(tile, -1, 0, atSurface, caveY, queue, origin);
        this.loadNeighbour(tile, -1, 1, atSurface, caveY, queue, origin);
        this.loadNeighbour(tile, 0, 1, atSurface, caveY, queue, origin);
        this.loadNeighbour(tile, 1, 1, atSurface, caveY, queue, origin);
        this.loadNeighbour(tile, 1, 0, atSurface, caveY, queue, origin);
        this.loadNeighbour(tile, 1, -1, atSurface, caveY, queue, origin);
        this.loadNeighbour(tile, 0, -1, atSurface, caveY, queue, origin);
        if (!queue.isEmpty()) {
            queue.reversed().forEach(Runnable::run);
        }
    }

    private void loadNeighbour(LazyTile origin, int tileOffsetX, int tileOffsetY, boolean atSurface, int caveY, List<Runnable> loadQueue, LazyTile mapOrigin) {
        int anchorYLeft;
        int anchorXLeft;
        LazyTile tile;
        int tileYLeft;
        int tileXLeft;
        Vector2i vec;
        if (!(tileOffsetY == 0 && tileOffsetX == 0 || this.tiles.containsKey(vec = new Vector2i(tileXLeft = origin.tilePosX() + tileOffsetX, tileYLeft = origin.tilePosY() + tileOffsetY)) || (tile = this.createTile(anchorXLeft = tileXLeft * 16, anchorYLeft = tileYLeft * 16, atSurface, caveY)) == null)) {
            this.tiles.put(vec, tile);
            loadQueue.add(() -> this.triggerNeighbourLoad(tile, atSurface, caveY, mapOrigin));
        }
    }

    private static class_2960 getTileRl(int tileX, int tileY) {
        return AxolotlClientWaypoints.rl("world_map/tile_" + tileX + "_" + tileY);
    }

    private LazyTile createTile(int anchorX, int anchorZ, boolean atSurface, int caveY) {
        return WorldMapScreen.createTile(this.field_22787, anchorX, anchorZ, atSurface, caveY);
    }

    private static LazyTile createTile(class_310 minecraft, int anchorX, int anchorZ, boolean atSurface, int caveY) {
        class_2791 tileChunk;
        anchorZ -= anchorZ % 16;
        anchorX -= anchorX % 16;
        class_638 level = minecraft.field_1687;
        int tileX = anchorX / 16;
        int tileY = anchorZ / 16;
        if (anchorX < 0 && anchorX % 16 != 0) {
            --tileX;
        }
        if (anchorZ < 0 && anchorZ % 16 != 0) {
            --tileY;
        }
        if ((tileChunk = level.method_8402(tileX, tileY, class_2806.field_12803, false)) != null) {
            int finalTileX = tileX;
            int finalTileY = tileY;
            return new LazyTile(tileX, tileY, () -> Tile.create(finalTileX, finalTileY, tileChunk));
        }
        return null;
    }

    public static void saveLoadedChunkTile(class_1923 pos) {
        class_2791 tileChunk;
        class_310 minecraft = class_310.method_1551();
        int anchorX = pos.method_8326();
        int anchorZ = pos.method_8328();
        anchorZ -= anchorZ % 16;
        anchorX -= anchorX % 16;
        class_638 level = minecraft.field_1687;
        int tileX = anchorX / 16;
        int tileY = anchorZ / 16;
        if (anchorX < 0 && anchorX % 16 != 0) {
            --tileX;
        }
        if (anchorZ < 0 && anchorZ % 16 != 0) {
            --tileY;
        }
        if ((tileChunk = level.method_8402(tileX, tileY, class_2806.field_12803, false)) != null) {
            Path dir = WorldMapScreen.getCurrentLevelMapSaveDir();
            Path out = dir.resolve("%d_%d%s".formatted(tileX, tileY, ".bin"));
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
                new LevelChunkStorage.Entry(tileChunk).write(out);
            }
            catch (IOException e) {
                log.warn("Failed to save tile at {}, {}", new Object[]{tileX, tileY, e});
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!super.method_25402(mouseX, mouseY, button)) {
            if (button == 1) {
                if (this.hoveredWaypoint != null) {
                    this.field_22787.method_1507((class_437)new ContextMenuScreen((class_437)this, mouseX, mouseY, (ContextMenuScreen.Type)new ContextMenuScreen.Type.Waypoint(this.hoveredWaypoint)));
                } else {
                    int worldX = this.getWorldX((int)mouseX);
                    int worldZ = this.getWorldZ((int)mouseY);
                    this.field_22787.method_1507((class_437)new ContextMenuScreen((class_437)this, mouseX, mouseY, (ContextMenuScreen.Type)new ContextMenuScreen.Type.Map(this.dimension.toString(), worldX, this.getY(worldX, worldZ), worldZ)));
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!super.method_25403(mouseX, mouseY, button, dragX, dragY)) {
            if (button == 0) {
                this.dragOffset.add((float)dragX, (float)dragY, 0.0f);
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!super.method_25401(mouseX, mouseY, scrollX, scrollY)) {
            if (scrollY > 0.0) {
                this.scale *= 2.0f;
                float offsetX = (float)this.field_22789 / 2.0f + this.dragOffset.x();
                float offsetY = (float)this.field_22790 / 2.0f + this.dragOffset.y();
                double mirroredOnOffsetX = (double)offsetX - (mouseX - (double)offsetX);
                double mirroredOnOffsetY = (double)offsetY - (mouseY - (double)offsetY);
                this.dragOffset.set(mirroredOnOffsetX - (double)((float)this.field_22789 / 2.0f), mirroredOnOffsetY - (double)((float)this.field_22790 / 2.0f), 0.0);
            } else {
                this.scale /= 2.0f;
                float offsetX = (float)this.field_22789 / 2.0f + this.dragOffset.x();
                float offsetY = (float)this.field_22790 / 2.0f + this.dragOffset.y();
                double mirroredOnOffsetX = (double)offsetX + (mouseX - (double)offsetX) / 2.0;
                double mirroredOnOffsetY = (double)offsetY + (mouseY - (double)offsetY) / 2.0;
                this.dragOffset.set(mirroredOnOffsetX - (double)((float)this.field_22789 / 2.0f), mirroredOnOffsetY - (double)((float)this.field_22790 / 2.0f), 0.0);
            }
        }
        return true;
    }

    protected void method_25426() {
        this.method_37063((class_364)new class_344(4, this.field_22790 - 20, 16, 16, new class_8666(OPTIONS_SPRITE, OPTIONS_SPRITE, OPTIONS_HOVERED_SPRITE), btn -> this.field_22787.method_1507(AxolotlClientWaypoints.createOptionsScreen(this)), AxolotlClientWaypoints.tr("options", new Object[0])));
        var slider = this.method_37063((class_364)new class_357(this.field_22789 - 150, 20, 150, 20, AxolotlClientWaypoints.tr("player_y", new Object[0]), 0.0){
            final int min;
            final int max;
            {
                this.min = ((WorldMapScreen)WorldMapScreen.this).field_22787.field_1687.method_31607() - 1;
                this.max = ((WorldMapScreen)WorldMapScreen.this).field_22787.field_1687.method_31600() + 1;
            }

            protected void method_25346() {
                if (this.field_22753 == 0.0) {
                    this.method_25355(AxolotlClientWaypoints.tr("player_y", new Object[0]));
                } else {
                    this.method_25355((class_2561)class_2561.method_43470((String)String.valueOf(WorldMapScreen.this.caveY - 1)));
                }
            }

            protected void method_25344() {
                WorldMapScreen.this.caveY = (int)((double)this.min + (double)(this.max - this.min) * this.field_22753);
                WorldMapScreen.this.atSurface = false;
                if (this.field_22753 == 0.0) {
                    WorldMapScreen.this.collectPlayerYData();
                }
                WorldMapScreen.this.updateTiles();
            }
        });
        this.method_37063((class_364)new DropdownButton(this.field_22789 - 20, 0, 20, 20, AxolotlClientWaypoints.tr("open_dropdown", new Object[0]), (btn, val) -> {
            slider.field_22764 = val;
        }));
        slider.field_22764 = false;
        this.optionUpdate = () -> {
            boolean updated;
            boolean allowsCaves = allowCaves || allowCavesNether && this.field_22787.field_1687.method_8597().comp_643();
            boolean bl = updated = slider.field_22763 != allowsCaves;
            if (updated) {
                slider.field_22763 = allowsCaves;
                if (!allowsCaves) {
                    this.atSurface = true;
                    this.updateTiles();
                } else {
                    slider.method_25344();
                }
            }
        };
        AxolotlClientWaypoints.NETWORK_LISTENER.postReceive.add(this.optionUpdate);
        this.optionUpdate.run();
        if (this.tiles.isEmpty()) {
            if (!this.initializedOnce) {
                this.collectPlayerYData();
            }
            CompletableFuture.runAsync(() -> {
                this.loadSavedTiles();
                this.createTiles();
            });
        }
        this.initializedOnce = true;
    }

    private void updateTiles() {
        CompletableFuture.runAsync(() -> this.tiles.values().forEach(t -> t.update(this.caveY, this.atSurface, (class_1937)this.field_22787.field_1687)));
    }

    private void loadSavedTiles() {
        Path dir = WorldMapScreen.getCurrentLevelMapSaveDir();
        if (Files.exists(dir, new LinkOption[0])) {
            try (Stream<Path> s = Files.list(dir);){
                s.forEach(file -> {
                    int y;
                    String name = file.getFileName().toString();
                    if (!name.endsWith(".bin")) {
                        return;
                    }
                    String[] coords = (name = name.substring(0, name.indexOf("."))).split("_");
                    int x = Integer.parseInt(coords[0]);
                    Vector2i key = new Vector2i(x, y = Integer.parseInt(coords[1]));
                    if (!this.tiles.containsKey(key)) {
                        try {
                            LazyTile tile = new LazyTile(x, y, () -> {
                                try {
                                    return Tile.read(file, (class_1937)this.field_22787.field_1687);
                                }
                                catch (IOException e) {
                                    return null;
                                }
                            });
                            this.tiles.put(key, tile);
                        }
                        catch (Exception e) {
                            log.warn("Failed to load tile at {}, {}", new Object[]{x, y, e});
                        }
                    }
                });
            }
            catch (IOException e) {
                log.info("Failed to load saved world map tiles!", (Throwable)e);
            }
        }
    }

    private void saveTiles() {
        Path dir = WorldMapScreen.getCurrentLevelMapSaveDir();
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            this.tiles.values().forEach(tile -> WorldMapScreen.saveTile(tile, dir));
        }
        catch (IOException e) {
            log.error("Failed to create world map save dir!", (Throwable)e);
        }
    }

    private static void saveTile(LazyTile tile, Path dir) {
        try {
            tile.save(dir);
        }
        catch (IOException e) {
            log.warn("Failed to save tile at {}, {}", new Object[]{tile.tilePosX(), tile.tilePosY(), e});
        }
    }

    private static Path getCurrentLevelMapSaveDir() {
        return AxolotlClientWaypoints.getCurrentStorageDir().resolve("worldmap");
    }

    public void method_25432() {
        if (this.optionUpdate != null) {
            AxolotlClientWaypoints.NETWORK_LISTENER.postReceive.remove(this.optionUpdate);
        }
        if (this.field_22787.field_1755 == null) {
            this.saveTiles();
            this.tiles.values().forEach(LazyTile::release);
            this.tiles.clear();
        }
    }

    private static class LazyTile {
        private Tile tile;
        private final int tilePosX;
        private final int tilePosY;
        private final Supplier<Tile> supplier;
        private final Vector3f pos = new Vector3f();
        private boolean loaded;

        public void render(class_332 guiGraphics, float playerX, float playerZ, float scale, float delta, int caveY, boolean atSurface) {
            float x = (float)(this.tilePosX() * 16) - playerX;
            float y = (float)(this.tilePosY() * 16) - playerZ;
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(x, y, 0.0f);
            this.pos.zero();
            guiGraphics.method_51448().method_23760().method_23761().transformPosition(this.pos);
            if (this.pos.x + 16.0f * scale >= 0.0f && this.pos.x < (float)guiGraphics.method_51421() && this.pos.y + 16.0f * scale >= 0.0f && this.pos.y < (float)guiGraphics.method_51443()) {
                if (this.tile == null) {
                    if (!this.loaded) {
                        this.load().thenRunAsync(() -> {
                            if (this.tile != null) {
                                this.tile.update(caveY, atSurface, (class_1937)class_310.method_1551().field_1687);
                            }
                        });
                    }
                } else {
                    guiGraphics.method_25290(this.tile.rl(), 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
                }
            }
            guiGraphics.method_51448().method_22909();
        }

        public CompletableFuture<?> load() {
            if (!this.loaded) {
                this.loaded = true;
                return class_310.method_1551().method_5385(this.supplier).thenApply(t -> {
                    this.tile = t;
                    return this.tile;
                });
            }
            return CompletableFuture.completedFuture(null);
        }

        public void release() {
            if (this.tile != null) {
                this.tile.release();
                this.tile = null;
            }
        }

        public void save(Path dir) throws IOException {
            if (this.tile != null) {
                this.tile.save(dir);
            }
        }

        public void update(int caveY, boolean atSurface, class_1937 level) {
            if (this.tile != null) {
                this.tile.update(caveY, atSurface, level);
            }
        }

        @Generated
        public LazyTile(int tilePosX, int tilePosY, Supplier<Tile> supplier) {
            this.tilePosX = tilePosX;
            this.tilePosY = tilePosY;
            this.supplier = supplier;
        }

        @Generated
        public int tilePosX() {
            return this.tilePosX;
        }

        @Generated
        public int tilePosY() {
            return this.tilePosY;
        }
    }

    private record Tile(int tilePosX, int tilePosY, class_2960 rl, class_1043 tex, LevelChunkStorage.Entry chunk) {
        public static final String FILE_EXTENSION = ".bin";

        public void release() {
            class_310.method_1551().method_1531().method_4615(this.rl);
        }

        public void save(Path dir) throws IOException {
            Path out = dir.resolve("%d_%d%s".formatted(this.tilePosX, this.tilePosY, FILE_EXTENSION));
            this.chunk.write(out);
        }

        public static Tile create(int x, int y, class_2791 chunk) {
            return Tile.create(x, y, new LevelChunkStorage.Entry(chunk));
        }

        public static Tile create(int x, int y, LevelChunkStorage.Entry chunk) {
            class_2960 rl = WorldMapScreen.getTileRl(x, y);
            class_1043 tex = new class_1043(new class_1011(16, 16, false));
            tex.method_4525().method_4326(0, 0, 16, 16, Colors.BLACK.toInt());
            class_310.method_1551().method_1531().method_4616(rl, (class_1044)tex);
            return new Tile(x, y, rl, tex, chunk);
        }

        public static Tile read(Path p, class_1937 level) throws IOException {
            String name = p.getFileName().toString();
            name = name.substring(0, name.indexOf("."));
            String[] coords = name.split("_");
            int x = Integer.parseInt(coords[0]);
            int y = Integer.parseInt(coords[1]);
            return Tile.create(x, y, LevelChunkStorage.Entry.read(p, level));
        }

        public void update(int caveY, boolean atSurface, class_1937 level) {
            class_2818 levelChunk;
            class_2791 class_27912 = this.chunk.chunk();
            if (class_27912 instanceof class_2818 && (levelChunk = (class_2818)class_27912).method_12223()) {
                this.tex.method_4525().method_4326(0, 0, 16, 16, Colors.BLACK.toInt());
                this.tex.method_4524();
                return;
            }
            int levelMinY = level.method_31607();
            int centerX = this.tilePosX * 16 + 8;
            int centerZ = this.tilePosY * 16 + 8;
            class_1011 pixels = this.tex.method_4525();
            int size = pixels.method_4307();
            int texHalfWidth = size / 2;
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            class_2338.class_2339 mutableBlockPos2 = new class_2338.class_2339();
            boolean updated = false;
            for (int x = 0; x < size; ++x) {
                double d = 0.0;
                for (int z = -1; z < size; ++z) {
                    int color;
                    class_2680 blockState;
                    int chunkX = centerX + x - texHalfWidth;
                    int chunkZ = centerZ + z - texHalfWidth;
                    int fluidDepth = 0;
                    double e = 0.0;
                    mutableBlockPos.method_10103(chunkX, 0, chunkZ);
                    if (z < 0 || z >= 16) {
                        mutableBlockPos.method_33099(chunkZ + 1);
                    }
                    class_2791 levelChunk2 = this.chunk.chunk();
                    int y = levelChunk2.method_12005(class_2902.class_2903.field_13202, mutableBlockPos.method_10263(), mutableBlockPos.method_10260()) + 1;
                    if (!atSurface) {
                        y = Math.min(y, caveY);
                    }
                    if (y <= levelMinY) {
                        blockState = class_2246.field_10124.method_9564();
                    } else {
                        do {
                            mutableBlockPos.method_33098(--y);
                        } while ((blockState = levelChunk2.method_8320((class_2338)mutableBlockPos)).method_26205((class_1922)level, (class_2338)mutableBlockPos) == class_3620.field_16008 && y > levelMinY);
                        if (y > levelMinY && !blockState.method_26227().method_15769()) {
                            class_2680 blockState2;
                            int highestFullBlockY = y - 1;
                            mutableBlockPos2.method_10101((class_2382)mutableBlockPos);
                            do {
                                mutableBlockPos2.method_33098(highestFullBlockY--);
                                blockState2 = levelChunk2.method_8320((class_2338)mutableBlockPos2);
                                ++fluidDepth;
                            } while (highestFullBlockY > levelMinY && !blockState2.method_26227().method_15769());
                            class_3610 fluidState = blockState.method_26227();
                            blockState = !fluidState.method_15769() && !blockState.method_26206((class_1922)level, (class_2338)mutableBlockPos, class_2350.field_11036) ? fluidState.method_15759() : blockState;
                        }
                    }
                    e += (double)y;
                    class_3620 mapColor = blockState.method_26205((class_1922)level, (class_2338)mutableBlockPos);
                    if (mapColor == class_3620.field_16019) {
                        class_2680 floorBlock = levelChunk2.method_8320((class_2338)mutableBlockPos2);
                        int floorColor = floorBlock.method_26205((class_1922)level, (class_2338)mutableBlockPos2).field_16011;
                        int biomeColor = mapColor.field_16011;
                        float shade = level.method_24852(class_2350.field_11036, true);
                        int waterColor = biomeColor;
                        waterColor = ARGB.colorFromFloat((float)1.0f, (float)(ARGB.redFloat((int)waterColor) * shade), (float)(ARGB.greenFloat((int)waterColor) * shade), (float)(ARGB.blueFloat((int)waterColor) * shade));
                        color = waterColor = ARGB.average((int)waterColor, (int)ARGB.scaleRGB((int)floorColor, (float)(1.0f - (float)fluidDepth / 15.0f)));
                    } else {
                        double f = (e - d) * 4.0 / 5.0 + ((double)(x + z & 1) - 0.5) * 0.4;
                        class_3620.class_6594 brightness = f > 0.6 ? class_3620.class_6594.field_34761 : (f < -0.6 ? class_3620.class_6594.field_34759 : class_3620.class_6594.field_34760);
                        color = mapColor.method_15820(brightness);
                    }
                    d = e;
                    if (z < 0 || Integer.rotateRight(pixels.method_4315(x, z), 4) == color) continue;
                    pixels.method_4305(x, z, ARGB.opaque((int)color));
                    updated = true;
                }
            }
            if (updated) {
                class_310.method_1551().method_20493(() -> ((class_1043)this.tex).method_4524());
            }
        }
    }
}

