/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.waypoints.network;

import io.github.axolotlclient.waypoints.AxolotlClientWaypoints;
import io.github.axolotlclient.waypoints.map.WorldMapScreen;
import io.github.axolotlclient.waypoints.network.Payload;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Listener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Listener.class);
    public List<Runnable> postReceive = new ArrayList<Runnable>();
    private boolean receivedPayload;

    public void init() {
        PayloadTypeRegistry.configurationS2C().register(Payload.TYPE, Payload.CODEC);
        PayloadTypeRegistry.playS2C().register(Payload.TYPE, Payload.CODEC);
        ClientConfigurationConnectionEvents.INIT.register((listener, mc) -> ClientConfigurationNetworking.registerGlobalReceiver(Payload.TYPE, (payload, context) -> this.receiveConfig((Payload)payload)));
        ClientPlayConnectionEvents.INIT.register((handler, client) -> ClientPlayNetworking.registerGlobalReceiver(Payload.TYPE, (payload, context) -> this.receiveConfig((Payload)payload)));
        ClientReceiveMessageEvents.GAME.register((message, overlay) -> {
            String msg;
            if (this.receivedPayload) {
                return;
            }
            switch (msg = message.getString()) {
                case "\u00a7f\u00a7a\u00a7i\u00a7r\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o": {
                    this.disableCaves();
                    break;
                }
                case "\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o\u00a7w\u00a7m\u00a7n\u00a7e\u00a7t\u00a7h\u00a7e\u00a7r\u00a7i\u00a7s\u00a7f\u00a7a\u00a7i\u00a7r": {
                    WorldMapScreen.allowCavesNether = true;
                    break;
                }
                case "\u00a7n\u00a7o\u00a7m\u00a7i\u00a7n\u00a7i\u00a7m\u00a7a\u00a7p": {
                    this.disableMinimap();
                    break;
                }
                case "\u00a7r\u00a7e\u00a7s\u00a7e\u00a7t\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o": {
                    this.reset();
                }
            }
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            this.reset();
            this.receivedPayload = false;
        });
    }

    private void receiveConfig(Payload payload) {
        this.receivedPayload = true;
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            log.info("Received server configuration: {}", (Object)payload);
        }
        this.reset();
        if (payload.disableMinimap()) {
            this.disableMinimap();
        }
        if (payload.disableMinimapCaves()) {
            AxolotlClientWaypoints.MINIMAP.allowCaves = false;
        }
        if (payload.disableWorldmapCaves()) {
            WorldMapScreen.allowCaves = false;
            if (payload.allowWorldmapCavesNether()) {
                WorldMapScreen.allowCavesNether = true;
            }
        }
        this.postReceive.forEach(Runnable::run);
    }

    private void disableMinimap() {
        AxolotlClientWaypoints.MINIMAP.enabled.force(true, false);
    }

    private void disableCaves() {
        AxolotlClientWaypoints.MINIMAP.allowCaves = false;
        WorldMapScreen.allowCaves = true;
    }

    private void reset() {
        AxolotlClientWaypoints.MINIMAP.enabled.force(false, false);
        AxolotlClientWaypoints.MINIMAP.allowCaves = true;
        WorldMapScreen.allowCaves = true;
        WorldMapScreen.allowCavesNether = false;
    }
}

