/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.waypoints.waypoints;

import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.waypoints.AxolotlClientWaypoints;
import io.github.axolotlclient.waypoints.mixin.GameRendererAccessor;
import io.github.axolotlclient.waypoints.waypoints.Waypoint;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3695;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class WaypointRenderer {
    private static final double CUTOFF_DIST = 5.0;
    private final class_310 minecraft = class_310.method_1551();
    private final Matrix4f view = new Matrix4f();
    private final Vector4f viewProj = new Vector4f();

    public void render(class_9779 deltaTracker) {
        if (!AxolotlClientWaypoints.renderWaypoints.get().booleanValue()) {
            return;
        }
        if (!AxolotlClientWaypoints.renderWaypointsInWorld.get().booleanValue()) {
            return;
        }
        if (this.minecraft.field_1687 == null) {
            return;
        }
        class_3695 profiler = class_310.method_1551().method_16011();
        profiler.method_15405("waypoints");
        class_4597.class_4598 bufferSource = this.minecraft.method_22940().method_23000();
        class_4587 stack = new class_4587();
        class_4184 cam = this.minecraft.field_1773.method_19418();
        stack.method_22903();
        stack.method_22907(cam.method_23767().invert());
        class_243 camPos = this.minecraft.field_1773.method_19418().method_19326();
        float fov = (float)((GameRendererAccessor)this.minecraft.field_1773).invokeGetFov(cam, deltaTracker.method_60637(true), true);
        for (Waypoint waypoint : AxolotlClientWaypoints.getCurrentWaypoints()) {
            profiler.method_15396(waypoint.name());
            this.renderWaypoint(waypoint, stack, camPos, cam, bufferSource, fov);
            profiler.method_15407();
        }
        stack.method_22909();
        bufferSource.method_37104();
        if (!stack.method_22911()) {
            throw new IllegalStateException("Pose stack not empty");
        }
    }

    private void renderWaypoint(Waypoint waypoint, class_4587 stack, class_243 camPos, class_4184 cam, class_4597.class_4598 bufferSource, float fov) {
        int textWidth = this.minecraft.field_1772.method_1727(waypoint.display());
        int width = textWidth + Waypoint.displayXOffset() * 2;
        Objects.requireNonNull(this.minecraft.field_1772);
        int textHeight = 9;
        int height = textHeight + Waypoint.displayYOffset() * 2;
        Result displayStart = this.projectToScreen(cam, fov, width, height, waypoint.x(), waypoint.y(), waypoint.z(), new Vector2f(-((float)width / 2.0f * 0.04f), (float)height / 2.0f * 0.04f));
        if (displayStart == null) {
            return;
        }
        Result displayEnd = this.projectToScreen(cam, fov, width, height, waypoint.x(), waypoint.y(), waypoint.z(), new Vector2f((float)width / 2.0f * 0.04f, -((float)height / 2.0f * 0.04f)));
        if (displayEnd == null) {
            return;
        }
        float projWidth = Math.abs(displayEnd.x() - displayStart.x());
        float projHeight = Math.abs(displayEnd.y() - displayStart.y());
        if (projWidth < (float)width && projHeight < (float)height) {
            return;
        }
        stack.method_22903();
        stack.method_22904(waypoint.x() - camPos.method_10216(), waypoint.y() - camPos.method_10214(), waypoint.z() - camPos.method_10215());
        stack.method_22907(cam.method_23767().invert(new Quaternionf()));
        float scale = 0.04f;
        stack.method_22905(scale, -scale, scale);
        this.drawFontBatch(waypoint.display(), (float)(-textWidth) / 2.0f, (float)(-textHeight) / 2.0f, stack.method_23760().method_23761(), (class_4597)bufferSource);
        this.fillRect(stack, bufferSource, (float)(-width) / 2.0f, (float)(-height) / 2.0f, -0.1f, (float)width / 2.0f, (float)height / 2.0f, waypoint.color().toInt());
        stack.method_22909();
    }

    private void fillRect(class_4587 stack, class_4597.class_4598 source, float x, float y, float z, float x2, float y2, int color) {
        class_4588 buf = source.getBuffer(class_1921.method_51784());
        Matrix4f matrix = stack.method_23760().method_23761();
        buf.method_22918(matrix, x, y, z).method_39415(color);
        buf.method_22918(matrix, x, y2, z).method_39415(color);
        buf.method_22918(matrix, x2, y2, z).method_39415(color);
        buf.method_22918(matrix, x2, y, z).method_39415(color);
    }

    private void drawFontBatch(String text, float x, float y, Matrix4f matrix, class_4597 bufferSource) {
        this.minecraft.field_1772.method_27521(text, x, y, -1, false, matrix, bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
    }

    public void renderWaypoints(class_332 graphics, class_9779 deltaTracker) {
        if (!AxolotlClientWaypoints.renderWaypoints.get().booleanValue()) {
            return;
        }
        if (!AxolotlClientWaypoints.renderWaypointsInWorld.get().booleanValue()) {
            return;
        }
        class_3695 profiler = class_310.method_1551().method_16011();
        class_4184 cam = this.minecraft.field_1773.method_19418();
        profiler.method_15396("waypoints");
        graphics.method_51448().method_22903();
        AtomicReference<Runnable> positionDrawer = new AtomicReference<Runnable>();
        for (Waypoint waypoint : AxolotlClientWaypoints.getCurrentWaypoints()) {
            graphics.method_51448().method_22903();
            this.renderWaypoint(waypoint, graphics, deltaTracker, cam, positionDrawer);
            graphics.method_51448().method_22909();
        }
        if (positionDrawer.get() != null) {
            ((Runnable)positionDrawer.get()).run();
        }
        graphics.method_51448().method_22909();
        profiler.method_15407();
    }

    private void renderWaypoint(Waypoint waypoint, class_332 graphics, class_9779 tracker, class_4184 camera, AtomicReference<Runnable> positionDrawn) {
        boolean _3dOnScreen;
        boolean outOfView;
        float projHeight;
        float projWidth;
        float tick = tracker.method_60637(true);
        double fov = ((GameRendererAccessor)this.minecraft.field_1773).invokeGetFov(camera, tick, false);
        class_4587 pose = graphics.method_51448();
        int textWidth = this.minecraft.field_1772.method_1727(waypoint.display());
        int width = textWidth + Waypoint.displayXOffset() * 2;
        Objects.requireNonNull(this.minecraft.field_1772);
        int textHeight = 9;
        int height = textHeight + Waypoint.displayYOffset() * 2;
        class_243 camPos = camera.method_19326();
        Result displayStart = this.projectToScreen(camera, fov, width, height, waypoint.x(), waypoint.y(), waypoint.z(), new Vector2f(-((float)width / 2.0f * 0.04f), (float)height / 2.0f * 0.04f));
        Result displayEnd = this.projectToScreen(camera, fov, width, height, waypoint.x(), waypoint.y(), waypoint.z(), new Vector2f((float)width / 2.0f * 0.04f, -((float)height / 2.0f * 0.04f)));
        Result result = this.projectToScreen(camera, fov, width, height, waypoint.x(), waypoint.y(), waypoint.z(), null);
        if (result == null) {
            return;
        }
        if (displayStart != null && displayEnd != null) {
            projWidth = Math.abs(displayEnd.x() - displayStart.x());
            projHeight = Math.abs(displayEnd.y() - displayStart.y());
        } else {
            projWidth = 0.0f;
            projHeight = 0.0f;
        }
        pose.method_46416(result.x(), result.y(), 0.0f);
        boolean bl = outOfView = result.x() < (float)(-width) / 2.0f || result.x() > (float)graphics.method_51421() + (float)width / 2.0f || result.y() < (float)(-height) / 2.0f || result.y() > (float)graphics.method_51443() + (float)height / 2.0f;
        if (!AxolotlClientWaypoints.renderOutOfViewWaypointsOnScreenEdge.get().booleanValue() && outOfView) {
            return;
        }
        if (displayEnd != null && displayStart != null) {
            float minX = displayStart.x();
            float minY = displayStart.y();
            float maxX = displayEnd.x();
            float maxY = displayEnd.y();
            int guiWidth = graphics.method_51421();
            int guiHeight = graphics.method_51443();
            _3dOnScreen = minX > 0.0f && minY > 0.0f && minX < (float)guiWidth && minY < (float)guiHeight || minX > 0.0f && maxY > 0.0f && minX < (float)guiWidth && maxY < (float)guiHeight || maxX > 0.0f && maxY > 0.0f && maxX < (float)guiWidth && maxY < (float)guiHeight || maxX > 0.0f && minY > 0.0f && maxX < (float)guiWidth && minY < (float)guiHeight;
        } else {
            _3dOnScreen = false;
        }
        if (positionDrawn.get() == null) {
            float f = Math.abs(result.x() - (float)graphics.method_51421() / 2.0f);
            float f2 = _3dOnScreen ? Math.max(projWidth, (float)width) : (float)width;
            if (f < f2 / 2.0f) {
                float f3 = Math.abs(result.y() - (float)graphics.method_51443() / 2.0f);
                float f4 = _3dOnScreen ? Math.max((float)height, projHeight) : (float)height;
                if (f3 < f4 / 2.0f) {
                    pose.method_22903();
                    pose.method_46416(0.0f, Math.max((float)height, projHeight + 4.0f) / 2.0f + 4.0f, 0.0f);
                    Vector3f pos = pose.method_23760().method_23761().transformPosition(new Vector3f());
                    if ((projWidth >= (float)width || projHeight >= (float)height) && _3dOnScreen) {
                        pos.y = Math.min(pos.y, displayEnd.y() + 6.0f);
                    }
                    positionDrawn.set(() -> {
                        String line1 = waypoint.name();
                        pose.method_22903();
                        pose.method_23760().method_23761().translate((Vector3fc)pos);
                        int line1W = this.minecraft.field_1772.method_1727(line1);
                        int n = -line1W / 2 - 2;
                        int n2 = line1W / 2 + 2;
                        Objects.requireNonNull(this.minecraft.field_1772);
                        graphics.method_25294(n, -2, n2, 9 + 2, Colors.GRAY.withAlpha(100).toInt());
                        int n3 = -line1W / 2 - 2;
                        Objects.requireNonNull(this.minecraft.field_1772);
                        graphics.method_49601(n3, -2, line1W + 4, 9 + 4, Colors.GRAY.toInt());
                        graphics.method_51433(this.minecraft.field_1772, line1, -line1W / 2, 0, -1, true);
                        if (!waypoint.closerToThan(camPos.method_10216(), camPos.method_10214(), camPos.method_10215(), 5.0)) {
                            Objects.requireNonNull(this.minecraft.field_1772);
                            pose.method_46416(0.0f, (float)(9 + 4), 0.0f);
                            class_2561 line2 = AxolotlClientWaypoints.tr("distance", "%.2f".formatted(waypoint.distTo(camPos.method_10216(), camPos.method_10214(), camPos.method_10215())));
                            graphics.method_51439(this.minecraft.field_1772, line2, -this.minecraft.field_1772.method_27525((class_5348)line2) / 2, 0, -1, false);
                        }
                        pose.method_22909();
                    });
                    pose.method_22909();
                }
            }
        }
        if ((projWidth >= (float)width || projHeight >= (float)height) && _3dOnScreen) {
            return;
        }
        graphics.method_25294(-width / 2, -height / 2, width / 2, height / 2, waypoint.color().toInt());
        graphics.method_51433(this.minecraft.field_1772, waypoint.display(), -textWidth / 2, -textHeight / 2, -1, false);
    }

    @Nullable
    private Result projectToScreen(class_4184 camera, double fov, int width, int height, double x, double y, double z, Vector2f orthoOffset) {
        this.viewProj.set(x, y, z, 1.0);
        if (orthoOffset != null) {
            Matrix4f vec = new Matrix4f();
            vec.rotate((Quaternionfc)camera.method_23767().invert(new Quaternionf()));
            vec.translate(orthoOffset.x(), orthoOffset.y(), 0.0f);
            vec.rotate((Quaternionfc)camera.method_23767());
            vec.transform(this.viewProj);
        }
        this.view.rotation((Quaternionfc)camera.method_23767()).translate((Vector3fc)camera.method_19326().method_46409().negate());
        Matrix4f projection = this.minecraft.field_1773.method_22973(fov);
        projection.mul((Matrix4fc)this.view);
        this.viewProj.mul((Matrix4fc)projection);
        if (orthoOffset == null && AxolotlClientWaypoints.renderOutOfViewWaypointsOnScreenEdge.get().booleanValue()) {
            this.viewProj.w = Math.max(Math.abs(this.viewProj.x()), Math.max(Math.abs(this.viewProj.y()), this.viewProj.w()));
        }
        if (this.viewProj.w() <= 0.0f) {
            return null;
        }
        this.viewProj.div(this.viewProj.w());
        float projX = this.viewProj.x();
        float projY = this.viewProj.y();
        float resultX = 0.5f * ((float)this.minecraft.method_22683().method_4486() * (projX + 1.0f) - (float)width * projX);
        float resultY = (float)this.minecraft.method_22683().method_4502() * (0.5f - projY / 2.0f) + (float)height * projY / 2.0f;
        return new Result(resultX, resultY);
    }

    private record Result(float x, float y) {
    }
}

