/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.quicksaving_common_neoforge.networking.packets;

import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import com.natamus.collective_common_neoforge.implementations.networking.data.PacketContext;
import com.natamus.collective_common_neoforge.implementations.networking.data.Side;
import com.natamus.collective_common_neoforge.services.Services;
import com.natamus.quicksaving_common_neoforge.config.ConfigHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ToServerTeleportPlayerPacket {
    public static final ResourceLocation CHANNEL = ResourceLocation.fromNamespaceAndPath((String)"quicksaving", (String)"to_server_teleport_player_packet");
    private final Vec3 teleportLocation;
    private final ResourceKey<Level> teleportDimension;

    public ToServerTeleportPlayerPacket(Vec3 teleportLocationIn, ResourceKey<Level> teleportDimensionIn) {
        this.teleportLocation = teleportLocationIn;
        this.teleportDimension = teleportDimensionIn;
    }

    public static ToServerTeleportPlayerPacket decode(FriendlyByteBuf buf) {
        Vec3 teleportLocationIn = buf.readVec3();
        ResourceKey teleportDimensionIn = buf.readResourceKey(Registries.DIMENSION);
        return new ToServerTeleportPlayerPacket(teleportLocationIn, (ResourceKey<Level>)teleportDimensionIn);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeVec3(this.teleportLocation);
        buf.writeResourceKey(this.teleportDimension);
    }

    public static void handle(PacketContext<ToServerTeleportPlayerPacket> ctx) {
        if (ctx.side().equals((Object)Side.SERVER)) {
            ToServerTeleportPlayerPacket packet = (ToServerTeleportPlayerPacket)ctx.message();
            Player player = ctx.sender();
            if (ConfigHandler.musthaveCheatAccessForQuickloadOnServer && !player.hasPermissions(2)) {
                MessageFunctions.sendMessage((Player)player, (String)"With the current server configuration, you may only quickload with cheat access enabled.", (ChatFormatting)ChatFormatting.RED);
                return;
            }
            if (!player.hasEffect(MobEffects.SLOW_FALLING)) {
                player.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 20, 255, true, false));
            }
            if (player.level().dimension().equals(packet.teleportDimension)) {
                player.teleportTo(packet.teleportLocation.x, packet.teleportLocation.y, packet.teleportLocation.z);
            } else {
                Services.TELEPORT.teleportEntity((Entity)player, packet.teleportDimension, packet.teleportLocation);
            }
            player.displayClientMessage((Component)Component.literal((String)"Quickloaded.").withStyle(ChatFormatting.DARK_GREEN), true);
        }
    }
}

