/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.quicksaving_common_neoforge.util;

import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import com.natamus.collective_common_neoforge.implementations.networking.api.Dispatcher;
import com.natamus.quicksaving_common_neoforge.config.ConfigHandler;
import com.natamus.quicksaving_common_neoforge.data.Variables;
import com.natamus.quicksaving_common_neoforge.networking.packets.ToServerTeleportPlayerPacket;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class Util {
    public static void saveCurrentLocation(LocalPlayer player) {
        if (player == null) {
            return;
        }
        if (ConfigHandler.mustCrouchForQuicksave && !player.isCrouching()) {
            return;
        }
        Variables.savedLocation = new Vec3(player.position().x, player.position().y, player.position().z);
        Variables.savedDimension = player.level().dimension();
        player.displayClientMessage((Component)Component.literal((String)"Quicksaved.").withStyle(ChatFormatting.DARK_GREEN), true);
    }

    public static void loadLastLocation(LocalPlayer player) {
        if (player == null) {
            return;
        }
        if (ConfigHandler.mustCrouchForQuickload && !player.isCrouching()) {
            return;
        }
        if (Variables.savedLocation == null || Variables.savedDimension == null) {
            return;
        }
        if (Variables.isInstalledOnServer) {
            Dispatcher.sendToServer((Object)new ToServerTeleportPlayerPacket(Variables.savedLocation, Variables.savedDimension));
        } else if (player.hasPermissions(2)) {
            if (!player.hasEffect(MobEffects.SLOW_FALLING)) {
                player.connection.sendCommand("effect give @p minecraft:slow_falling 1 255 true");
            }
            player.connection.sendCommand("execute in " + String.valueOf(Variables.savedDimension.location()) + " run tp @p " + String.format("%.2f", Variables.savedLocation.x) + " " + String.format("%.2f", Variables.savedLocation.y) + " " + String.format("%.2f", Variables.savedLocation.z));
            player.displayClientMessage((Component)Component.literal((String)"Quickloaded.").withStyle(ChatFormatting.DARK_GREEN), true);
        } else {
            MessageFunctions.sendMessage((Player)player, (String)"In order to quickload, you'll need to install the mod on the server or have cheat access.", (ChatFormatting)ChatFormatting.RED);
        }
    }
}

