/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.potionicons;

import com.mojang.serialization.Codec;
import com.samsthenerd.inline.api.InlineAPI;
import com.samsthenerd.inline.api.InlineData;
import com.samsthenerd.inline.tooltips.CustomTooltipManager;
import com.samsthenerd.potionicons.EffectDataTTProvider;
import com.samsthenerd.potionicons.PotionIconsMod;
import com.samsthenerd.potionicons.PotionIconsModClient;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;

public class EffectInlineData
implements InlineData<EffectInlineData> {
    private final Holder<MobEffect> effect;

    public EffectInlineData(Holder<MobEffect> effect) {
        this.effect = effect;
    }

    public Holder<MobEffect> getEffect() {
        return this.effect;
    }

    public InlineData.InlineDataType<EffectInlineData> getType() {
        return EffectDataType.INSTANCE;
    }

    public ResourceLocation getRendererId() {
        return PotionIconsMod.id("effect");
    }

    public Style getExtraStyle() {
        HoverEvent he = new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(CustomTooltipManager.getForTooltip((CustomTooltipManager.CustomTooltipProvider)EffectDataTTProvider.INSTANCE, this.effect)));
        return Style.EMPTY.withHoverEvent(he);
    }

    public Component addIconToPotionTooltip(Component t) {
        if (!PotionIconsModClient.getConfig().showInTooltip) {
            return t;
        }
        MutableComponent effText = t.copy();
        MutableComponent iconText = this.asText(false).copy().withStyle(sty -> InlineAPI.INSTANCE.withSizeModifier(sty, 1.25));
        return Component.empty().append((Component)iconText.copy()).append(" ").append((Component)effText);
    }

    public static class EffectDataType
    implements InlineData.InlineDataType<EffectInlineData> {
        public static EffectDataType INSTANCE = new EffectDataType();

        public ResourceLocation getId() {
            return PotionIconsMod.id("effect");
        }

        public Codec<EffectInlineData> getCodec() {
            return MobEffect.CODEC.xmap(EffectInlineData::new, EffectInlineData::getEffect);
        }
    }
}

